/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.monster;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.ribs.scguns.config.EntityEquipmentConfig;
import top.ribs.scguns.entity.ai.AIType;
import top.ribs.scguns.entity.ai.GunAttackGoal;
import top.ribs.scguns.item.GunItem;

public class AdjudicatorEntity
extends Monster
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(AdjudicatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ATTACK_TIMEOUT = SynchedEntityData.m_135353_(AdjudicatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DODGING = SynchedEntityData.m_135353_(AdjudicatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final double ALLIANCE_RANGE = 32.0;
    private static final int ALERT_RANGE_Y = 10;
    private int ticksUntilNextAlert = 0;
    private int dodgeCooldown = 0;
    private int lastDodgeTime = 0;

    public AdjudicatorEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.28).m_22268_(Attributes.f_22285_, 1.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22278_, (double)0.6f).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22281_, 4.0);
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        EntityEquipmentConfig.equipEntity((Mob)this, "scguns:adjudicator");
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(ATTACK_TIMEOUT, (Object)0);
        this.f_19804_.m_135372_(DODGING, (Object)false);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.dodgeCooldown > 0) {
                --this.dodgeCooldown;
            }
            if (this.isAttacking() && this.getAttackTimeout() > 0) {
                LivingEntity target;
                this.setAttackTimeout(this.getAttackTimeout() - 1);
                if (this.getAttackTimeout() == 6 && (target = this.m_5448_()) != null && this.m_20280_((Entity)target) <= (double)(this.m_20205_() * 2.0f * this.m_20205_() * 2.0f + target.m_20205_())) {
                    this.m_7327_((Entity)target);
                }
                if (this.getAttackTimeout() <= 0) {
                    this.setAttacking(false);
                }
            }
            if (this.m_5448_() != null) {
                this.maybeAlertAllies();
                if (this.m_21223_() < this.m_21233_() * 0.35f) {
                    this.attemptEvasiveDodge();
                }
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.isDodging() && !this.m_20096_() && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.85, 1.0));
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        boolean wasHurt = super.m_6469_(pSource, pAmount);
        if (wasHurt && !this.m_9236_().f_46443_ && !this.m_21224_() && this.m_21223_() < this.m_21233_() * 0.35f && this.dodgeCooldown <= 0 && this.f_19796_.m_188501_() < 0.6f) {
            this.performDodgeLeap(pSource);
        }
        return wasHurt;
    }

    private void attemptEvasiveDodge() {
        float dodgeChance;
        if (this.dodgeCooldown > 0 || !this.m_20096_() || this.m_21224_()) {
            return;
        }
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return;
        }
        double distance = this.m_20280_((Entity)target);
        float f = dodgeChance = distance < 64.0 ? 0.08f : 0.03f;
        if (this.f_19796_.m_188501_() < dodgeChance) {
            this.performDodgeLeap(null);
        }
    }

    private void performDodgeLeap(DamageSource damageSource) {
        Vec3 dodgeDirection;
        if (this.m_21224_()) {
            return;
        }
        this.setDodging(true);
        if (damageSource != null && damageSource.m_7639_() != null) {
            Vec3 awayFromSource = this.m_20182_().m_82546_(damageSource.m_7639_().m_20182_()).m_82541_();
            double angle = (this.f_19796_.m_188500_() - 0.5) * Math.PI * 0.6;
            dodgeDirection = awayFromSource.m_82524_((float)angle);
        } else if (this.m_5448_() != null) {
            Vec3 toTarget = this.m_5448_().m_20182_().m_82546_(this.m_20182_()).m_82541_();
            double angle = this.f_19796_.m_188499_() ? 1.5707963267948966 : -1.5707963267948966;
            dodgeDirection = toTarget.m_82524_((float)angle);
        } else {
            double randomAngle = this.f_19796_.m_188500_() * Math.PI * 2.0;
            dodgeDirection = new Vec3(Math.cos(randomAngle), 0.0, Math.sin(randomAngle));
        }
        double leapPower = 0.9 + this.f_19796_.m_188500_() * 0.4;
        double verticalBoost = 0.5 + this.f_19796_.m_188500_() * 0.3;
        this.m_20334_(dodgeDirection.f_82479_ * leapPower, verticalBoost, dodgeDirection.f_82481_ * leapPower);
        this.m_9236_().m_7605_((Entity)this, (byte)8);
        this.m_5496_(SoundEvents.f_12363_, 0.8f, 1.2f + this.f_19796_.m_188501_() * 0.3f);
        this.dodgeCooldown = 25 + this.f_19796_.m_188503_(35);
        this.lastDodgeTime = this.f_19797_;
        this.m_9236_().m_7654_().execute(() -> {
            try {
                Thread.sleep(400L);
                if (this.m_6084_()) {
                    this.setDodging(false);
                }
            }
            catch (InterruptedException e) {
                this.setDodging(false);
            }
        });
    }

    public void m_7822_(byte pId) {
        if (pId == 8) {
            if (this.m_9236_().f_46443_) {
                for (int i = 0; i < 12; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + this.f_19796_.m_188500_() * 0.5, this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), (this.f_19796_.m_188500_() - 0.5) * 0.3, 0.1, (this.f_19796_.m_188500_() - 0.5) * 0.3);
                }
            }
        } else {
            super.m_7822_(pId);
        }
    }

    protected void m_8099_() {
        ItemStack mainHandItem = this.m_21205_();
        boolean hasGun = mainHandItem.m_41720_() instanceof GunItem;
        if (hasGun) {
            this.f_21345_.m_25352_(1, new GunAttackGoal<AdjudicatorEntity>(this, mainHandItem, 1.0f, AIType.TACTICAL, 3));
        } else {
            this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

                protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
                    if (pDistToEnemySqr <= this.m_6639_(pEnemy) && this.m_25565_() <= 0 && !AdjudicatorEntity.this.isAttacking()) {
                        AdjudicatorEntity.this.setAttacking(true);
                        this.m_25563_();
                        this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
                    }
                }

                protected double m_6639_(LivingEntity pEnemy) {
                    return super.m_6639_(pEnemy) * 1.3;
                }
            });
        }
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.9));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean m_8036_() {
                if (this.f_26135_.m_21188_() instanceof AdjudicatorEntity) {
                    return false;
                }
                return super.m_8036_();
            }
        }.m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, player -> !((Player)player).m_7500_() && !player.m_5833_()));
    }

    public boolean m_6779_(LivingEntity target) {
        if (target instanceof AdjudicatorEntity) {
            return false;
        }
        return super.m_6779_(target);
    }

    private void maybeAlertAllies() {
        if (this.ticksUntilNextAlert > 0) {
            --this.ticksUntilNextAlert;
        } else {
            if (this.m_21574_().m_148306_((Entity)this.m_5448_())) {
                this.alertAllies();
            }
            this.ticksUntilNextAlert = 20 + this.f_19796_.m_188503_(20);
        }
    }

    private void alertAllies() {
        AABB alertArea = AABB.m_82333_((Vec3)this.m_20182_()).m_82377_(32.0, 10.0, 32.0);
        this.m_9236_().m_6443_(AdjudicatorEntity.class, alertArea, EntitySelector.f_20408_).stream().filter(entity -> entity != this).filter(entity -> entity.m_5448_() == null).filter(entity -> !entity.m_7307_((Entity)this.m_5448_())).forEach(entity -> entity.m_6710_(this.m_5448_()));
    }

    public void m_6710_(@Nullable LivingEntity target) {
        if (target instanceof AdjudicatorEntity) {
            return;
        }
        if (this.m_5448_() == null && target != null) {
            this.ticksUntilNextAlert = this.f_19796_.m_188503_(20);
        }
        super.m_6710_(target);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
        if (attacking) {
            this.setAttackTimeout(12);
        }
    }

    public void setAttackTimeout(int timeout) {
        this.f_19804_.m_135381_(ATTACK_TIMEOUT, (Object)timeout);
    }

    public int getAttackTimeout() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TIMEOUT);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public void setDodging(boolean dodging) {
        this.f_19804_.m_135381_(DODGING, (Object)dodging);
    }

    public boolean isDodging() {
        return (Boolean)this.f_19804_.m_135370_(DODGING);
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12356_;
    }

    @NotNull
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return SoundEvents.f_12360_;
    }

    @NotNull
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12359_;
    }

    public void m_6504_(@NotNull LivingEntity target, float distanceFactor) {
        this.m_7327_((Entity)target);
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("AlertCooldown", this.ticksUntilNextAlert);
        tag.m_128405_("DodgeCooldown", this.dodgeCooldown);
        tag.m_128405_("LastDodgeTime", this.lastDodgeTime);
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.ticksUntilNextAlert = tag.m_128451_("AlertCooldown");
        this.dodgeCooldown = tag.m_128451_("DodgeCooldown");
        this.lastDodgeTime = tag.m_128451_("LastDodgeTime");
    }
}

