/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.monster;

import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.ribs.scguns.Config;
import top.ribs.scguns.config.EntityEquipmentConfig;
import top.ribs.scguns.entity.monster.SignalBeaconEntity;
import top.ribs.scguns.init.ModEntities;
import top.ribs.scguns.init.ModTags;

public class CogMinionEntity
extends Monster {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(CogMinionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ATTACK_TIMEOUT = SynchedEntityData.m_135353_(CogMinionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();

    public CogMinionEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21553_(true);
    }

    private boolean isHoldingExplosiveBlock() {
        ItemStack mainHandItem = this.m_21205_();
        return mainHandItem.m_204117_(ModTags.Items.EXPLOSIVE_BLOCK);
    }

    private void explodeIfHoldingExplosive() {
        if (this.isHoldingExplosiveBlock() && !this.m_9236_().f_46443_) {
            this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 5.0f, false, Level.ExplosionInteraction.MOB);
            this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_7301_(@NotNull MobEffectInstance pPotionEffect) {
        MobEffect effect = pPotionEffect.m_19544_();
        if (effect == MobEffects.f_19614_ || effect == MobEffects.f_19615_ || effect == MobEffects.f_19612_ || effect == MobEffects.f_19605_ || effect == MobEffects.f_19618_ || effect == MobEffects.f_19604_ || effect == MobEffects.f_19610_ || effect == MobEffects.f_19613_ || effect == MobEffects.f_19597_ || effect == MobEffects.f_19599_ || effect == MobEffects.f_19602_ || effect == MobEffects.f_19601_) {
            return false;
        }
        return super.m_7301_(pPotionEffect);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22285_, 0.5).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22282_, 0.8).m_22268_(Attributes.f_22281_, 4.0);
    }

    public void m_6667_(DamageSource source) {
        float spawnChance;
        super.m_6667_(source);
        if (!this.m_9236_().f_46443_ && source.m_7639_() instanceof Player && (spawnChance = ((Double)Config.COMMON.gameplay.cogBeaconSpawnChance.get()).floatValue()) > 0.0f && this.f_19796_.m_188501_() < spawnChance) {
            SignalBeaconEntity beacon = new SignalBeaconEntity((EntityType<? extends Mob>)((EntityType)ModEntities.SIGNAL_BEACON.get()), this.m_9236_());
            beacon.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
            this.m_9236_().m_7967_((Entity)beacon);
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        EntityEquipmentConfig.equipEntity((Mob)this, "scguns:cog_minion");
        return pSpawnData;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.isAttacking() && this.getAttackTimeout() > 0) {
            boolean didHurt;
            LivingEntity target;
            this.setAttackTimeout(this.getAttackTimeout() - 1);
            if (this.getAttackTimeout() == 6 && (target = this.m_5448_()) != null && this.m_20280_((Entity)target) <= (double)(this.m_20205_() * 2.0f * this.m_20205_() * 2.0f + target.m_20205_()) && (didHurt = this.m_7327_((Entity)target))) {
                this.explodeIfHoldingExplosive();
            }
            if (this.getAttackTimeout() <= 0) {
                this.setAttacking(false);
            }
        }
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        if (this.isAttacking()) {
            this.idleAnimationState.m_216973_();
            this.attackAnimationState.m_216982_(this.f_19797_);
        } else {
            this.attackAnimationState.m_216973_();
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
    }

    public boolean m_7243_(ItemStack pStack) {
        return this.m_7252_(pStack);
    }

    public boolean m_7066_(ItemStack stack) {
        EquipmentSlot slot = Mob.m_147233_((ItemStack)stack);
        if (!this.m_6844_(slot).m_41619_()) {
            return false;
        }
        return slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.HEAD;
    }

    public boolean m_7808_(ItemStack candidate, ItemStack existing) {
        if (existing.m_41619_()) {
            EquipmentSlot slot = Mob.m_147233_((ItemStack)candidate);
            return slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.HEAD;
        }
        return false;
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
        if (attacking) {
            this.setAttackTimeout(12);
        }
    }

    public void setAttackTimeout(int timeout) {
        this.f_19804_.m_135381_(ATTACK_TIMEOUT, (Object)timeout);
    }

    public int getAttackTimeout() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TIMEOUT);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(ATTACK_TIMEOUT, (Object)0);
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    protected Vec3i m_213552_() {
        return new Vec3i(3, 3, 3);
    }

    protected void m_7581_(ItemEntity pItemEntity) {
        super.m_7581_(pItemEntity);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
                if (pDistToEnemySqr <= this.m_6639_(pEnemy) && this.m_25565_() <= 0 && !CogMinionEntity.this.isAttacking()) {
                    CogMinionEntity.this.setAttacking(true);
                    this.m_25563_();
                    this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
                }
            }

            protected void m_25563_() {
                this.m_183277_(25);
            }
        });
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{CogMinionEntity.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(3, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 1.0, 30.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public boolean m_7252_(ItemStack stack) {
        return true;
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12010_;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12008_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12059_;
    }
}

