/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.monster;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.entity.monster.SkyCarrierEntity;
import top.ribs.scguns.init.ModEntities;

public class SignalBeaconEntity
extends Mob {
    private static final int LIFESPAN_TICKS = 100;
    private int lifespan = 100;
    private boolean hasSpawnedCarriers = false;

    public SignalBeaconEntity(EntityType<? extends Mob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public int getRemainingLifespan() {
        return this.lifespan;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22277_, 0.0).m_22268_(Attributes.f_22285_, (double)0.1f).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22281_, 0.0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!(this.m_9236_().m_5776_() || --this.lifespan > 0 || this.hasSpawnedCarriers || this.m_21224_())) {
            this.hasSpawnedCarriers = true;
            this.spawnSkyCarriers();
            this.m_146870_();
        }
        if (this.f_19797_ % 20 == 0) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundEvents.f_12216_.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void m_6667_(DamageSource pDamageSource) {
        this.hasSpawnedCarriers = true;
        super.m_6667_(pDamageSource);
    }

    private void spawnSkyCarriers() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int count = 1 + this.f_19796_.m_188503_(4);
        int successfulSpawns = 0;
        int maxAttempts = count * 5;
        Vec3 beaconPosition = this.m_20182_();
        for (int attempt = 0; attempt < maxAttempts && successfulSpawns < count; ++attempt) {
            SkyCarrierEntity skyCarrier;
            Vec3 spawnPos = this.findValidSpawnPosition(serverLevel);
            if (spawnPos == null || (skyCarrier = (SkyCarrierEntity)((EntityType)ModEntities.SKY_CARRIER.get()).m_20615_((Level)serverLevel)) == null) continue;
            skyCarrier.m_7678_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, this.f_19796_.m_188501_() * 360.0f, 0.0f);
            skyCarrier.setInitialTarget(beaconPosition);
            skyCarrier.m_21566_().m_6849_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0);
            serverLevel.m_7967_((Entity)skyCarrier);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, skyCarrier.m_20185_(), skyCarrier.m_20186_(), skyCarrier.m_20189_(), 10, 0.5, 0.2, 0.2, 0.1);
            serverLevel.m_6263_(null, skyCarrier.m_20185_(), skyCarrier.m_20186_(), skyCarrier.m_20189_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 1.0f, 1.0f);
            ++successfulSpawns;
        }
    }

    private Vec3 findValidSpawnPosition(ServerLevel serverLevel) {
        for (int radiusAttempt = 0; radiusAttempt < 3; ++radiusAttempt) {
            double baseDistance = 20.0 + (double)radiusAttempt * 10.0;
            for (int positionAttempt = 0; positionAttempt < 8; ++positionAttempt) {
                double distance = baseDistance + this.f_19796_.m_188500_() * 5.0;
                double angle = this.f_19796_.m_188500_() * 2.0 * Math.PI;
                double offsetX = Math.cos(angle) * distance;
                double offsetZ = Math.sin(angle) * distance;
                for (int heightOffset = 10; heightOffset >= -5; heightOffset -= 3) {
                    double spawnZ;
                    double spawnY;
                    double spawnX = this.m_20185_() + offsetX;
                    BlockPos spawnBlockPos = new BlockPos((int)spawnX, (int)(spawnY = this.m_20186_() + (double)heightOffset), (int)(spawnZ = this.m_20189_() + offsetZ));
                    if (!this.isValidSpawnPosition(serverLevel, spawnBlockPos, spawnX, spawnY, spawnZ)) continue;
                    return new Vec3(spawnX, spawnY, spawnZ);
                }
            }
        }
        return null;
    }

    private boolean isValidSpawnPosition(ServerLevel serverLevel, BlockPos blockPos, double exactX, double exactY, double exactZ) {
        AABB boundingBox = new AABB(exactX - 1.5, exactY - 1.0, exactZ - 1.5, exactX + 1.5, exactY + 2.0, exactZ + 1.5);
        for (BlockPos pos : BlockPos.m_121976_((int)((int)boundingBox.f_82288_), (int)((int)boundingBox.f_82289_), (int)((int)boundingBox.f_82290_), (int)((int)boundingBox.f_82291_), (int)((int)boundingBox.f_82292_), (int)((int)boundingBox.f_82293_))) {
            if (serverLevel.m_8055_(pos).m_60795_() || serverLevel.m_8055_(pos).m_247087_() || !serverLevel.m_8055_(pos).m_60734_().m_49966_().m_280555_()) continue;
            return false;
        }
        BlockPos groundCheck = new BlockPos((int)exactX, (int)exactY - 5, (int)exactZ);
        for (int i = 0; i < 5 && serverLevel.m_8055_(groundCheck.m_6625_(i)).m_60795_(); ++i) {
            if (i != 4) continue;
            return false;
        }
        List entitiesInArea = serverLevel.m_45976_(Entity.class, boundingBox);
        if (!entitiesInArea.isEmpty()) {
            return false;
        }
        return serverLevel.m_6857_().m_61937_(blockPos);
    }
}

