/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.monster;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.ribs.scguns.entity.monster.HiveEntity;
import top.ribs.scguns.init.ModTags;

public class SwarmEntity
extends FlyingMob
implements Enemy {
    private static final int LIFESPAN_TICKS = 1200;
    private int lifespan;
    private boolean isActive = true;

    public SwarmEntity(EntityType<? extends SwarmEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new SwarmMoveGoal((Mob)this, 0.5f, 0.7f);
        this.f_21365_ = new SwarmLookGoal((Mob)this);
        this.lifespan = 1200;
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_6084_() {
        return !this.m_21224_() && super.m_6084_();
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        this.isActive = false;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean m_5801_() {
        return true;
    }

    public boolean m_7301_(MobEffectInstance effect) {
        if (effect.m_19544_() == MobEffects.f_19614_) {
            return false;
        }
        return super.m_7301_(effect);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && --this.lifespan <= 0) {
            this.m_146870_();
        }
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FollowHiveGoal(this, 1.0, 10.0f));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal<Monster>((Mob)this, Monster.class, true){

            public boolean m_8036_() {
                return super.m_8036_() && SwarmEntity.this.isValidTarget(this.f_26050_);
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new SwarmAttackGoal(this, 1.0));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22285_, (double)0.1f).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22281_, 1.0);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_11691_;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11741_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11740_;
    }

    private boolean isValidTarget(LivingEntity target) {
        if (target == null) {
            return false;
        }
        return !target.m_6095_().m_204039_(ModTags.Entities.NON_SWARM_TARGETED);
    }

    public class SwarmMoveGoal
    extends MoveControl {
        private final Mob mob;
        private final float speed;
        private final double maxSpeed;

        public SwarmMoveGoal(Mob mob, float speed, double maxSpeed) {
            super(mob);
            this.mob = mob;
            this.speed = speed;
            this.maxSpeed = maxSpeed;
        }

        public void m_8126_() {
            double dz;
            double dy;
            LivingEntity target;
            double dx;
            double distance;
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && this.mob.m_5448_() != null && (distance = Math.sqrt((dx = (target = this.mob.m_5448_()).m_20185_() - this.mob.m_20185_()) * dx + (dy = target.m_20186_() - this.mob.m_20186_() + (double)(target.m_20206_() / 2.0f)) * dy + (dz = target.m_20189_() - this.mob.m_20189_()) * dz)) < 10.0) {
                Vec3 desiredMovement = new Vec3(dx / distance * (double)this.speed, dy / distance * (double)this.speed, dz / distance * (double)this.speed);
                Vec3 currentMovement = this.mob.m_20184_();
                Vec3 newMovement = currentMovement.m_82549_(desiredMovement.m_82546_(currentMovement).m_82490_(0.2));
                if (newMovement.m_82553_() > this.maxSpeed) {
                    newMovement = newMovement.m_82541_().m_82490_(this.maxSpeed);
                }
                this.mob.m_20256_(newMovement);
            }
        }
    }

    public static class SwarmLookGoal
    extends LookControl {
        public SwarmLookGoal(Mob mob) {
            super(mob);
        }

        public void m_8128_() {
            if (this.f_24937_.m_5448_() != null) {
                this.f_24937_.m_21391_((Entity)this.f_24937_.m_5448_(), 30.0f, 30.0f);
            }
        }
    }

    public class FollowHiveGoal
    extends Goal {
        private final SwarmEntity swarm;
        private final double followSpeed;
        private final float maxDist;
        private HiveEntity nearestHive;

        public FollowHiveGoal(SwarmEntity swarm, double followSpeed, float maxDist) {
            this.swarm = swarm;
            this.followSpeed = followSpeed;
            this.maxDist = maxDist;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.swarm.m_5448_() == null && this.findNearestHive();
        }

        public boolean m_8045_() {
            return this.swarm.m_5448_() == null && this.nearestHive != null && this.nearestHive.m_6084_() && this.swarm.m_20280_((Entity)this.nearestHive) > (double)(this.maxDist * this.maxDist);
        }

        public void m_8056_() {
            this.swarm.m_21573_().m_5624_((Entity)this.nearestHive, this.followSpeed);
        }

        public void m_8041_() {
            this.nearestHive = null;
            this.swarm.m_21573_().m_26573_();
        }

        public void m_8037_() {
            if (this.swarm.m_20280_((Entity)this.nearestHive) > (double)(this.maxDist * this.maxDist)) {
                this.swarm.m_21573_().m_5624_((Entity)this.nearestHive, this.followSpeed);
            } else {
                this.swarm.m_21573_().m_26573_();
            }
        }

        private boolean findNearestHive() {
            List hiveList = this.swarm.m_9236_().m_45976_(HiveEntity.class, this.swarm.m_20191_().m_82400_((double)this.maxDist));
            if (hiveList.isEmpty()) {
                return false;
            }
            this.nearestHive = (HiveEntity)((Object)hiveList.get(0));
            return true;
        }
    }

    public class SwarmAttackGoal
    extends Goal {
        private final SwarmEntity swarm;
        private final double speedTowardsTarget;
        private int attackCooldown;

        public SwarmAttackGoal(SwarmEntity swarm, double speedTowardsTarget) {
            this.swarm = swarm;
            this.speedTowardsTarget = speedTowardsTarget;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            LivingEntity target = this.swarm.m_5448_();
            return target != null && target.m_6084_() && this.isValidTarget(target);
        }

        public void m_8037_() {
            LivingEntity target = this.swarm.m_5448_();
            if (target != null && this.swarm.m_20280_((Entity)target) < 9.0) {
                if (this.attackCooldown <= 0) {
                    this.swarm.m_7327_((Entity)target);
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100, 0));
                    this.attackCooldown = 20;
                } else {
                    --this.attackCooldown;
                }
            }
            this.swarm.m_21566_().m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), this.speedTowardsTarget);
        }

        private boolean isValidTarget(LivingEntity target) {
            return !target.m_6095_().m_204039_(ModTags.Entities.NON_SWARM_TARGETED);
        }
    }
}

