/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.monster;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.ribs.scguns.entity.ai.AIType;
import top.ribs.scguns.entity.ai.GunAttackGoal;
import top.ribs.scguns.init.ModItems;
import top.ribs.scguns.init.ModTags;
import top.ribs.scguns.item.GunItem;

public class ViventrumEntity
extends TamableAnimal {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(ViventrumEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ATTACK_TIMEOUT = SynchedEntityData.m_135353_(ViventrumEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> PATROLLING = SynchedEntityData.m_135353_(ViventrumEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<BlockPos>> PATROL_ORIGIN = SynchedEntityData.m_135353_(ViventrumEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Boolean> PARTYING = SynchedEntityData.m_135353_(ViventrumEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DEFENSIVE = SynchedEntityData.m_135353_(ViventrumEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ARMOR_PLATES = SynchedEntityData.m_135353_(ViventrumEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HEAVY_ARMOR_PLATES = SynchedEntityData.m_135353_(ViventrumEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int MAX_ARMOR_PLATES = 4;
    private static final int PATROL_RADIUS = 9;
    private static final int PATROL_MOVE_INTERVAL = 100;
    private static final int PATROL_DURATION = 80;
    private int patrolTimer = 0;
    private BlockPos currentPatrolTarget = null;
    private static final float DEFENSIVE_HEALTH_THRESHOLD = 0.25f;
    private static final float DEFENSIVE_ARMOR_BONUS = 15.0f;
    private static final float DEFENSIVE_DAMAGE_REDUCTION = 0.6f;

    public ViventrumEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22279_, 0.28).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22282_, (double)0.3f).m_22268_(Attributes.f_22280_, 0.3);
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.LEFT;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(ATTACK_TIMEOUT, (Object)0);
        this.f_19804_.m_135372_(PATROLLING, (Object)false);
        this.f_19804_.m_135372_(PATROL_ORIGIN, Optional.empty());
        this.f_19804_.m_135372_(PARTYING, (Object)false);
        this.f_19804_.m_135372_(DEFENSIVE, (Object)false);
        this.f_19804_.m_135372_(ARMOR_PLATES, (Object)0);
        this.f_19804_.m_135372_(HEAVY_ARMOR_PLATES, (Object)0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.m_21824_()) {
                this.updateDefensiveState();
            }
            if (this.isAttacking() && this.getAttackTimeout() > 0) {
                LivingEntity target;
                this.setAttackTimeout(this.getAttackTimeout() - 1);
                if (this.getAttackTimeout() == 5 && (target = this.m_5448_()) != null && this.m_20280_((Entity)target) <= (double)(this.m_20205_() * 2.0f * this.m_20205_() * 2.0f + target.m_20205_())) {
                    this.m_7327_((Entity)target);
                }
                if (this.getAttackTimeout() <= 0) {
                    this.setAttacking(false);
                }
            }
            if (this.isPatrolling()) {
                this.handlePatrolling();
            }
        }
    }

    private void updateDefensiveState() {
        boolean shouldBeDefensive;
        float healthPercent = this.m_21223_() / this.m_21233_();
        boolean bl = shouldBeDefensive = healthPercent <= 0.25f;
        if (shouldBeDefensive != this.isDefensive()) {
            this.setDefensive(shouldBeDefensive);
            if (shouldBeDefensive) {
                this.m_21573_().m_26573_();
                this.m_6710_(null);
            }
        }
    }

    private void handlePatrolling() {
        Optional<BlockPos> patrolOrigin = this.getPatrolOrigin();
        if (!patrolOrigin.isPresent()) {
            return;
        }
        if (this.patrolTimer <= 0) {
            if ((double)this.f_19796_.m_188501_() < 0.5) {
                this.currentPatrolTarget = patrolOrigin.get().m_7918_(this.f_19796_.m_188503_(18) - 9, 0, this.f_19796_.m_188503_(18) - 9);
                this.m_21573_().m_26519_((double)this.currentPatrolTarget.m_123341_() + 0.5, (double)this.currentPatrolTarget.m_123342_(), (double)this.currentPatrolTarget.m_123343_() + 0.5, 0.8);
                this.patrolTimer = 80;
            } else {
                this.m_21573_().m_26573_();
                this.currentPatrolTarget = null;
                this.patrolTimer = 50;
            }
        } else {
            --this.patrolTimer;
            if (this.currentPatrolTarget != null && this.m_20275_(this.currentPatrolTarget.m_123341_(), this.currentPatrolTarget.m_123342_(), this.currentPatrolTarget.m_123343_()) < 4.0) {
                this.m_21573_().m_26573_();
                this.currentPatrolTarget = null;
                this.patrolTimer = 20;
            }
        }
        if (this.m_20275_(patrolOrigin.get().m_123341_(), patrolOrigin.get().m_123342_(), patrolOrigin.get().m_123343_()) > 144.0) {
            this.m_21573_().m_26519_((double)patrolOrigin.get().m_123341_() + 0.5, (double)patrolOrigin.get().m_123342_(), (double)patrolOrigin.get().m_123343_() + 0.5, 1.0);
            this.currentPatrolTarget = null;
            this.patrolTimer = 40;
        }
    }

    protected void m_8099_() {
        ItemStack mainHandItem = this.m_21205_();
        boolean hasGun = mainHandItem.m_41720_() instanceof GunItem;
        if (!hasGun) {
            this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false){

                public boolean m_8036_() {
                    return !ViventrumEntity.this.isDefensive() && super.m_8036_();
                }

                public boolean m_8045_() {
                    return !ViventrumEntity.this.isDefensive() && super.m_8045_();
                }

                protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
                    if (pDistToEnemySqr <= this.m_6639_(pEnemy) && this.m_25565_() <= 0 && !ViventrumEntity.this.isAttacking()) {
                        ViventrumEntity.this.setAttacking(true);
                        this.m_25563_();
                        this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
                    }
                }
            });
        } else {
            int difficulty = this.m_9236_().m_46791_().m_19028_() + 1;
            this.f_21345_.m_25352_(2, (Goal)new GunAttackGoal<ViventrumEntity>(this, mainHandItem, 1.0f, AIType.SMART, difficulty){

                @Override
                public boolean m_8036_() {
                    return !ViventrumEntity.this.isDefensive() && super.m_8036_();
                }

                public boolean m_8045_() {
                    return !ViventrumEntity.this.isDefensive() && super.m_8045_();
                }
            });
        }
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        if (this.m_21824_()) {
            this.f_21345_.m_25352_(4, (Goal)new ViventrumFollowOwnerGoal(this, 1.3, 10.0f, 2.0f, false));
        }
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Zombie.class, true));
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.m_9236_().f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_() || itemstack.m_150930_(Items.f_42415_) && !this.m_21824_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            ArmorItem armorItem;
            Item droppedPlate2;
            if (player.m_6144_() && itemstack.m_41619_()) {
                ItemStack heldItem = this.m_21205_();
                if (!heldItem.m_41619_()) {
                    this.m_19983_(heldItem);
                    this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                    return InteractionResult.SUCCESS;
                }
                ItemStack helmet = this.m_6844_(EquipmentSlot.HEAD);
                if (!helmet.m_41619_()) {
                    this.m_19983_(helmet);
                    this.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
            if (player.m_6144_() && itemstack.m_41720_() == ModItems.ARMOR_PLATE.get()) {
                if (this.getArmorPlates() + this.getHeavyArmorPlates() >= 4) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.mechanical_entity.max_armor_plates"), true);
                    return InteractionResult.FAIL;
                }
                this.addArmorPlate(false);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_5496_(SoundEvents.f_11677_, 0.5f, 1.0f);
                int currentTotal = this.getArmorPlates() + this.getHeavyArmorPlates();
                player.m_5661_((Component)Component.m_237110_((String)"message.mechanical_entity.armor_plating_added", (Object[])new Object[]{currentTotal, 4}), true);
                return InteractionResult.SUCCESS;
            }
            if (player.m_6144_() && itemstack.m_41720_() == ModItems.HEAVY_ARMOR_PLATE.get()) {
                if (this.getArmorPlates() + this.getHeavyArmorPlates() >= 4) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.mechanical_entity.max_armor_plates"), true);
                    return InteractionResult.FAIL;
                }
                this.addArmorPlate(true);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_5496_(SoundEvents.f_11679_, 0.5f, 1.0f);
                int currentTotal = this.getArmorPlates() + this.getHeavyArmorPlates();
                player.m_5661_((Component)Component.m_237110_((String)"message.mechanical_entity.heavy_armor_plating_added", (Object[])new Object[]{currentTotal, 4}), true);
                return InteractionResult.SUCCESS;
            }
            if (player.m_6144_() && itemstack.m_41720_() instanceof AxeItem && (this.getArmorPlates() > 0 || this.getHeavyArmorPlates() > 0)) {
                boolean wasHeavy = this.removeArmorPlate();
                this.m_5496_(SoundEvents.f_11681_, 0.5f, 1.0f);
                ItemStack droppedPlate2 = new ItemStack(wasHeavy ? (ItemLike)ModItems.HEAVY_ARMOR_PLATE.get() : (ItemLike)ModItems.ARMOR_PLATE.get());
                this.m_19983_(droppedPlate2);
                int currentTotal = this.getArmorPlates() + this.getHeavyArmorPlates();
                player.m_5661_((Component)Component.m_237110_((String)"message.mechanical_entity.armor_plating_removed", (Object[])new Object[]{currentTotal, 4}), true);
                return InteractionResult.SUCCESS;
            }
            if (player.m_6144_() && (droppedPlate2 = itemstack.m_41720_()) instanceof ArmorItem && (armorItem = (ArmorItem)droppedPlate2).m_40402_() == EquipmentSlot.HEAD) {
                if (itemstack.m_204117_(ModTags.Items.VIVENTRUM_BANNED_ITEMS)) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.viventrum.item_too_heavy"), true);
                    return InteractionResult.FAIL;
                }
                ItemStack currentHelmet = this.m_6844_(EquipmentSlot.HEAD);
                if (!currentHelmet.m_41619_()) {
                    this.m_19983_(currentHelmet);
                }
                this.m_8061_(EquipmentSlot.HEAD, itemstack.m_41777_());
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (player.m_6144_() && !itemstack.m_41619_() && !(itemstack.m_41720_() instanceof ArmorItem)) {
                if (itemstack.m_204117_(ModTags.Items.VIVENTRUM_BANNED_ITEMS)) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.viventrum.item_too_heavy"), true);
                    return InteractionResult.FAIL;
                }
                ItemStack currentWeapon = this.m_21205_();
                if (!currentWeapon.m_41619_()) {
                    this.m_19983_(currentWeapon);
                }
                ItemStack singleItem = itemstack.m_41777_();
                singleItem.m_41764_(1);
                this.m_21008_(InteractionHand.MAIN_HAND, singleItem);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (player.m_6144_() && itemstack.m_41720_() == ModItems.ARMOR_PLATE.get()) {
                if (this.getArmorPlates() >= 4) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.mechanical_entity.max_armor_plates"), true);
                    return InteractionResult.FAIL;
                }
                this.addArmorPlate(false);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_5496_(SoundEvents.f_11677_, 0.5f, 1.0f);
                int currentPlates = this.getArmorPlates();
                player.m_5661_((Component)Component.m_237110_((String)"message.mechanical_entity.armor_plating_added", (Object[])new Object[]{currentPlates, 4}), true);
                return InteractionResult.SUCCESS;
            }
            if (player.m_6144_() && itemstack.m_41720_() == ModItems.HEAVY_ARMOR_PLATE.get()) {
                if (this.getArmorPlates() >= 4) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.mechanical_entity.max_armor_plates"), true);
                    return InteractionResult.FAIL;
                }
                this.addArmorPlate(true);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_5496_(SoundEvents.f_11679_, 0.5f, 1.0f);
                int currentPlates = this.getArmorPlates();
                player.m_5661_((Component)Component.m_237110_((String)"message.mechanical_entity.heavy_armor_plating_added", (Object[])new Object[]{currentPlates, 4}), true);
                return InteractionResult.SUCCESS;
            }
            if (player.m_6144_() && itemstack.m_41720_() == Items.f_42386_ && this.getArmorPlates() > 0) {
                this.removeArmorPlate();
                this.m_5496_(SoundEvents.f_11681_, 0.5f, 1.0f);
                ItemStack droppedPlate3 = new ItemStack((ItemLike)ModItems.ARMOR_PLATE.get());
                this.m_19983_(droppedPlate3);
                int currentPlates = this.getArmorPlates();
                player.m_5661_((Component)Component.m_237110_((String)"message.mechanical_entity.armor_plating_removed", (Object[])new Object[]{currentPlates, 4}), true);
                return InteractionResult.SUCCESS;
            }
            if (!player.m_6144_() && itemstack.m_150930_((Item)ModItems.REPAIR_KIT.get()) && this.m_21223_() < this.m_21233_()) {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_5634_(10.0f);
                this.m_5496_(SoundEvents.f_11912_, 0.5f, 1.0f);
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 3, 0.3, 0.3, 0.3, 0.1);
                }
                return InteractionResult.SUCCESS;
            }
            if (!player.m_6144_() && itemstack.m_41619_()) {
                Component entityName;
                Object object = entityName = this.m_8077_() ? this.m_7770_() : Component.m_237115_((String)"entity.scguns.viventrum");
                if (this.m_21827_()) {
                    this.m_21839_(false);
                    this.setPatrolling(false);
                    player.m_5661_((Component)Component.m_237110_((String)"message.viventrum.following", (Object[])new Object[]{entityName}), true);
                } else if (this.isPatrolling()) {
                    this.setPatrolling(false);
                    this.m_21839_(true);
                    player.m_5661_((Component)Component.m_237110_((String)"message.viventrum.sitting", (Object[])new Object[]{entityName}), true);
                } else {
                    this.setPatrolling(true);
                    this.setPatrolOrigin(this.m_20183_());
                    this.spawnPatrolOriginParticles();
                    player.m_5661_((Component)Component.m_237110_((String)"message.viventrum.patrolling", (Object[])new Object[]{entityName}), true);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_150930_(Items.f_42415_)) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_7066_(ItemStack stack) {
        EquipmentSlot slot = Mob.m_147233_((ItemStack)stack);
        if (!this.m_6844_(slot).m_41619_()) {
            return false;
        }
        return slot == EquipmentSlot.HEAD;
    }

    public boolean m_7808_(ItemStack candidate, ItemStack existing) {
        if (existing.m_41619_()) {
            return Mob.m_147233_((ItemStack)candidate) == EquipmentSlot.HEAD;
        }
        return false;
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
        boolean hasGun;
        boolean hadGun;
        ItemStack oldStack = this.m_6844_(slot);
        super.m_8061_(slot, stack);
        if (!this.m_9236_().f_46443_ && slot == EquipmentSlot.MAINHAND && (hadGun = oldStack.m_41720_() instanceof GunItem) != (hasGun = stack.m_41720_() instanceof GunItem)) {
            this.f_21345_.m_262460_(goal -> true);
            this.m_8099_();
        }
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
        if (attacking) {
            this.setAttackTimeout(10);
        }
    }

    public void setAttackTimeout(int timeout) {
        this.f_19804_.m_135381_(ATTACK_TIMEOUT, (Object)timeout);
    }

    public int getAttackTimeout() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TIMEOUT);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public boolean isPatrolling() {
        return (Boolean)this.f_19804_.m_135370_(PATROLLING);
    }

    public void setPatrolling(boolean patrolling) {
        this.f_19804_.m_135381_(PATROLLING, (Object)patrolling);
    }

    public Optional<BlockPos> getPatrolOrigin() {
        return (Optional)this.f_19804_.m_135370_(PATROL_ORIGIN);
    }

    public void setPatrolOrigin(BlockPos pos) {
        if (pos != null) {
            this.f_19804_.m_135381_(PATROL_ORIGIN, Optional.of(pos));
        } else {
            this.f_19804_.m_135381_(PATROL_ORIGIN, Optional.empty());
        }
    }

    public boolean isPartying() {
        return (Boolean)this.f_19804_.m_135370_(PARTYING);
    }

    public void setPartying(boolean partying) {
        this.f_19804_.m_135381_(PARTYING, (Object)partying);
    }

    public boolean isDefensive() {
        return (Boolean)this.f_19804_.m_135370_(DEFENSIVE);
    }

    public void setDefensive(boolean defensive) {
        this.f_19804_.m_135381_(DEFENSIVE, (Object)defensive);
        if (defensive) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22118_(new AttributeModifier("defensive_bonus", 15.0, AttributeModifier.Operation.ADDITION));
        } else {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22120_(new AttributeModifier("defensive_bonus", 15.0, AttributeModifier.Operation.ADDITION).m_22209_());
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (this.m_21824_() && this.isDefensive()) {
            amount *= 0.39999998f;
        }
        return super.m_6469_(source, amount);
    }

    public void spawnPatrolOriginParticles() {
        if (this.m_9236_() instanceof ServerLevel) {
            BlockPos pos = this.getPatrolOrigin().orElse(this.m_20183_());
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 10, 0.5, 0.5, 0.5, 0.1);
        }
    }

    protected void m_267689_(float partialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(partialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public boolean m_6040_() {
        return true;
    }

    public void m_6818_(@NotNull BlockPos pos, boolean playing) {
        this.setPartying(playing && this.m_21824_());
    }

    public int getArmorPlates() {
        return (Integer)this.f_19804_.m_135370_(ARMOR_PLATES);
    }

    public int getHeavyArmorPlates() {
        return (Integer)this.f_19804_.m_135370_(HEAVY_ARMOR_PLATES);
    }

    public void setArmorPlates(int plates) {
        this.f_19804_.m_135381_(ARMOR_PLATES, (Object)plates);
        this.updateArmorFromPlates();
    }

    public void setHeavyArmorPlates(int plates) {
        this.f_19804_.m_135381_(HEAVY_ARMOR_PLATES, (Object)plates);
        this.updateArmorFromPlates();
    }

    public void addArmorPlate(boolean isHeavy) {
        int total = this.getArmorPlates() + this.getHeavyArmorPlates();
        if (total < 4) {
            if (isHeavy) {
                this.setHeavyArmorPlates(this.getHeavyArmorPlates() + 1);
            } else {
                this.setArmorPlates(this.getArmorPlates() + 1);
            }
        }
    }

    public boolean removeArmorPlate() {
        if (this.getHeavyArmorPlates() > 0) {
            this.setHeavyArmorPlates(this.getHeavyArmorPlates() - 1);
            return true;
        }
        if (this.getArmorPlates() > 0) {
            this.setArmorPlates(this.getArmorPlates() - 1);
            return false;
        }
        return false;
    }

    private void updateArmorFromPlates() {
        int regularPlates = this.getArmorPlates();
        int heavyPlates = this.getHeavyArmorPlates();
        int totalArmor = regularPlates + heavyPlates * 2;
        Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22100_(2.0 + (double)totalArmor);
    }

    protected void m_7840_(double y, boolean onGround, @NotNull BlockState state, @NotNull BlockPos pos) {
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12499_;
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return SoundEvents.f_12502_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12501_;
    }

    protected void m_7472_(DamageSource damageSource, int looting, boolean hitByPlayer) {
        int heavyPlates;
        int regularPlates;
        ItemStack helmet;
        super.m_7472_(damageSource, looting, hitByPlayer);
        ItemStack mainHandItem = this.m_21205_();
        if (!mainHandItem.m_41619_()) {
            this.m_19983_(mainHandItem);
            this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
        if (!(helmet = this.m_6844_(EquipmentSlot.HEAD)).m_41619_()) {
            this.m_19983_(helmet);
            this.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
        }
        if ((regularPlates = this.getArmorPlates()) > 0) {
            ItemStack armorPlates = new ItemStack((ItemLike)ModItems.ARMOR_PLATE.get(), regularPlates);
            this.m_19983_(armorPlates);
        }
        if ((heavyPlates = this.getHeavyArmorPlates()) > 0) {
            ItemStack heavyArmorPlates = new ItemStack((ItemLike)ModItems.HEAVY_ARMOR_PLATE.get(), heavyPlates);
            this.m_19983_(heavyArmorPlates);
        }
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Attacking", this.isAttacking());
        tag.m_128405_("AttackTimeout", this.getAttackTimeout());
        tag.m_128379_("Patrolling", this.isPatrolling());
        tag.m_128379_("Defensive", this.isDefensive());
        tag.m_128405_("ArmorPlates", this.getArmorPlates());
        tag.m_128405_("HeavyArmorPlates", this.getHeavyArmorPlates());
        this.getPatrolOrigin().ifPresent(pos -> {
            tag.m_128405_("PatrolOriginX", pos.m_123341_());
            tag.m_128405_("PatrolOriginY", pos.m_123342_());
            tag.m_128405_("PatrolOriginZ", pos.m_123343_());
        });
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.setAttacking(tag.m_128471_("Attacking"));
        this.setAttackTimeout(tag.m_128451_("AttackTimeout"));
        this.setPatrolling(tag.m_128471_("Patrolling"));
        if (tag.m_128441_("Defensive")) {
            this.setDefensive(tag.m_128471_("Defensive"));
        }
        if (tag.m_128441_("ArmorPlates")) {
            this.setArmorPlates(tag.m_128451_("ArmorPlates"));
        }
        if (tag.m_128441_("HeavyArmorPlates")) {
            this.setHeavyArmorPlates(tag.m_128451_("HeavyArmorPlates"));
        }
        if (tag.m_128441_("PatrolOriginX") && tag.m_128441_("PatrolOriginY") && tag.m_128441_("PatrolOriginZ")) {
            BlockPos patrolOrigin = new BlockPos(tag.m_128451_("PatrolOriginX"), tag.m_128451_("PatrolOriginY"), tag.m_128451_("PatrolOriginZ"));
            this.setPatrolOrigin(patrolOrigin);
        }
    }

    public void m_7105_(boolean tamed) {
        super.m_7105_(tamed);
        if (tamed) {
            this.m_21051_(Attributes.f_22276_).m_22100_(40.0);
            this.m_21153_(40.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(24.0);
        }
        this.f_21345_.m_262460_(goal -> true);
        this.m_8099_();
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel serverLevel, @NotNull AgeableMob ageableMob) {
        return null;
    }

    public static class ViventrumFollowOwnerGoal
    extends FollowOwnerGoal {
        private final ViventrumEntity viventrum;

        public ViventrumFollowOwnerGoal(ViventrumEntity viventrum, double speed, float minDistance, float maxDistance, boolean leavesAllowed) {
            super((TamableAnimal)viventrum, speed, minDistance, maxDistance, leavesAllowed);
            this.viventrum = viventrum;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.viventrum.isPatrolling();
        }

        public boolean m_8045_() {
            return super.m_8045_() && !this.viventrum.isPatrolling();
        }

        public void m_8056_() {
            if (!this.viventrum.isPatrolling()) {
                super.m_8056_();
            }
        }

        public void m_8037_() {
            if (!this.viventrum.isPatrolling()) {
                super.m_8037_();
            }
        }
    }
}

