/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.projectile;

import com.mrcrayfish.framework.network.message.IMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.Config;
import top.ribs.scguns.ScorchedGuns;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.compat.CompatManager;
import top.ribs.scguns.entity.projectile.ProjectileEntity;
import top.ribs.scguns.init.ModBlocks;
import top.ribs.scguns.init.ModDamageTypes;
import top.ribs.scguns.init.ModParticleTypes;
import top.ribs.scguns.init.ModTags;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.S2CMessageProjectileHitEntity;
import top.ribs.scguns.util.GunEnchantmentHelper;

public class FireRoundEntity
extends ProjectileEntity {
    private static final float SHIELD_IGNITE_CHANCE = 0.4f;
    private static final int SCULK_CLEARING_RADIUS = 2;

    public FireRoundEntity(EntityType<? extends Entity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public FireRoundEntity(EntityType<? extends Entity> entityType, Level worldIn, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, weapon, item, modifiedGun);
    }

    private boolean isSoulFireGun() {
        return this.getProjectile().isSoulFire();
    }

    @Override
    protected void onProjectileTick() {
        if (this.m_9236_().f_46443_ && this.f_19797_ > 1 && this.f_19797_ < this.life) {
            boolean hideProjectile = this.getProjectile().shouldHideProjectile();
            if (hideProjectile) {
                this.spawnSprayStyleParticles();
            } else {
                this.spawnGlobStyleParticles();
            }
        }
    }

    private void spawnSprayStyleParticles() {
        if (this.f_19797_ % 2 == 0) {
            int particleCount = 1 + this.f_19796_.m_188503_(2);
            for (int i = 0; i < particleCount; ++i) {
                double offsetX = (this.f_19796_.m_188500_() - 0.5) * 1.1;
                double offsetY = (this.f_19796_.m_188500_() - 0.5) * 1.1;
                double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 1.1;
                double velocityX = (this.f_19796_.m_188500_() - 0.5) * 0.1;
                double velocityY = (this.f_19796_.m_188500_() - 0.5) * 0.1;
                double velocityZ = (this.f_19796_.m_188500_() - 0.5) * 0.1;
                if (this.isSoulFireGun()) {
                    if (this.f_19796_.m_188501_() < 0.8f) {
                        this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123745_, true, this.m_20185_() + offsetX * 0.8, this.m_20186_() + offsetY * 0.8, this.m_20189_() + offsetZ * 0.8, velocityX * 0.5, velocityY * 0.5, velocityZ * 0.5);
                    }
                    if (!(this.f_19796_.m_188501_() < 0.4f)) continue;
                    this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.SOUL_FIREBALL.get(), true, this.m_20185_() + offsetX * 0.6, this.m_20186_() + offsetY * 0.6, this.m_20189_() + offsetZ * 0.6, velocityX * 0.3, velocityY * 0.3, velocityZ * 0.3);
                    continue;
                }
                if (this.f_19796_.m_188501_() < 0.4f) {
                    this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.FIREBALL.get(), true, this.m_20185_() + offsetX * 0.6, this.m_20186_() + offsetY * 0.6, this.m_20189_() + offsetZ * 0.6, velocityX * 0.3, velocityY * 0.3, velocityZ * 0.3);
                }
                if (!(this.f_19796_.m_188501_() < 0.6f)) continue;
                this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_175834_, true, this.m_20185_() + offsetX * 0.6, this.m_20186_() + offsetY * 0.6, this.m_20189_() + offsetZ * 0.6, velocityX * 0.3, velocityY * 0.3, velocityZ * 0.3);
            }
            if (this.f_19797_ % 2 == 0) {
                int smokeCount = 1 + this.f_19796_.m_188503_(1);
                for (int i = 0; i < smokeCount; ++i) {
                    double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.6;
                    double offsetY = (this.f_19796_.m_188500_() - 0.5) * 0.6;
                    double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.6;
                    this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123762_, true, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 0.0, 0.05, 0.0);
                }
            }
        }
    }

    private void spawnGlobStyleParticles() {
        double offsetZ;
        double offsetY;
        double offsetX;
        if (this.f_19797_ % 2 == 0) {
            offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.5;
            offsetY = (this.f_19796_.m_188500_() - 0.5) * 0.5;
            offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.5;
            if (this.isSoulFireGun()) {
                this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123745_, true, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 0.0, 0.0, 0.0);
            } else {
                this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123744_, true, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 0.0, 0.0, 0.0);
                this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123756_, true, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 0.0, 0.0, 0.0);
            }
        }
        if (this.f_19797_ % 6 == 0) {
            offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.5;
            offsetY = (this.f_19796_.m_188500_() - 0.5) * 0.5;
            offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.5;
            this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123762_, true, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
        float newDamage;
        float damage = this.getDamage();
        boolean critical = damage != (newDamage = this.getCriticalDamage(this.getWeapon(), this.f_19796_, damage));
        damage = newDamage;
        ResourceLocation advantage = this.getProjectile().getAdvantage();
        damage *= this.advantageMultiplier(entity);
        if (headshot) {
            damage = (float)((double)damage * (Double)Config.COMMON.gameplay.headShotDamageMultiplier.get());
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)entity;
            damage = this.applyProjectileProtection(livingTarget, damage);
        }
        DamageSource source = ModDamageTypes.Sources.projectile(this.m_9236_().m_9598_(), this, (LivingEntity)this.getOwner());
        boolean blocked = ProjectileEntity.ProjectileHelper.handleShieldHit(entity, this, damage);
        if (blocked) {
            if (entity instanceof Player) {
                ItemStack shield;
                Player player = (Player)entity;
                if (this.f_19796_.m_188501_() < 0.4f && (shield = player.m_21211_()).m_41720_() instanceof ShieldItem) {
                    player.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_41852_));
                    player.m_9236_().m_7967_((Entity)new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), shield));
                    player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11936_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        } else {
            if (!entity.m_6095_().m_204039_(ModTags.Entities.GHOST) || advantage.equals((Object)ModTags.Entities.UNDEAD.f_203868_())) {
                entity.m_6469_(source, damage);
            }
            if (this.isSoulFireGun()) {
                ScorchedGuns.setSoulFireOnEntity(entity, 5);
            } else {
                entity.m_20254_(5);
            }
        }
        if (entity instanceof LivingEntity) {
            GunEnchantmentHelper.applyElementalPopEffect(this.getWeapon(), (LivingEntity)entity);
        }
        if (this.shooter instanceof Player) {
            int hitType = critical ? 2 : (headshot ? 1 : 0);
            PacketHandler.getPlayChannel().sendToPlayer(() -> (ServerPlayer)this.shooter, (IMessage)new S2CMessageProjectileHitEntity(hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, hitType, entity instanceof Player));
        }
        this.spawnExplosionParticles(hitVec);
        this.clearSculkInArea(BlockPos.m_274446_((Position)hitVec));
    }

    @Override
    protected void onHitBlock(BlockState state, BlockPos pos, Direction face, double x, double y, double z) {
        this.spawnExplosionParticles(new Vec3(x, y, z));
        if (((Boolean)Config.COMMON.gameplay.enableFirePlacement.get()).booleanValue()) {
            this.setBlockOnFire(pos, face);
        }
        this.clearSculkInArea(pos);
    }

    @Override
    public void onExpired() {
        Vec3 position = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.spawnExplosionParticles(position);
        this.clearSculkInArea(BlockPos.m_274446_((Position)position));
    }

    private void clearSculkInArea(BlockPos center) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (!CompatManager.SCULK_HORDE_LOADED) {
            int clearedBlocks = 0;
            int maxClearBlocks = 8;
            for (int x = -2; x <= 2; ++x) {
                for (int y = -2; y <= 2; ++y) {
                    for (int z = -2; z <= 2; ++z) {
                        if (clearedBlocks >= maxClearBlocks) {
                            return;
                        }
                        BlockPos checkPos = center.m_7918_(x, y, z);
                        BlockState blockState = this.m_9236_().m_8055_(checkPos);
                        if (!blockState.m_204336_(ModTags.Blocks.SCULK_BLOCKS)) continue;
                        this.m_9236_().m_46961_(checkPos, true);
                        this.spawnCleansingParticles(checkPos);
                        this.m_9236_().m_5594_(null, checkPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.8f, 1.2f + this.f_19796_.m_188501_() * 0.4f);
                        ++clearedBlocks;
                    }
                }
            }
            if (clearedBlocks > 0) {
                this.m_9236_().m_5594_(null, center, SoundEvents.f_11736_, SoundSource.BLOCKS, 0.5f, 1.5f);
            }
        }
    }

    private void spawnCleansingParticles(BlockPos pos) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 5; ++i) {
                double offsetX = (double)pos.m_123341_() + 0.5 + (this.f_19796_.m_188500_() - 0.5) * 0.8;
                double offsetY = (double)pos.m_123342_() + 0.5 + (this.f_19796_.m_188500_() - 0.5) * 0.8;
                double offsetZ = (double)pos.m_123343_() + 0.5 + (this.f_19796_.m_188500_() - 0.5) * 0.8;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123790_, offsetX, offsetY, offsetZ, 2, 0.2, 0.2, 0.2, 0.1);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, offsetX, offsetY, offsetZ, 1, 0.1, 0.3, 0.1, 0.05);
            }
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 8, 0.3, 0.3, 0.3, 0.02);
        }
    }

    private void spawnExplosionParticles(Vec3 position) {
        block4: {
            if (this.m_9236_().f_46443_) break block4;
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            if (this.isSoulFireGun()) {
                for (int i = 0; i < 20; ++i) {
                    double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.2;
                    double offsetY = (this.f_19796_.m_188500_() - 0.5) * 0.2;
                    double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.2;
                    double speedX = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                    double speedY = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                    double speedZ = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123745_, position.f_82479_ + offsetX, position.f_82480_ + offsetY, position.f_82481_ + offsetZ, 1, speedX, speedY, speedZ, 0.05);
                }
            } else {
                for (int i = 0; i < 15; ++i) {
                    double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.2;
                    double offsetY = (this.f_19796_.m_188500_() - 0.5) * 0.2;
                    double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.2;
                    double speedX = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                    double speedY = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                    double speedZ = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123756_, position.f_82479_ + offsetX, position.f_82480_ + offsetY, position.f_82481_ + offsetZ, 1, speedX, speedY, speedZ, 0.1);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123800_, position.f_82479_ + offsetX, position.f_82480_ + offsetY, position.f_82481_ + offsetZ, 1, speedX, speedY, speedZ, 0.1);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175834_, position.f_82479_ + offsetX, position.f_82480_ + offsetY, position.f_82481_ + offsetZ, 1, speedX, speedY, speedZ, 0.1);
                }
            }
        }
    }

    private void setBlockOnFire(BlockPos pos, Direction face) {
        this.tryPlaceWallFire(pos, face);
        if (this.f_19796_.m_188501_() < 0.6f) {
            Direction[] adjacentFaces;
            for (Direction adjacentFace : adjacentFaces = this.getAdjacentFaces(face)) {
                if (!(this.f_19796_.m_188501_() < 0.4f)) continue;
                this.tryPlaceWallFire(pos, adjacentFace);
            }
        }
        if (face != Direction.UP && this.f_19796_.m_188501_() < 0.7f) {
            this.tryPlaceWallFire(pos, Direction.UP);
        }
    }

    private boolean canSustainFireOnFace(BlockState blockState, BlockPos pos, Direction face) {
        if (blockState.isFlammable((BlockGetter)this.m_9236_(), pos, face)) {
            return true;
        }
        return blockState.m_60804_((BlockGetter)this.m_9236_(), pos);
    }

    private BlockState getWallFireState(Direction attachedFace) {
        if (this.isSoulFireGun()) {
            return ((Block)ModBlocks.FAKE_SOUL_FIRE.get()).m_49966_();
        }
        BlockState fireState = Blocks.f_50083_.m_49966_();
        return switch (attachedFace) {
            case Direction.UP -> (BlockState)fireState.m_61124_((Property)FireBlock.f_53413_, (Comparable)Boolean.valueOf(true));
            case Direction.NORTH -> (BlockState)fireState.m_61124_((Property)FireBlock.f_53409_, (Comparable)Boolean.valueOf(true));
            case Direction.SOUTH -> (BlockState)fireState.m_61124_((Property)FireBlock.f_53411_, (Comparable)Boolean.valueOf(true));
            case Direction.EAST -> (BlockState)fireState.m_61124_((Property)FireBlock.f_53410_, (Comparable)Boolean.valueOf(true));
            case Direction.WEST -> (BlockState)fireState.m_61124_((Property)FireBlock.f_53412_, (Comparable)Boolean.valueOf(true));
            default -> fireState;
        };
    }

    private void tryPlaceWallFire(BlockPos pos, Direction face) {
        BlockState hitBlockState;
        BlockPos offsetPos = pos.m_121945_(face);
        if (this.m_9236_().m_46859_(offsetPos) && this.canSustainFireOnFace(hitBlockState = this.m_9236_().m_8055_(pos), pos, face)) {
            BlockState fireState = this.getWallFireState(face.m_122424_());
            this.m_9236_().m_7731_(offsetPos, fireState, 11);
        }
    }

    private Direction[] getAdjacentFaces(Direction face) {
        Direction[] directionArray;
        switch (face) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case UP: 
            case DOWN: {
                Direction[] directionArray2 = new Direction[4];
                directionArray2[0] = Direction.NORTH;
                directionArray2[1] = Direction.SOUTH;
                directionArray2[2] = Direction.EAST;
                directionArray = directionArray2;
                directionArray2[3] = Direction.WEST;
                break;
            }
            case NORTH: 
            case SOUTH: {
                Direction[] directionArray3 = new Direction[4];
                directionArray3[0] = Direction.UP;
                directionArray3[1] = Direction.DOWN;
                directionArray3[2] = Direction.EAST;
                directionArray = directionArray3;
                directionArray3[3] = Direction.WEST;
                break;
            }
            case EAST: 
            case WEST: {
                Direction[] directionArray4 = new Direction[4];
                directionArray4[0] = Direction.UP;
                directionArray4[1] = Direction.DOWN;
                directionArray4[2] = Direction.NORTH;
                directionArray = directionArray4;
                directionArray4[3] = Direction.SOUTH;
            }
        }
        return directionArray;
    }
}

