/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.projectile;

import com.mrcrayfish.framework.network.message.IMessage;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import top.ribs.scguns.Config;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.entity.projectile.ProjectileEntity;
import top.ribs.scguns.init.ModDamageTypes;
import top.ribs.scguns.init.ModParticleTypes;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.S2CMessageProjectileHitEntity;
import top.ribs.scguns.util.GunEnchantmentHelper;

public class PlasmaProjectileEntity
extends ProjectileEntity {
    private static final float SHIELD_DISABLE_CHANCE = 0.7f;
    private static final float SHIELD_DAMAGE_PENETRATION = 0.25f;
    private static final float HEADSHOT_EFFECT_DURATION_MULTIPLIER = 1.5f;
    private static final float SPLASH_DAMAGE_RADIUS = 2.0f;
    private static final float SPLASH_DAMAGE_FALLOFF = 0.7f;
    private static final float SPLASH_EFFECT_CHANCE_MULTIPLIER = 0.4f;
    private static final float FIRE_CHANCE = 0.2f;

    public PlasmaProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public PlasmaProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, weapon, item, modifiedGun);
    }

    @Override
    protected void onProjectileTick() {
        if (this.m_9236_().f_46443_ && this.f_19797_ > 1 && this.f_19797_ < this.life) {
            if (this.f_19797_ % 2 == 0) {
                double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                double offsetY = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.GREEN_FLAME.get(), true, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 0.0, 0.0, 0.0);
            }
            if (this.f_19797_ % 5 == 0) {
                this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.PLASMA_RING.get(), true, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
        LivingEntity livingEntity;
        boolean wasAlive;
        float newDamage;
        float directDamage = this.getDamage();
        boolean critical = directDamage != (newDamage = this.getCriticalDamage(this.getWeapon(), this.f_19796_, directDamage));
        directDamage = newDamage;
        directDamage *= this.advantageMultiplier(entity);
        boolean bl = wasAlive = entity instanceof LivingEntity && entity.m_6084_();
        if (headshot) {
            directDamage = (float)((double)directDamage * (Double)Config.COMMON.gameplay.headShotDamageMultiplier.get());
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)entity;
            directDamage = this.applyProjectileProtection(livingTarget, directDamage);
        }
        DamageSource source = ModDamageTypes.Sources.projectile(this.m_9236_().m_9598_(), this, (LivingEntity)this.getOwner());
        boolean blocked = ProjectileEntity.ProjectileHelper.handleShieldHit(entity, this, directDamage, 0.7f);
        if (blocked) {
            float penetratingDamage = directDamage * 0.25f;
            entity.m_6469_(source, penetratingDamage);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity2 = (LivingEntity)entity;
                this.applyEffect(livingEntity2, 0.25f, headshot);
            }
        } else {
            entity.m_6469_(source, directDamage);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity3 = (LivingEntity)entity;
                this.applyEffect(livingEntity3, 1.0f, headshot);
            }
        }
        if (entity instanceof LivingEntity && this.f_19796_.m_188501_() < 0.2f) {
            entity.m_20254_(2);
        }
        if (entity instanceof LivingEntity) {
            GunEnchantmentHelper.applyElementalPopEffect(this.getWeapon(), (LivingEntity)entity);
        }
        if (this.shooter instanceof Player) {
            int hitType = critical ? 2 : (headshot ? 1 : 0);
            PacketHandler.getPlayChannel().sendToPlayer(() -> (ServerPlayer)this.shooter, (IMessage)new S2CMessageProjectileHitEntity(hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, hitType, entity instanceof Player));
        }
        this.applySplashDamage(hitVec, directDamage * 0.6f);
        this.spawnPlasmaParticles(hitVec);
        if (wasAlive && entity instanceof LivingEntity && !(livingEntity = (LivingEntity)entity).m_6084_()) {
            this.checkForDiamondSteelBonus(livingEntity, hitVec);
        }
    }

    private void applySplashDamage(Vec3 center, float baseSplashDamage) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        List nearbyEntities = this.m_9236_().m_45976_(LivingEntity.class, new AABB(center.f_82479_ - 2.0, center.f_82480_ - 2.0, center.f_82481_ - 2.0, center.f_82479_ + 2.0, center.f_82480_ + 2.0, center.f_82481_ + 2.0));
        DamageSource splashSource = ModDamageTypes.Sources.projectile(this.m_9236_().m_9598_(), this, this.getShooter());
        for (LivingEntity target : nearbyEntities) {
            double distance = target.m_20182_().m_82554_(center);
            if (distance > 2.0) continue;
            float distanceRatio = (float)(distance / 2.0);
            float damageMultiplier = 1.0f - distanceRatio * 0.3f;
            float splashDamage = baseSplashDamage * damageMultiplier;
            if (target == this.getShooter()) {
                splashDamage *= 0.4f;
            }
            if (!((splashDamage = this.applyProjectileProtection(target, splashDamage)) > 0.5f)) continue;
            target.m_6469_(splashSource, splashDamage);
            this.applyEffect(target, damageMultiplier * 0.4f, false);
            float splashFireChance = 0.2f * damageMultiplier * 0.5f;
            if (!(this.f_19796_.m_188501_() < splashFireChance)) continue;
            target.m_20254_(2);
        }
    }

    @Override
    public float applyProjectileProtection(LivingEntity target, float damage) {
        int protectionLevel = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44969_, (LivingEntity)target);
        if (protectionLevel > 0) {
            float reduction = (float)protectionLevel * 0.07f;
            reduction = Math.min(reduction, 0.56f);
            damage *= 1.0f - reduction;
        }
        return damage;
    }

    private void applyEffect(LivingEntity target, float powerMultiplier, boolean headshot) {
        ResourceLocation effectLocation = this.getProjectile().getImpactEffect();
        if (effectLocation != null) {
            MobEffect effect;
            float effectChance = this.getProjectile().getImpactEffectChance() * powerMultiplier;
            if (headshot) {
                effectChance = Math.min(1.0f, effectChance * 1.25f);
            }
            if (this.f_19796_.m_188501_() < effectChance && (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectLocation)) != null) {
                int duration = this.getProjectile().getImpactEffectDuration();
                if (headshot) {
                    duration = (int)((float)duration * 1.5f);
                }
                duration = (int)((float)duration * powerMultiplier);
                target.m_7292_(new MobEffectInstance(effect, duration, this.getProjectile().getImpactEffectAmplifier()));
            }
        }
    }

    @Override
    protected void onHitBlock(BlockState state, BlockPos pos, Direction face, double x, double y, double z) {
        Vec3 hitPos = new Vec3(x, y, z);
        this.applySplashDamage(hitPos, this.getDamage() * 0.4f);
        this.spawnPlasmaParticles(hitPos);
    }

    @Override
    public void onExpired() {
        Vec3 pos = this.m_20182_();
        this.applySplashDamage(pos, this.getDamage() * 0.3f);
        this.spawnPlasmaParticles(pos);
    }

    private void spawnPlasmaParticles(Vec3 position) {
        if (!this.m_9236_().f_46443_) {
            int i;
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.PLASMA_EXPLOSION.get()), position.f_82479_, position.f_82480_, position.f_82481_, 1, 0.0, 0.0, 0.0, 0.1);
            for (i = 0; i < 12; ++i) {
                double angle = (double)i / 12.0 * 2.0 * Math.PI;
                double radius = 0.3 + this.f_19796_.m_188500_() * 0.8;
                double offsetX = Math.cos(angle) * radius;
                double offsetZ = Math.sin(angle) * radius;
                double offsetY = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                double speedX = offsetX * 0.08;
                double speedY = (this.f_19796_.m_188500_() - 0.3) * 0.15;
                double speedZ = offsetZ * 0.08;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.GREEN_FLAME.get()), position.f_82479_ + offsetX, position.f_82480_ + offsetY, position.f_82481_ + offsetZ, 1, speedX, speedY, speedZ, 0.05);
            }
            for (i = 0; i < 6; ++i) {
                double offsetX = (this.f_19796_.m_188500_() - 0.5) * 1.5;
                double offsetY = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 1.5;
                double speedX = (this.f_19796_.m_188500_() - 0.5) * 0.2;
                double speedY = (this.f_19796_.m_188500_() - 0.5) * 0.2;
                double speedZ = (this.f_19796_.m_188500_() - 0.5) * 0.2;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123745_, position.f_82479_ + offsetX, position.f_82480_ + offsetY, position.f_82481_ + offsetZ, 1, speedX, speedY, speedZ, 0.1);
            }
        }
    }
}

