/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.entity.projectile.ProjectileEntity;
import top.ribs.scguns.item.GunItem;

public class SyringeProjectileEntity
extends ProjectileEntity {
    private static final float REUSE_CHANCE = 0.25f;
    private boolean canBeReused = false;

    public SyringeProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public SyringeProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, weapon, item, modifiedGun);
        this.canBeReused = this.f_19796_.m_188501_() < 0.25f;
    }

    @Override
    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
        MobEffect effect;
        ResourceLocation effectLocation;
        super.onHitEntity(entity, hitVec, startVec, endVec, headshot);
        if (!this.m_9236_().f_46443_ && (effectLocation = this.getProjectile().getImpactEffect()) != null && (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectLocation)) != null) {
            new MobEffectInstance(effect, this.getProjectile().getImpactEffectDuration(), this.getProjectile().getImpactEffectAmplifier());
            int potionColor = effect.m_19484_();
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123811_, hitVec.f_82479_, hitVec.f_82480_ + 0.5, hitVec.f_82481_, 1, 0.3, 0.3, 0.3, 0.0);
            this.m_9236_().m_46796_(2002, this.m_20183_(), potionColor);
        }
    }

    @Override
    protected void onHitBlock(BlockState state, BlockPos pos, Direction face, double x, double y, double z) {
        MobEffect effect;
        ResourceLocation effectLocation;
        super.onHitBlock(state, pos, face, x, y, z);
        if (!this.m_9236_().f_46443_ && (effectLocation = this.getProjectile().getImpactEffect()) != null && (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectLocation)) != null) {
            int potionColor = effect.m_19484_();
            this.m_9236_().m_46796_(2002, this.m_20183_(), potionColor);
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123811_, x, y, z, 1, 0.3, 0.3, 0.3, 0.0);
        }
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("CanBeReused", this.canBeReused);
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.canBeReused = compound.m_128471_("CanBeReused");
    }

    @Override
    public void writeSpawnData(FriendlyByteBuf buffer) {
        super.writeSpawnData(buffer);
        buffer.writeBoolean(this.canBeReused);
    }

    @Override
    public void readSpawnData(FriendlyByteBuf buffer) {
        super.readSpawnData(buffer);
        this.canBeReused = buffer.readBoolean();
    }
}

