/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.throwable;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.common.ChokeBombCloud;
import top.ribs.scguns.entity.throwable.ThrowableGrenadeEntity;
import top.ribs.scguns.entity.throwable.ThrowableItemEntity;
import top.ribs.scguns.init.ModEntities;
import top.ribs.scguns.init.ModItems;

public class ThrowableChokeBombEntity
extends ThrowableGrenadeEntity {
    private final float explosionRadius;
    private int cloudTicks;
    private final int cloudDuration;
    private final int activationDelay;
    private boolean cloudActive = false;

    public ThrowableChokeBombEntity(EntityType<? extends ThrowableGrenadeEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.explosionRadius = 4.0f;
        this.cloudDuration = 400;
        this.activationDelay = 40;
        this.cloudTicks = 0;
    }

    public ThrowableChokeBombEntity(Level world, LivingEntity entity, int timeLeft, float radius) {
        super((EntityType<? extends ThrowableItemEntity>)((EntityType)ModEntities.THROWABLE_CHOKE_BOMB.get()), world, entity);
        this.setShouldBounce(true);
        this.setItem(new ItemStack((ItemLike)ModItems.CHOKE_BOMB.get()));
        this.setMaxLife(timeLeft);
        this.explosionRadius = radius;
        this.cloudDuration = 400;
        this.activationDelay = 40;
        this.cloudTicks = 0;
    }

    @Override
    protected void m_8097_() {
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.cloudActive && this.f_19797_ >= this.activationDelay) {
            this.cloudActive = true;
            this.setMaxLife(this.f_19797_ + this.cloudDuration);
            this.onCloudActivation();
        }
        if (this.cloudActive) {
            ++this.cloudTicks;
            this.emitChokeCloudParticles();
            this.applyChokeEffects();
            if (this.cloudTicks >= this.cloudDuration) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
    }

    @Override
    public void particleTick() {
        if (this.m_9236_().f_46443_ && !this.cloudActive) {
            this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123790_, true, this.m_20185_(), this.m_20186_() + 0.35, this.m_20189_(), 0.0, 0.0, 0.0);
            this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_175821_, true, this.m_20185_(), this.m_20186_() + 0.35, this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    private void onCloudActivation() {
        double y = this.m_20186_() + (double)this.m_6095_().m_20680_().f_20378_ * 0.5;
        this.m_9236_().m_6263_(null, this.m_20185_(), y, this.m_20189_(), SoundEvents.f_11937_, SoundSource.BLOCKS, 2.0f, 1.0f);
    }

    private void emitChokeCloudParticles() {
        Vec3 center = this.m_20182_();
        float intensity = 0.8f;
        if (!this.m_9236_().f_46443_) {
            ChokeBombCloud.spawnChokeCloudParticles(this.m_9236_(), center, this.explosionRadius, intensity, this.f_19796_);
        }
    }

    private void applyChokeEffects() {
        if (!this.m_9236_().f_46443_) {
            Vec3 center = this.m_20182_();
            ChokeBombCloud.applyChokeEffects(this.m_9236_(), center, this.explosionRadius);
            ChokeBombCloud.extinguishFireInArea(this.m_9236_(), center, this.explosionRadius);
        }
    }

    @Override
    public void onDeath() {
        if (!this.cloudActive) {
            this.cloudActive = true;
            this.onCloudActivation();
        }
    }
}

