/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.event;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.ribs.scguns.item.animated.AdrienArmorItem;
import top.ribs.scguns.item.animated.AnthraliteArmorItem;
import top.ribs.scguns.item.animated.AnthraliteGasMaskArmorItem;
import top.ribs.scguns.item.animated.DiamondSteelArmorItem;
import top.ribs.scguns.item.animated.ExoSuitItem;
import top.ribs.scguns.item.animated.NetheriteGasMaskArmorItem;
import top.ribs.scguns.item.animated.RedcoatArmorItem;
import top.ribs.scguns.item.animated.ScrapArmorItem;
import top.ribs.scguns.item.animated.TreatedBrassArmorItem;

@Mod.EventBusSubscriber(modid="scguns", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ArmorRenderHandler {
    @SubscribeEvent
    public static void onRenderLivingPre(RenderLivingEvent.Pre<?, ?> event) {
        EntityModel entityModel = event.getRenderer().m_7200_();
        if (entityModel instanceof PlayerModel) {
            PlayerModel playerModel = (PlayerModel)entityModel;
            ArmorRenderHandler.hideSecondLayerForCustomArmor(event.getEntity(), playerModel);
        }
    }

    @SubscribeEvent
    public static void onRenderLivingPost(RenderLivingEvent.Post<?, ?> event) {
        EntityModel entityModel = event.getRenderer().m_7200_();
        if (entityModel instanceof PlayerModel) {
            PlayerModel playerModel = (PlayerModel)entityModel;
            ArmorRenderHandler.restoreSecondLayer(playerModel);
        }
    }

    private static void hideSecondLayerForCustomArmor(LivingEntity entity, PlayerModel<?> playerModel) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
            ItemStack armorStack = entity.m_6844_(slot);
            if (armorStack.m_41720_() instanceof AdrienArmorItem) {
                ArmorRenderHandler.hideSecondLayerForSlot(playerModel, slot);
            }
            if (armorStack.m_41720_() instanceof TreatedBrassArmorItem) {
                ArmorRenderHandler.hideSecondLayerForSlot(playerModel, slot);
            }
            if (armorStack.m_41720_() instanceof AnthraliteArmorItem) {
                ArmorRenderHandler.hideSecondLayerForSlot(playerModel, slot);
            }
            if (armorStack.m_41720_() instanceof AnthraliteGasMaskArmorItem) {
                ArmorRenderHandler.hideSecondLayerForSlot(playerModel, slot);
            }
            if (armorStack.m_41720_() instanceof NetheriteGasMaskArmorItem) {
                ArmorRenderHandler.hideSecondLayerForSlot(playerModel, slot);
            }
            if (armorStack.m_41720_() instanceof ExoSuitItem) {
                ArmorRenderHandler.hideSecondLayerForSlot(playerModel, slot);
            }
            if (armorStack.m_41720_() instanceof DiamondSteelArmorItem) {
                ArmorRenderHandler.hideSecondLayerForSlot(playerModel, slot);
            }
            if (armorStack.m_41720_() instanceof RedcoatArmorItem) {
                ArmorRenderHandler.hideSecondLayerForSlot(playerModel, slot);
            }
            if (!(armorStack.m_41720_() instanceof ScrapArmorItem)) continue;
            ArmorRenderHandler.hideSecondLayerForSlot(playerModel, slot);
        }
    }

    private static void hideSecondLayerForSlot(PlayerModel<?> playerModel, EquipmentSlot slot) {
        switch (slot) {
            case HEAD: {
                playerModel.f_102809_.f_104207_ = false;
                break;
            }
            case CHEST: {
                playerModel.f_103378_.f_104207_ = false;
                playerModel.f_103374_.f_104207_ = false;
                playerModel.f_103375_.f_104207_ = false;
                break;
            }
            case LEGS: {
                playerModel.f_103376_.f_104207_ = false;
                playerModel.f_103377_.f_104207_ = false;
            }
        }
    }

    private static void restoreSecondLayer(PlayerModel<?> playerModel) {
        playerModel.f_102809_.f_104207_ = true;
        playerModel.f_103378_.f_104207_ = true;
        playerModel.f_103374_.f_104207_ = true;
        playerModel.f_103375_.f_104207_ = true;
        playerModel.f_103376_.f_104207_ = true;
        playerModel.f_103377_.f_104207_ = true;
    }
}

