/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.event;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import top.ribs.scguns.init.ModParticleTypes;

public class GasExplosion {
    private final Level level;
    private final BlockPos centerPos;
    private final float radius;
    private final int duration;
    private final RandomSource random;

    public GasExplosion(Level level, BlockPos centerPos, float radius, int duration) {
        this.level = level;
        this.centerPos = centerPos;
        this.radius = radius;
        this.duration = duration;
        this.random = level.f_46441_;
    }

    public void explode() {
        this.level.m_6263_(null, (double)this.centerPos.m_123341_(), (double)this.centerPos.m_123342_(), (double)this.centerPos.m_123343_(), SoundEvents.f_11789_, SoundSource.BLOCKS, 2.0f, 1.0f);
        for (int i = 0; i < this.duration; ++i) {
            this.level.m_186460_(this.centerPos, this.level.m_8055_(this.centerPos).m_60734_(), i * 20);
        }
    }

    public void tick(int tickCount) {
        if (tickCount >= this.duration) {
            return;
        }
        this.spawnGasCloudParticles();
        this.applyEffectsToEntities();
    }

    private void spawnGasCloudParticles() {
        for (int i = 0; i < 20; ++i) {
            double xOffset = this.random.m_188583_() * (double)this.radius;
            double yOffset = this.random.m_188583_() * (double)(this.radius / 2.0f);
            double zOffset = this.random.m_188583_() * (double)this.radius;
            double x = (double)this.centerPos.m_123341_() + 0.5 + xOffset;
            double y = (double)this.centerPos.m_123342_() + 0.5 + yOffset;
            double z = (double)this.centerPos.m_123343_() + 0.5 + zOffset;
            this.level.m_7106_((ParticleOptions)ModParticleTypes.SULFUR_DUST.get(), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    private void applyEffectsToEntities() {
        List entities = this.level.m_45976_(LivingEntity.class, new AABB(this.centerPos).m_82400_((double)this.radius));
        for (LivingEntity entity : entities) {
            Player player;
            if (entity instanceof Player && ((player = (Player)entity).m_7500_() || player.m_5833_())) continue;
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100, 2));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 60, 1));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 60, 0));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 1));
        }
    }
}

