/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.event;

import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.item.animated.AnimatedSculkGunItem;
import top.ribs.scguns.item.attachment.IAttachment;

@Mod.EventBusSubscriber(modid="scguns", value={Dist.CLIENT})
public class GunXpHandler {
    private static final float SCULK_REPAIR_RATIO = 0.5f;

    @SubscribeEvent
    public static void onPlayerXpPickup(PlayerXpEvent.PickupXp event) {
        Player player = event.getEntity();
        ItemStack mainHand = player.m_21205_();
        Item item = mainHand.m_41720_();
        if (item instanceof GunItem) {
            int repairAmount;
            GunItem gunItem = (GunItem)item;
            ExperienceOrb orb = event.getOrb();
            int remainingXp = orb.f_20770_;
            if (mainHand.m_41720_() instanceof AnimatedSculkGunItem && mainHand.m_41768_() && remainingXp > 0 && (repairAmount = Math.min((int)((float)(remainingXp * 2) * 0.5f), mainHand.m_41773_())) > 0) {
                mainHand.m_41721_(mainHand.m_41773_() - repairAmount);
                remainingXp -= repairAmount;
            }
            for (IAttachment.Type type : IAttachment.Type.values()) {
                int repairAmount2;
                ItemStack attachmentStack = Gun.getAttachment(type, mainHand);
                if (attachmentStack.m_41619_() || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44962_, (ItemStack)attachmentStack) <= 0 || !attachmentStack.m_41768_() || remainingXp <= 0 || (repairAmount2 = Math.min(remainingXp * 2, attachmentStack.m_41773_())) <= 0) continue;
                attachmentStack.m_41721_(attachmentStack.m_41773_() - repairAmount2);
                gunItem.onAttachmentChanged(mainHand);
                remainingXp -= repairAmount2 / 2;
            }
            orb.f_20770_ = remainingXp;
        }
    }
}

