/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.event;

import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.ribs.scguns.init.ModEnchantments;
import top.ribs.scguns.init.ModSyncedDataKeys;
import top.ribs.scguns.init.ModTags;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.item.animated.ExoSuitItem;

@Mod.EventBusSubscriber(modid="scguns")
public class WeaponMovementEventHandler {
    private static final UUID HEAVY_WEAPON_MODIFIER_UUID = UUID.fromString("ff624994-88ae-4002-b5c9-b41b6d658030");
    private static final UUID RELOAD_SPEED_MODIFIER_UUID = UUID.fromString("aa815773-99bf-4113-c6d8-e52c7f769041");
    private static final UUID LIGHTWEIGHT_SPEED_MODIFIER_UUID = UUID.fromString("bb926884-10cf-5224-d7e9-f63d8e890152");
    private static final double LIGHTWEIGHT_REDUCTION_PER_LEVEL = 0.2;
    private static final double LIGHTWEIGHT_SPEED_BONUS_PER_LEVEL = 0.05;
    private static final double RELOAD_SPEED_PENALTY = 0.75;
    private static final double LIGHTWEIGHT_RELOAD_BONUS_PER_LEVEL = 0.08;
    private static final double SWIFT_SNEAK_RELOAD_BONUS_PER_LEVEL = 0.05;
    private static int tickCounter = 0;
    private static final int UPDATE_INTERVAL = 20;

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            EquipmentSlot slot = event.getSlot();
            if (slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND || slot == EquipmentSlot.LEGS) {
                WeaponMovementEventHandler.updateSpeedAttribute(player);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().f_46443_) {
            return;
        }
        if (++tickCounter >= 20) {
            tickCounter = 0;
            WeaponMovementEventHandler.updateSpeedAttribute(event.player);
        }
    }

    private static void updateSpeedAttribute(Player player) {
        ItemStack relevantWeapon;
        boolean holdingGun;
        ItemStack mainHandItem = player.m_21205_();
        ItemStack offHandItem = player.m_21206_();
        ItemStack legsItem = player.m_6844_(EquipmentSlot.LEGS);
        AttributeInstance movementSpeed = player.m_21051_(Attributes.f_22279_);
        if (movementSpeed == null) {
            return;
        }
        movementSpeed.m_22120_(HEAVY_WEAPON_MODIFIER_UUID);
        movementSpeed.m_22120_(RELOAD_SPEED_MODIFIER_UUID);
        movementSpeed.m_22120_(LIGHTWEIGHT_SPEED_MODIFIER_UUID);
        boolean hasExoSuitLegs = legsItem.m_41720_() instanceof ExoSuitItem;
        boolean isReloading = (Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)player);
        boolean bl = holdingGun = mainHandItem.m_41720_() instanceof GunItem || offHandItem.m_41720_() instanceof GunItem;
        if (isReloading && !holdingGun) {
            ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
            isReloading = false;
        }
        float mainHandSpeedModifier = WeaponMovementEventHandler.getEffectiveSpeedModifier(mainHandItem, hasExoSuitLegs);
        float offHandSpeedModifier = WeaponMovementEventHandler.getEffectiveSpeedModifier(offHandItem, hasExoSuitLegs);
        float finalSpeedModifier = Math.min(mainHandSpeedModifier, offHandSpeedModifier);
        ItemStack itemStack = relevantWeapon = mainHandSpeedModifier < offHandSpeedModifier ? mainHandItem : offHandItem;
        if (finalSpeedModifier < 1.0f && WeaponMovementEventHandler.isHeavyWeapon(relevantWeapon)) {
            int lightweightLevel = relevantWeapon.getEnchantmentLevel((Enchantment)ModEnchantments.LIGHTWEIGHT.get());
            double reduction = 0.2 * (double)lightweightLevel;
            finalSpeedModifier = (float)Math.min(1.0, (double)finalSpeedModifier + reduction);
        }
        if (finalSpeedModifier != 1.0f) {
            AttributeModifier modifier = new AttributeModifier(HEAVY_WEAPON_MODIFIER_UUID, "Weapon Speed Modifier", (double)finalSpeedModifier - 1.0, AttributeModifier.Operation.MULTIPLY_BASE);
            movementSpeed.m_22118_(modifier);
        }
        if (holdingGun) {
            int level;
            ItemStack gunWithLightweight = null;
            int maxLightweightLevel = 0;
            if (mainHandItem.m_41720_() instanceof GunItem && (level = mainHandItem.getEnchantmentLevel((Enchantment)ModEnchantments.LIGHTWEIGHT.get())) > maxLightweightLevel) {
                maxLightweightLevel = level;
                gunWithLightweight = mainHandItem;
            }
            if (offHandItem.m_41720_() instanceof GunItem && (level = offHandItem.getEnchantmentLevel((Enchantment)ModEnchantments.LIGHTWEIGHT.get())) > maxLightweightLevel) {
                maxLightweightLevel = level;
                gunWithLightweight = offHandItem;
            }
            if (gunWithLightweight != null) {
                double speedBonus = 0.0;
                if (WeaponMovementEventHandler.isHeavyWeapon(gunWithLightweight)) {
                    if (maxLightweightLevel >= 2) {
                        speedBonus = 0.05;
                    }
                } else {
                    speedBonus = 0.05 * (double)maxLightweightLevel;
                }
                if (speedBonus > 0.0) {
                    AttributeModifier lightweightSpeedModifier = new AttributeModifier(LIGHTWEIGHT_SPEED_MODIFIER_UUID, "Lightweight Speed Bonus", speedBonus, AttributeModifier.Operation.MULTIPLY_BASE);
                    movementSpeed.m_22118_(lightweightSpeedModifier);
                }
            }
        }
        if (isReloading && holdingGun) {
            double reloadSpeedModifier = 0.75;
            ItemStack gunItem = mainHandItem.m_41720_() instanceof GunItem ? mainHandItem : offHandItem;
            int lightweightLevel = gunItem.getEnchantmentLevel((Enchantment)ModEnchantments.LIGHTWEIGHT.get());
            double lightweightBonus = 0.08 * (double)lightweightLevel;
            int swiftSneakLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_220304_, (ItemStack)legsItem);
            double swiftSneakBonus = 0.05 * (double)swiftSneakLevel;
            reloadSpeedModifier = Math.min(1.0, reloadSpeedModifier + lightweightBonus + swiftSneakBonus);
            AttributeModifier reloadModifier = new AttributeModifier(RELOAD_SPEED_MODIFIER_UUID, "Reload Speed Penalty", reloadSpeedModifier - 1.0, AttributeModifier.Operation.MULTIPLY_BASE);
            movementSpeed.m_22118_(reloadModifier);
        }
    }

    private static float getEffectiveSpeedModifier(ItemStack stack, boolean hasExoSuitLegs) {
        if (stack.m_41619_()) {
            return 1.0f;
        }
        Item item = stack.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            float baseModifier = gunItem.getGunProperties().getGeneral().getSpeedModifier();
            if (hasExoSuitLegs && baseModifier < 1.0f && WeaponMovementEventHandler.isHeavyWeapon(stack)) {
                return 1.0f;
            }
            return baseModifier;
        }
        return 1.0f;
    }

    private static boolean isHeavyWeapon(ItemStack itemStack) {
        return !itemStack.m_41619_() && itemStack.m_204117_(ModTags.Items.HEAVY_WEAPON);
    }
}

