/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.init;

import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import top.ribs.scguns.entity.projectile.ProjectileEntity;
import top.ribs.scguns.util.GunModifierHelper;

public class ModDamageTypes {
    public static final ResourceKey<DamageType> BULLET = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("scguns", "bullet"));
    public static final ResourceKey<DamageType> MELEE = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("scguns", "melee"));

    public static class Sources {
        private static Holder.Reference<DamageType> getHolder(RegistryAccess access, ResourceKey<DamageType> damageTypeKey) {
            return access.m_175515_(Registries.f_268580_).m_246971_(damageTypeKey);
        }

        public static DamageSource projectile(RegistryAccess access, @Nullable Entity directEntity, @Nullable Entity causingEntity) {
            return new DamageSource(Sources.getHolder(access, BULLET), directEntity, causingEntity);
        }

        private static DamageSource source(RegistryAccess access, ResourceKey<DamageType> damageTypeKey, @Nullable Entity directEntity, @Nullable Entity causingEntity) {
            return new BulletDamageSource((Holder<DamageType>)Sources.getHolder(access, damageTypeKey), directEntity, causingEntity);
        }

        public static DamageSource projectile(RegistryAccess access, ProjectileEntity projectile, LivingEntity entity) {
            return Sources.source(access, BULLET, projectile, (Entity)entity);
        }

        public static DamageSource melee(RegistryAccess access, LivingEntity entity) {
            return Sources.source(access, MELEE, null, (Entity)entity);
        }

        public static class BulletDamageSource
        extends DamageSource {
            private static final String[] msgSuffix = new String[]{"scguns.bullet.killed", "scguns.bullet.eliminated", "scguns.bullet.executed", "scguns.bullet.annihilated", "scguns.bullet.decimated"};

            public BulletDamageSource(Holder<DamageType> pType, Entity pDirectEntity, Entity pCausingEntity) {
                super(pType, pDirectEntity, pCausingEntity);
            }

            public Component m_6157_(LivingEntity pLivingEntity) {
                ItemStack itemStack;
                String s = "death.attack." + this.m_19385_();
                if (this.m_7639_() == null && this.m_7640_() == null) {
                    LivingEntity living = pLivingEntity.m_21232_();
                    return living != null ? Component.m_237110_((String)(s + ".player"), (Object[])new Object[]{pLivingEntity.m_5446_(), living.m_5446_()}) : Component.m_237110_((String)s, (Object[])new Object[]{pLivingEntity.m_5446_()});
                }
                Component component = this.m_7639_() == null ? this.m_7640_().m_5446_() : this.m_7639_().m_5446_();
                Entity entity = this.m_7639_();
                if (entity instanceof LivingEntity) {
                    LivingEntity livingentity = (LivingEntity)entity;
                    itemStack = livingentity.m_21205_();
                } else {
                    itemStack = ItemStack.f_41583_;
                }
                ItemStack stack = itemStack;
                boolean isSilenced = GunModifierHelper.isSilencedFire(stack);
                return isSilenced ? Component.m_237110_((String)(s + ".silenced"), (Object[])new Object[]{pLivingEntity.m_5446_()}) : (!stack.m_41619_() && stack.m_41788_() ? Component.m_237110_((String)(s + ".item"), (Object[])new Object[]{pLivingEntity.m_5446_(), component, stack.m_41611_()}) : Component.m_237110_((String)s, (Object[])new Object[]{pLivingEntity.m_5446_(), component}));
            }

            public String m_19385_() {
                return msgSuffix[ThreadLocalRandom.current().nextInt(5)];
            }
        }
    }
}

