/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import top.ribs.scguns.init.ModBlocks;

public class BatGuanoItem
extends Item {
    private static final float BASE_SUCCESS_CHANCE = 0.95f;
    private static final float ADJACENT_SPREAD_CHANCE = 0.45f;
    private static final float CASCADE_CHANCE = 0.15f;

    public BatGuanoItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        int i;
        Level world = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        Player player = context.m_43723_();
        ItemStack itemstack = context.m_43722_();
        BlockState blockstate = world.m_8055_(blockpos);
        if (blockstate.m_60734_() instanceof BonemealableBlock && BatGuanoItem.applyGuanoFertilizer(itemstack, world, blockpos, player)) {
            if (!world.f_46443_) {
                world.m_46796_(1505, blockpos, 0);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        if (blockstate.m_60713_((Block)ModBlocks.BAT_GUANO_LAYER.get()) && (i = ((Integer)blockstate.m_61143_((Property)SnowLayerBlock.f_56581_)).intValue()) < 8) {
            world.m_7731_(blockpos, (BlockState)blockstate.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(i + 1)), 2);
            if (player == null || !player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        BlockPos blockposAbove = blockpos.m_7494_();
        BlockState stateAbove = world.m_8055_(blockposAbove);
        if (stateAbove.m_60795_() && blockstate.m_60783_((BlockGetter)world, blockpos, Direction.UP)) {
            BlockState newState = ((Block)ModBlocks.BAT_GUANO_LAYER.get()).m_49966_();
            world.m_7731_(blockposAbove, newState, 2);
            if (player == null || !player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public static boolean applyGuanoFertilizer(ItemStack stack, Level world, BlockPos pos, Player player) {
        BonemealableBlock bonemealableblock;
        BlockState blockstate = world.m_8055_(pos);
        Block block = blockstate.m_60734_();
        if (block instanceof BonemealableBlock && (bonemealableblock = (BonemealableBlock)block).m_7370_((LevelReader)world, pos, blockstate, world.f_46443_)) {
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                RandomSource random = world.m_213780_();
                if (random.m_188501_() < 0.95f && bonemealableblock.m_214167_(world, random, pos, blockstate)) {
                    bonemealableblock.m_214148_(serverLevel, random, pos, blockstate);
                }
                if (random.m_188501_() < 0.45f) {
                    BatGuanoItem.spreadToAdjacent(serverLevel, pos, random, 0.15f);
                }
                stack.m_41774_(1);
            }
            return true;
        }
        return false;
    }

    private static void spreadToAdjacent(ServerLevel world, BlockPos centerPos, RandomSource random, float cascadeChance) {
        Direction[] directions;
        for (Direction direction : directions = (Direction[])Direction.Plane.HORIZONTAL.m_122557_().toArray(Direction[]::new)) {
            BonemealableBlock adjacentBonemeal;
            BlockPos adjacentPos = centerPos.m_121945_(direction);
            BlockState adjacentState = world.m_8055_(adjacentPos);
            Block block = adjacentState.m_60734_();
            if (!(block instanceof BonemealableBlock) || !(adjacentBonemeal = (BonemealableBlock)block).m_7370_((LevelReader)world, adjacentPos, adjacentState, false) || !adjacentBonemeal.m_214167_((Level)world, random, adjacentPos, adjacentState)) continue;
            adjacentBonemeal.m_214148_(world, random, adjacentPos, adjacentState);
            world.m_46796_(1505, adjacentPos, 0);
            if (!(random.m_188501_() < cascadeChance)) continue;
            BatGuanoItem.spreadToAdjacent(world, adjacentPos, random, cascadeChance * 0.5f);
        }
    }
}

