/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.item.animated;

import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import top.ribs.scguns.client.KeyBinds;
import top.ribs.scguns.client.render.armor.ExoSuitRenderer;
import top.ribs.scguns.client.screen.ExoSuitMenu;
import top.ribs.scguns.common.exosuit.ExoSuitData;
import top.ribs.scguns.common.exosuit.ExoSuitUpgrade;
import top.ribs.scguns.common.exosuit.ExoSuitUpgradeManager;
import top.ribs.scguns.item.exosuit.DamageableUpgradeItem;
import top.ribs.scguns.item.exosuit.GasMaskModuleItem;
import top.ribs.scguns.item.exosuit.NightVisionModuleItem;
import top.ribs.scguns.item.exosuit.RebreatherModuleItem;
import top.ribs.scguns.item.exosuit.TargetTrackerModuleItem;

public class ExoSuitItem
extends ArmorItem
implements GeoItem {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public ExoSuitItem(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, pProperties);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private ExoSuitRenderer renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new ExoSuitRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (player.m_6144_()) {
            if (!level.f_46443_) {
                this.openExoSuitScreen((ServerPlayer)player, hand);
            }
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        return super.m_7203_(level, player, hand);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player != null && player.m_6144_()) {
            if (!context.m_43725_().f_46443_) {
                this.openExoSuitScreen((ServerPlayer)player, context.m_43724_());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void openExoSuitScreen(ServerPlayer player, InteractionHand hand) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new ExoSuitMenuProvider(hand), buf -> buf.m_130068_((Enum)hand));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237115_((String)"tooltip.scguns.exosuit.frame"));
        if (ExoSuitData.hasUpgrades(stack)) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.scguns.exosuit.has_upgrades"));
            int upgradeCount = this.getCurrentUpgradeCount(stack);
            int maxSlots = this.getMaxUpgradeSlots();
            tooltip.add((Component)Component.m_237110_((String)"tooltip.scguns.exosuit.slots_used", (Object[])new Object[]{upgradeCount, maxSlots}).m_130940_(ChatFormatting.GRAY));
            this.addPowerCoreInfo(stack, tooltip);
            this.addPouchInfo(stack, tooltip);
            this.addUpgradeDurabilityInfo(stack, tooltip);
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.scguns.exosuit.no_upgrades"));
        }
        this.addSlotInformation(tooltip);
        tooltip.add((Component)Component.m_237110_((String)"info.scguns.exosuit_help", (Object[])new Object[]{KeyBinds.KEY_ATTACHMENTS.m_90863_().getString().toUpperCase(Locale.ENGLISH)}).m_130940_(ChatFormatting.YELLOW));
    }

    private void addPowerCoreInfo(ItemStack stack, List<Component> tooltip) {
        if (this.m_266204_() != ArmorItem.Type.CHESTPLATE) {
            return;
        }
        ItemStack powerCore = this.findPowerCore(stack);
        if (!powerCore.m_41619_()) {
            int energyStored = powerCore.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
            int maxEnergy = powerCore.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getMaxEnergyStored).orElse(0);
            if (maxEnergy > 0) {
                int energyPercent = energyStored * 100 / maxEnergy;
                ChatFormatting energyColor = this.getEnergyColor(energyPercent);
                tooltip.add((Component)Component.m_237113_((String)""));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.scguns.exosuit.power_core").m_130940_(ChatFormatting.YELLOW));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.scguns.exosuit.energy_level", (Object[])new Object[]{energyPercent}).m_130940_(energyColor));
            }
        }
    }

    private ItemStack findPowerCore(ItemStack stack) {
        for (int slot = 0; slot < this.getMaxUpgradeSlots(); ++slot) {
            ExoSuitUpgrade upgrade;
            ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(stack, slot);
            if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null || !upgrade.getType().equals("power_core")) continue;
            return upgradeItem;
        }
        return ItemStack.f_41583_;
    }

    private ChatFormatting getEnergyColor(int energyPercent) {
        if (energyPercent > 75) {
            return ChatFormatting.GREEN;
        }
        if (energyPercent > 50) {
            return ChatFormatting.YELLOW;
        }
        if (energyPercent > 25) {
            return ChatFormatting.GOLD;
        }
        if (energyPercent > 0) {
            return ChatFormatting.RED;
        }
        return ChatFormatting.DARK_RED;
    }

    private void addUpgradeDurabilityInfo(ItemStack stack, List<Component> tooltip) {
        boolean hasAnyDamageableUpgrades = false;
        for (int slot = 0; slot < this.getMaxUpgradeSlots(); ++slot) {
            ExoSuitUpgrade upgrade;
            ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(stack, slot);
            if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null || !this.isUpgradeDamageable(upgradeItem)) continue;
            if (!hasAnyDamageableUpgrades) {
                tooltip.add((Component)Component.m_237113_((String)""));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.scguns.exosuit.upgrade_condition").m_130940_(ChatFormatting.YELLOW));
                hasAnyDamageableUpgrades = true;
            }
            String upgradeName = this.getUpgradeDisplayName(upgrade, upgradeItem);
            int durabilityPercent = this.getDurabilityPercentage(upgradeItem);
            ChatFormatting color = this.getDurabilityColor(durabilityPercent);
            tooltip.add((Component)Component.m_237110_((String)"tooltip.scguns.exosuit.upgrade_durability", (Object[])new Object[]{upgradeName, durabilityPercent}).m_130940_(color));
        }
    }

    private String getUpgradeDisplayName(ExoSuitUpgrade upgrade, ItemStack upgradeItem) {
        String upgradeType = upgrade.getType();
        if ("hud".equals(upgradeType)) {
            if (upgradeItem.m_41720_() instanceof NightVisionModuleItem) {
                return Component.m_237115_((String)"upgrade.scguns.exosuit.night_vision").getString();
            }
            if (upgradeItem.m_41720_() instanceof TargetTrackerModuleItem) {
                return Component.m_237115_((String)"upgrade.scguns.exosuit.target_tracker").getString();
            }
            if (upgradeItem.m_41720_() instanceof GasMaskModuleItem) {
                return Component.m_237115_((String)"upgrade.scguns.exosuit.gas_mask").getString();
            }
            if (upgradeItem.m_41720_() instanceof RebreatherModuleItem) {
                return Component.m_237115_((String)"upgrade.scguns.exosuit.rebreather").getString();
            }
            return Component.m_237115_((String)"upgrade.scguns.exosuit.hud_system").getString();
        }
        if ("breathing".equals(upgradeType)) {
            if (upgradeItem.m_41720_() instanceof GasMaskModuleItem) {
                return Component.m_237115_((String)"upgrade.scguns.exosuit.gas_mask").getString();
            }
            if (upgradeItem.m_41720_() instanceof RebreatherModuleItem) {
                return Component.m_237115_((String)"upgrade.scguns.exosuit.rebreather").getString();
            }
            return Component.m_237115_((String)"upgrade.scguns.exosuit.life_support").getString();
        }
        return switch (upgradeType) {
            case "plating" -> Component.m_237115_((String)"upgrade.scguns.exosuit.armor_plating").getString();
            case "pauldron" -> Component.m_237115_((String)"upgrade.scguns.exosuit.pauldron").getString();
            case "power_core" -> Component.m_237115_((String)"upgrade.scguns.exosuit.power_core").getString();
            case "utility" -> Component.m_237115_((String)"upgrade.scguns.exosuit.utility_module").getString();
            case "knee_guard" -> Component.m_237115_((String)"upgrade.scguns.exosuit.knee_guard").getString();
            case "mobility" -> Component.m_237115_((String)"upgrade.scguns.exosuit.mobility_system").getString();
            default -> {
                String itemName = upgradeItem.m_41611_().getString();
                if (itemName.startsWith("Heavy ")) {
                    itemName = itemName.substring(6);
                }
                yield itemName;
            }
        };
    }

    private int getDurabilityPercentage(ItemStack upgradeItem) {
        if (!this.isUpgradeDamageable(upgradeItem)) {
            return 100;
        }
        int maxDamage = upgradeItem.m_41776_();
        int currentDamage = upgradeItem.m_41773_();
        if (maxDamage <= 0) {
            return 100;
        }
        int remainingDurability = maxDamage - currentDamage;
        return Math.max(0, remainingDurability * 100 / maxDamage);
    }

    private ChatFormatting getDurabilityColor(int durabilityPercent) {
        if (durabilityPercent > 75) {
            return ChatFormatting.GREEN;
        }
        if (durabilityPercent > 50) {
            return ChatFormatting.YELLOW;
        }
        if (durabilityPercent > 25) {
            return ChatFormatting.GOLD;
        }
        if (durabilityPercent > 0) {
            return ChatFormatting.RED;
        }
        return ChatFormatting.DARK_RED;
    }

    private boolean isUpgradeDamageable(ItemStack upgradeItem) {
        if (upgradeItem.m_41619_()) {
            return false;
        }
        if (upgradeItem.m_41720_() instanceof DamageableUpgradeItem) {
            return true;
        }
        if (upgradeItem.m_41763_()) {
            return true;
        }
        return upgradeItem.m_41776_() > 0;
    }

    private void addPouchInfo(ItemStack stack, List<Component> tooltip) {
        ExoSuitUpgrade upgrade;
        if (this.m_266204_() != ArmorItem.Type.CHESTPLATE) {
            return;
        }
        ItemStack pouchUpgrade = this.findPouchUpgrade(stack);
        if (!pouchUpgrade.m_41619_() && (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(pouchUpgrade)) != null) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.scguns.exosuit.pouches").m_130940_(ChatFormatting.YELLOW));
            String pouchName = pouchUpgrade.m_41611_().getString();
            tooltip.add((Component)Component.m_237110_((String)"tooltip.scguns.exosuit.pouch_equipped", (Object[])new Object[]{pouchName}).m_130940_(ChatFormatting.GREEN));
            if (this.isPouchEmpty(stack, pouchUpgrade)) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.scguns.exosuit.pouch_empty").m_130940_(ChatFormatting.DARK_GREEN));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.scguns.exosuit.pouch_has_items").m_130940_(ChatFormatting.GOLD));
            }
        }
    }

    private ItemStack findPouchUpgrade(ItemStack stack) {
        for (int slot = 0; slot < this.getMaxUpgradeSlots(); ++slot) {
            ExoSuitUpgrade upgrade;
            ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(stack, slot);
            if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null || !upgrade.getType().equals("pouches")) continue;
            return upgradeItem;
        }
        return ItemStack.f_41583_;
    }

    private boolean isPouchEmpty(ItemStack chestplate, ItemStack pouchUpgrade) {
        try {
            String pouchId = pouchUpgrade.m_41720_().toString();
            CompoundTag pouchData = chestplate.m_41784_().m_128469_("PouchData");
            if (!pouchData.m_128441_(pouchId)) {
                return true;
            }
            ExoSuitUpgrade upgrade = ExoSuitUpgradeManager.getUpgradeForItem(pouchUpgrade);
            if (upgrade == null) {
                return true;
            }
            ItemStackHandler handler = new ItemStackHandler(upgrade.getDisplay().getStorageSize());
            handler.deserializeNBT(pouchData.m_128469_(pouchId));
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (handler.getStackInSlot(i).m_41619_()) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return true;
        }
    }

    private void addSlotInformation(List<Component> tooltip) {
        switch (this.m_266204_()) {
            case HELMET: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.scguns.exosuit.slots.helmet"));
                break;
            }
            case CHESTPLATE: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.scguns.exosuit.slots.chest"));
                break;
            }
            case LEGGINGS: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.scguns.exosuit.slots.legs"));
                break;
            }
            case BOOTS: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.scguns.exosuit.slots.boots"));
            }
        }
    }

    public int getMaxUpgradeSlots() {
        return switch (this.m_266204_()) {
            default -> throw new IncompatibleClassChangeError();
            case ArmorItem.Type.HELMET -> 3;
            case ArmorItem.Type.CHESTPLATE -> 4;
            case ArmorItem.Type.LEGGINGS -> 3;
            case ArmorItem.Type.BOOTS -> 2;
        };
    }

    public int getCurrentUpgradeCount(ItemStack stack) {
        CompoundTag upgradeData = ExoSuitData.getUpgradeData(stack);
        if (upgradeData.m_128441_("Upgrades")) {
            ListTag upgradeList = upgradeData.m_128437_("Upgrades", 10);
            return upgradeList.size();
        }
        return 0;
    }

    private PlayState predicate(AnimationState animationState) {
        animationState.getController().setAnimation(RawAnimation.begin().then("animation.exo_suit.idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public record ExoSuitMenuProvider(InteractionHand hand) implements MenuProvider
    {
        @NotNull
        public Component m_5446_() {
            return Component.m_237115_((String)"container.scguns.exosuit");
        }

        public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
            return new ExoSuitMenu(id, playerInventory, this.hand);
        }
    }
}

