/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.item.animated;

import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import top.ribs.scguns.client.render.armor.IronMaskArmorRenderer;
import top.ribs.scguns.entity.monster.PraetorEntity;
import top.ribs.scguns.init.ModEntities;
import top.ribs.scguns.init.ModSounds;

public class IronMaskArmorItem
extends ArmorItem
implements GeoItem {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public IronMaskArmorItem(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, pProperties);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private IronMaskArmorRenderer renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new IronMaskArmorRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        Player player = pContext.m_43723_();
        Level level = pContext.m_43725_();
        BlockPos pos = pContext.m_8083_();
        if (player != null && player.m_6144_() && this.isValidPraetorRitualStructure(level, pos)) {
            if (!level.m_5776_()) {
                if (!player.m_150110_().f_35937_) {
                    pContext.m_43722_().m_41774_(1);
                }
                BlockPos centerPos = this.findCenterPosition(level, pos);
                level.m_7731_(centerPos, Blocks.f_50016_.m_49966_(), 3);
                level.m_7731_(centerPos.m_7494_(), Blocks.f_50016_.m_49966_(), 3);
                level.m_7731_(centerPos.m_7494_().m_122024_(), Blocks.f_50016_.m_49966_(), 3);
                level.m_7731_(centerPos.m_7494_().m_122029_(), Blocks.f_50016_.m_49966_(), 3);
                level.m_7731_(centerPos.m_7494_().m_122012_(), Blocks.f_50016_.m_49966_(), 3);
                level.m_7731_(centerPos.m_7494_().m_122019_(), Blocks.f_50016_.m_49966_(), 3);
                this.spawnCreationEffects((ServerLevel)level, centerPos.m_7494_());
                level.m_5594_(null, centerPos, SoundEvents.f_11668_, SoundSource.BLOCKS, 1.0f, 0.6f);
                level.m_5594_(null, centerPos, SoundEvents.f_12090_, SoundSource.BLOCKS, 0.6f, 1.2f);
                double random = level.f_46441_.m_188500_();
                if (random < 0.5) {
                    Vindicator vindicator = new Vindicator(EntityType.f_20493_, level);
                    vindicator.m_7678_((double)centerPos.m_123341_() + 0.5, (double)centerPos.m_123342_(), (double)centerPos.m_123343_() + 0.5, 0.0f, 0.0f);
                    level.m_7967_((Entity)vindicator);
                    level.m_5594_(null, centerPos, SoundEvents.f_12577_, SoundSource.HOSTILE, 1.0f, 0.8f);
                } else if (random < 0.75) {
                    PraetorEntity praetor = this.createNeutralPraetor(level, centerPos, player);
                    level.m_7967_((Entity)praetor);
                    level.m_5594_(null, centerPos, (SoundEvent)ModSounds.PRAETOR_IDLE.get(), SoundSource.HOSTILE, 1.0f, 1.2f);
                } else {
                    PraetorEntity praetor = new PraetorEntity((EntityType<? extends PraetorEntity>)((EntityType)ModEntities.PRAETOR.get()), level);
                    praetor.m_7678_((double)centerPos.m_123341_() + 0.5, centerPos.m_123342_(), (double)centerPos.m_123343_() + 0.5, 0.0f, 0.0f);
                    level.m_7967_((Entity)praetor);
                    level.m_5594_(null, centerPos, (SoundEvent)ModSounds.PRAETOR_IDLE.get(), SoundSource.HOSTILE, 1.0f, 0.8f);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(pContext);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        if (pPlayer.m_6144_()) {
            return InteractionResultHolder.m_19098_((Object)pPlayer.m_21120_(pHand));
        }
        return super.m_7203_(pLevel, pPlayer, pHand);
    }

    private boolean isValidPraetorRitualStructure(Level level, BlockPos pos) {
        BlockState clickedBlock = level.m_8055_(pos);
        if (!clickedBlock.m_60713_(Blocks.f_50129_)) {
            return false;
        }
        if (this.isTShapeNorth(level, pos)) {
            return true;
        }
        if (this.isTShapeSouth(level, pos)) {
            return true;
        }
        if (this.isTShapeEast(level, pos)) {
            return true;
        }
        if (this.isTShapeWest(level, pos)) {
            return true;
        }
        if (this.isTShapeNorth(level, pos.m_7495_())) {
            return true;
        }
        if (this.isTShapeSouth(level, pos.m_7495_())) {
            return true;
        }
        if (this.isTShapeEast(level, pos.m_7495_())) {
            return true;
        }
        if (this.isTShapeWest(level, pos.m_7495_())) {
            return true;
        }
        if (this.isTShapeNorth(level, pos.m_122012_())) {
            return true;
        }
        if (this.isTShapeSouth(level, pos.m_122019_())) {
            return true;
        }
        if (this.isTShapeEast(level, pos.m_122029_())) {
            return true;
        }
        return this.isTShapeWest(level, pos.m_122024_());
    }

    private boolean isTShapeNorth(Level level, BlockPos basePos) {
        return level.m_8055_(basePos).m_60713_(Blocks.f_50129_) && level.m_8055_(basePos.m_7494_()).m_60713_(Blocks.f_50129_) && level.m_8055_(basePos.m_7494_().m_122024_()).m_60713_(Blocks.f_50129_) && level.m_8055_(basePos.m_7494_().m_122029_()).m_60713_(Blocks.f_50129_);
    }

    private boolean isTShapeSouth(Level level, BlockPos basePos) {
        return level.m_8055_(basePos).m_60713_(Blocks.f_50129_) && level.m_8055_(basePos.m_7494_()).m_60713_(Blocks.f_50129_) && level.m_8055_(basePos.m_7494_().m_122024_()).m_60713_(Blocks.f_50129_) && level.m_8055_(basePos.m_7494_().m_122029_()).m_60713_(Blocks.f_50129_);
    }

    private boolean isTShapeEast(Level level, BlockPos basePos) {
        return level.m_8055_(basePos).m_60713_(Blocks.f_50129_) && level.m_8055_(basePos.m_7494_()).m_60713_(Blocks.f_50129_) && level.m_8055_(basePos.m_7494_().m_122012_()).m_60713_(Blocks.f_50129_) && level.m_8055_(basePos.m_7494_().m_122019_()).m_60713_(Blocks.f_50129_);
    }

    private boolean isTShapeWest(Level level, BlockPos basePos) {
        return level.m_8055_(basePos).m_60713_(Blocks.f_50129_) && level.m_8055_(basePos.m_7494_()).m_60713_(Blocks.f_50129_) && level.m_8055_(basePos.m_7494_().m_122012_()).m_60713_(Blocks.f_50129_) && level.m_8055_(basePos.m_7494_().m_122019_()).m_60713_(Blocks.f_50129_);
    }

    private BlockPos findCenterPosition(Level level, BlockPos pos) {
        if (this.isTShapeNorth(level, pos) || this.isTShapeSouth(level, pos) || this.isTShapeEast(level, pos) || this.isTShapeWest(level, pos)) {
            return pos;
        }
        if (this.isTShapeNorth(level, pos.m_7495_()) || this.isTShapeSouth(level, pos.m_7495_()) || this.isTShapeEast(level, pos.m_7495_()) || this.isTShapeWest(level, pos.m_7495_())) {
            return pos.m_7495_();
        }
        if (this.isTShapeNorth(level, pos.m_122012_()) || this.isTShapeSouth(level, pos.m_122012_()) || this.isTShapeEast(level, pos.m_122012_()) || this.isTShapeWest(level, pos.m_122012_())) {
            return pos.m_122012_();
        }
        if (this.isTShapeNorth(level, pos.m_122019_()) || this.isTShapeSouth(level, pos.m_122019_()) || this.isTShapeEast(level, pos.m_122019_()) || this.isTShapeWest(level, pos.m_122019_())) {
            return pos.m_122019_();
        }
        if (this.isTShapeNorth(level, pos.m_122029_()) || this.isTShapeSouth(level, pos.m_122029_()) || this.isTShapeEast(level, pos.m_122029_()) || this.isTShapeWest(level, pos.m_122029_())) {
            return pos.m_122029_();
        }
        if (this.isTShapeNorth(level, pos.m_122024_()) || this.isTShapeSouth(level, pos.m_122024_()) || this.isTShapeEast(level, pos.m_122024_()) || this.isTShapeWest(level, pos.m_122024_())) {
            return pos.m_122024_();
        }
        return pos;
    }

    private void spawnCreationEffects(ServerLevel level, BlockPos pos) {
        double z;
        double y;
        double x;
        int i;
        for (i = 0; i < 30; ++i) {
            x = (double)pos.m_123341_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 2.5;
            y = (double)pos.m_123342_() + level.f_46441_.m_188500_() * 2.5;
            z = (double)pos.m_123343_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 2.5;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 1, 0.0, 0.0, 0.0, 0.05);
        }
        for (i = 0; i < 20; ++i) {
            x = (double)pos.m_123341_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 2.0;
            y = (double)pos.m_123342_() + level.f_46441_.m_188500_() * 2.0;
            z = (double)pos.m_123343_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 2.0;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123755_, x, y, z, 1, 0.0, 0.1, 0.0, 0.05);
        }
    }

    private PraetorEntity createNeutralPraetor(Level level, BlockPos centerPos, Player creator) {
        PraetorEntity praetor = new PraetorEntity((EntityType<? extends PraetorEntity>)((EntityType)ModEntities.PRAETOR.get()), level);
        praetor.m_7678_((double)centerPos.m_123341_() + 0.5, centerPos.m_123342_(), (double)centerPos.m_123343_() + 0.5, 0.0f, 0.0f);
        AttributeInstance maxHealthAttribute = praetor.m_21051_(Attributes.f_22276_);
        if (maxHealthAttribute != null) {
            maxHealthAttribute.m_22100_(maxHealthAttribute.m_22115_() * 0.6);
            praetor.m_21153_((float)maxHealthAttribute.m_22135_());
        }
        if (creator != null) {
            praetor.f_21346_.m_148105_().removeIf(goal -> goal.m_26015_() instanceof NearestAttackableTargetGoal);
            praetor.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)praetor, Player.class, 10, true, false, player -> player != creator && !((Player)player).m_7500_() && !player.m_5833_()));
        }
        return praetor;
    }

    private PlayState predicate(AnimationState animationState) {
        animationState.getController().setAnimation(RawAnimation.begin().then("animation.iron_mask.idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

