/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.item.exosuit;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import top.ribs.scguns.Config;

public class ExoSuitCoreItem
extends Item {
    private final CoreTier tier;

    public ExoSuitCoreItem(Item.Properties properties, CoreTier tier) {
        super(properties);
        this.tier = tier;
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICapabilityProvider(){
            private final LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> new SimpleExoSuitEnergyStorage(stack, ExoSuitCoreItem.this.tier.getCapacity()));

            public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
                return cap == ForgeCapabilities.ENERGY ? this.energy.cast() : LazyOptional.empty();
            }
        };
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        int energyStored = this.getEnergyStored(stack);
        int maxEnergy = this.getMaxEnergyStored(stack);
        if (maxEnergy == 0) {
            return 0;
        }
        return Math.round(13.0f * (float)energyStored / (float)maxEnergy);
    }

    public int m_142159_(ItemStack stack) {
        float ratio = (float)this.getEnergyStored(stack) / (float)this.getMaxEnergyStored(stack);
        if (ratio > 0.66f) {
            return 65535;
        }
        if (ratio > 0.33f) {
            return 0xFFFF00;
        }
        return 0xFF4444;
    }

    public int getEnergyStored(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    public int getMaxEnergyStored(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getMaxEnergyStored).orElse(0);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, worldIn, tooltip, flag);
        int energyStored = this.getEnergyStored(stack);
        int maxEnergy = this.getMaxEnergyStored(stack);
        tooltip.add((Component)Component.m_237115_((String)"tooltip.scguns.energy").m_130946_(": ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)String.format("%,d", energyStored)).m_130940_(ChatFormatting.BLUE)).m_7220_((Component)Component.m_237113_((String)" / ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)(String.format("%,d", maxEnergy) + " FE")).m_130940_(ChatFormatting.BLUE)));
    }

    public static enum CoreTier {
        BASIC("Basic"),
        ADVANCED("Advanced"),
        ELITE("Elite");

        private final String displayName;

        private CoreTier(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public int getCapacity() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case BASIC -> (Integer)Config.COMMON.exoSuitCores.basicCoreCapacity.get();
                case ADVANCED -> (Integer)Config.COMMON.exoSuitCores.advancedCoreCapacity.get();
                case ELITE -> (Integer)Config.COMMON.exoSuitCores.eliteCoreCapacity.get();
            };
        }
    }

    public static class SimpleExoSuitEnergyStorage
    implements IEnergyStorage {
        private final ItemStack stack;
        private final int capacity;

        public SimpleExoSuitEnergyStorage(ItemStack stack, int capacity) {
            this.stack = stack;
            this.capacity = capacity;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int currentEnergy = this.getEnergyFromNBT();
            int energyReceived = Math.min(this.capacity - currentEnergy, maxReceive);
            if (!simulate && energyReceived > 0) {
                this.setEnergyToNBT(currentEnergy + energyReceived);
            }
            return energyReceived;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int currentEnergy = this.getEnergyFromNBT();
            int energyExtracted = Math.min(currentEnergy, maxExtract);
            if (!simulate && energyExtracted > 0) {
                this.setEnergyToNBT(currentEnergy - energyExtracted);
            }
            return energyExtracted;
        }

        public int getEnergyStored() {
            return this.getEnergyFromNBT();
        }

        public int getMaxEnergyStored() {
            return this.capacity;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }

        private int getEnergyFromNBT() {
            CompoundTag tag = this.stack.m_41783_();
            return tag != null && tag.m_128425_("Energy", 3) ? tag.m_128451_("Energy") : 0;
        }

        private void setEnergyToNBT(int energy) {
            CompoundTag tag = this.stack.m_41784_();
            tag.m_128405_("Energy", Math.max(0, Math.min(energy, this.capacity)));
        }
    }
}

