/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.mixin.client;

import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.ribs.scguns.client.handler.AimingHandler;
import top.ribs.scguns.client.render.IHeldAnimation;
import top.ribs.scguns.client.render.pose.AimPose;
import top.ribs.scguns.client.render.pose.LimbPose;
import top.ribs.scguns.client.render.pose.WeaponPose;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.event.VehicleDetectionHandler;
import top.ribs.scguns.item.GunItem;

@Mixin(value={PlayerModel.class}, priority=1100)
public class VehiclePoseMixin<T extends LivingEntity> {
    @Inject(method={"setupAnim*"}, at={@At(value="RETURN")}, cancellable=false)
    private void applyVehicleGunPoses(T entity, float animationPos, float animationSpeed, float animationBob, float deltaHeadYaw, float headPitch, CallbackInfo ci) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!VehicleDetectionHandler.isPlayerInVehicle(player)) {
            return;
        }
        ItemStack heldItem = player.m_21205_();
        Item item = heldItem.m_41720_();
        if (!(item instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)item;
        PlayerModel model = (PlayerModel)this;
        float aimProgress = 0.0f;
        if (player.m_7578_()) {
            aimProgress = AimingHandler.get().getAimProgress(player, Minecraft.m_91087_().m_91296_());
        }
        Gun gun = gunItem.getModifiedGun(heldItem);
        this.applyAdaptedPose(gun, heldItem, model, aimProgress);
        VehiclePoseMixin.copyModelAngles(model.f_102811_, model.f_103375_);
        VehiclePoseMixin.copyModelAngles(model.f_102812_, model.f_103374_);
        VehiclePoseMixin.copyModelAngles(model.f_102808_, model.f_102809_);
    }

    private void applyAdaptedPose(Gun gun, ItemStack stack, PlayerModel<T> model, float aimProgress) {
        try {
            WeaponPose weaponPose;
            AimPose forwardPose;
            IHeldAnimation heldAnimation = gun.getGeneral().getGripType(stack).heldAnimation();
            if (heldAnimation instanceof WeaponPose && (forwardPose = this.getForwardPose(weaponPose = (WeaponPose)heldAnimation)) != null) {
                this.applyModifiedPose(forwardPose, model.f_102811_, model.f_102812_, aimProgress);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.applyFallbackPose(model.f_102811_, model.f_102812_, aimProgress);
    }

    private AimPose getForwardPose(WeaponPose weaponPose) {
        try {
            Method getForwardPoseMethod = WeaponPose.class.getDeclaredMethod("getForwardPose", new Class[0]);
            getForwardPoseMethod.setAccessible(true);
            return (AimPose)getForwardPoseMethod.invoke((Object)weaponPose, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void applyModifiedPose(AimPose forwardPose, ModelPart rightArm, ModelPart leftArm, float aimProgress) {
        AimPose.Instance idlePose = forwardPose.getIdle();
        AimPose.Instance aimingPose = forwardPose.getAiming();
        LimbPose rightArmIdle = idlePose.getRightArm();
        LimbPose rightArmAiming = aimingPose != null ? aimingPose.getRightArm() : rightArmIdle;
        this.applyLimbPose(rightArmIdle, rightArmAiming, rightArm, aimProgress, true);
        LimbPose leftArmIdle = idlePose.getLeftArm();
        LimbPose leftArmAiming = aimingPose != null ? aimingPose.getLeftArm() : leftArmIdle;
        this.applyLimbPose(leftArmIdle, leftArmAiming, leftArm, aimProgress, false);
    }

    private void applyLimbPose(LimbPose idlePose, LimbPose aimingPose, ModelPart modelPart, float aimProgress, boolean isRightArm) {
        float rotX = this.interpolate(idlePose.getRotationAngleX(), aimingPose.getRotationAngleX(), aimProgress);
        float rotY = this.interpolate(idlePose.getRotationAngleY(), aimingPose.getRotationAngleY(), aimProgress);
        float rotZ = this.interpolate(idlePose.getRotationAngleZ(), aimingPose.getRotationAngleZ(), aimProgress);
        if (isRightArm) {
            rotX = Math.max(rotX, -120.0f);
            modelPart.f_104203_ = (float)Math.toRadians(rotX);
            modelPart.f_104204_ = (float)Math.toRadians(Math.min(Math.abs(rotY), 15.0f) * Math.signum(rotY));
            modelPart.f_104205_ = (float)Math.toRadians(rotZ * 0.5f);
        } else {
            modelPart.f_104203_ = (float)Math.toRadians(-20.0);
            modelPart.f_104204_ = (float)Math.toRadians(15.0);
            modelPart.f_104205_ = 0.0f;
        }
        if (idlePose.getRotationPointX() != null) {
            modelPart.f_104200_ = this.interpolate(idlePose.getRotationPointX(), aimingPose.getRotationPointX() != null ? aimingPose.getRotationPointX() : idlePose.getRotationPointX(), aimProgress);
        }
        if (idlePose.getRotationPointY() != null) {
            modelPart.f_104201_ = this.interpolate(idlePose.getRotationPointY(), aimingPose.getRotationPointY() != null ? aimingPose.getRotationPointY() : idlePose.getRotationPointY(), aimProgress);
        }
        if (idlePose.getRotationPointZ() != null) {
            modelPart.f_104202_ = this.interpolate(idlePose.getRotationPointZ(), aimingPose.getRotationPointZ() != null ? aimingPose.getRotationPointZ() : idlePose.getRotationPointZ(), aimProgress);
        }
    }

    private float interpolate(Float start, Float end, float progress) {
        if (start == null) {
            start = Float.valueOf(0.0f);
        }
        if (end == null) {
            end = start;
        }
        return start.floatValue() + (end.floatValue() - start.floatValue()) * progress;
    }

    private void applyFallbackPose(ModelPart rightArm, ModelPart leftArm, float aimProgress) {
        rightArm.f_104203_ = (float)Math.toRadians(-80.0);
        rightArm.f_104204_ = (float)Math.toRadians(-10.0);
        rightArm.f_104205_ = 0.0f;
        leftArm.f_104203_ = (float)Math.toRadians(-20.0);
        leftArm.f_104204_ = (float)Math.toRadians(15.0);
        leftArm.f_104205_ = 0.0f;
    }

    private static void copyModelAngles(ModelPart source, ModelPart target) {
        target.f_104203_ = source.f_104203_;
        target.f_104204_ = source.f_104204_;
        target.f_104205_ = source.f_104205_;
    }
}

