/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.network.message;

import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import top.ribs.scguns.client.network.ClientPlayHandler;

public class S2CMessageSyncUpgradeRegistry
extends PlayMessage<S2CMessageSyncUpgradeRegistry> {
    private Map<ResourceLocation, CompoundTag> upgradeData;

    public S2CMessageSyncUpgradeRegistry() {
        this.upgradeData = new HashMap<ResourceLocation, CompoundTag>();
    }

    public S2CMessageSyncUpgradeRegistry(Map<ResourceLocation, CompoundTag> upgradeData) {
        this.upgradeData = upgradeData;
    }

    public void encode(S2CMessageSyncUpgradeRegistry message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.upgradeData.size());
        for (Map.Entry<ResourceLocation, CompoundTag> entry : message.upgradeData.entrySet()) {
            buffer.m_130085_(entry.getKey());
            buffer.m_130079_(entry.getValue());
        }
    }

    public S2CMessageSyncUpgradeRegistry decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<ResourceLocation, CompoundTag> upgradeData = new HashMap<ResourceLocation, CompoundTag>();
        for (int i = 0; i < size; ++i) {
            ResourceLocation itemId = buffer.m_130281_();
            CompoundTag tag = buffer.m_130260_();
            upgradeData.put(itemId, tag);
        }
        return new S2CMessageSyncUpgradeRegistry(upgradeData);
    }

    public void handle(S2CMessageSyncUpgradeRegistry message, MessageContext context) {
        context.execute(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPlayHandler.handleSyncUpgradeRegistry(message)));
        context.setHandled(true);
    }

    public Map<ResourceLocation, CompoundTag> getUpgradeData() {
        return this.upgradeData;
    }
}

