/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.ribs.scguns.block.LightningRodConnectorBlock;
import top.ribs.scguns.blockentity.LightningBatteryBlockEntity;

public class LightningBattery
extends Block
implements EntityBlock {
    public static final BooleanProperty CHARGED = BooleanProperty.m_61465_((String)"charged");
    public static final EnumProperty<ChargeLevel> CHARGE_LEVEL = EnumProperty.m_61587_((String)"charge_level", ChargeLevel.class);
    private static final int CHARGE_AMOUNT = 8000;

    public LightningBattery(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)CHARGED, (Comparable)Boolean.FALSE)).m_61124_(CHARGE_LEVEL, (Comparable)((Object)ChargeLevel.NONE)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{CHARGED, CHARGE_LEVEL});
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, world, pos, oldState, isMoving);
        if (!world.f_46443_) {
            world.m_186460_(pos, (Block)this, 1);
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof LightningBatteryBlockEntity) {
                ((LightningBatteryBlockEntity)blockEntity).drops();
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, world, pos, block, fromPos, isMoving);
        if (world.m_46470_() && this.isNearbyRodPowered(world, pos)) {
            this.chargeBattery(world, pos, state);
        }
    }

    private void chargeBattery(Level world, BlockPos pos, BlockState state) {
        LightningBatteryBlockEntity battery;
        int energyStored;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof LightningBatteryBlockEntity && (energyStored = (battery = (LightningBatteryBlockEntity)blockEntity).getEnergy()) < battery.getMaxEnergy()) {
            int energyToAdd = Math.min(8000, battery.getMaxEnergy() - energyStored);
            battery.setEnergyStored(energyStored + energyToAdd);
            world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)CHARGED, (Comparable)Boolean.valueOf(true))).m_61124_(CHARGE_LEVEL, (Comparable)((Object)LightningBattery.calculateChargeLevel(energyStored + energyToAdd))), 3);
        }
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)CHARGED)).booleanValue()) {
            for (int i = 0; i < 5; ++i) {
                double d0 = (double)pos.m_123341_() + random.m_188500_();
                double d1 = (double)pos.m_123342_() + random.m_188500_();
                double d2 = (double)pos.m_123343_() + random.m_188500_();
                world.m_7106_((ParticleOptions)ParticleTypes.f_175830_, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof LightningBatteryBlockEntity) {
            LightningBatteryBlockEntity batteryEntity = (LightningBatteryBlockEntity)blockEntity;
            batteryEntity.tick();
        }
        world.m_186460_(pos, (Block)this, 1);
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, @NotNull Level world, @NotNull BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.f_46443_) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof LightningBatteryBlockEntity) {
                LightningBatteryBlockEntity containerProvider = (LightningBatteryBlockEntity)blockEntity;
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerProvider, (BlockPos)pos);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public static ChargeLevel calculateChargeLevel(int energyStored) {
        if (energyStored > 24000) {
            return ChargeLevel.HIGH;
        }
        if (energyStored > 12000) {
            return ChargeLevel.MID;
        }
        if (energyStored > 0) {
            return ChargeLevel.LOW;
        }
        return ChargeLevel.NONE;
    }

    private boolean isNearbyRodPowered(Level world, BlockPos pos) {
        for (int y = 1; y <= 5; ++y) {
            BlockPos abovePos = pos.m_6630_(y);
            BlockState state = world.m_8055_(abovePos);
            if (!(state.m_60734_() instanceof LightningRodBlock) && !(state.m_60734_() instanceof LightningRodConnectorBlock) || !((Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new LightningBatteryBlockEntity(pos, state);
    }

    public static enum ChargeLevel implements StringRepresentable
    {
        NONE("none"),
        LOW("low"),
        MID("mid"),
        HIGH("high");

        private final String name;

        private ChargeLevel(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.m_7912_();
        }
    }
}

