/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import top.ribs.scguns.block.AmmoModuleBlock;
import top.ribs.scguns.init.ModBlockEntities;

public class AmmoModuleBlockEntity
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level p_155062_, BlockPos p_155063_, BlockState p_155064_) {
            AmmoModuleBlockEntity.this.playSound(p_155064_, SoundEvents.f_11725_);
        }

        protected void m_142289_(Level p_155072_, BlockPos p_155073_, BlockState p_155074_) {
            AmmoModuleBlockEntity.this.playSound(p_155074_, SoundEvents.f_11724_);
        }

        protected void m_142148_(Level p_155066_, BlockPos p_155067_, BlockState p_155068_, int p_155069_, int p_155070_) {
        }

        protected boolean m_142718_(Player p_155060_) {
            if (p_155060_.f_36096_ instanceof ChestMenu) {
                Container $$1 = ((ChestMenu)p_155060_.f_36096_).m_39261_();
                return $$1 == AmmoModuleBlockEntity.this;
            }
            return false;
        }
    };
    private int transferCooldown = 0;
    private static final int TRANSFER_COOLDOWN = 3;

    public AmmoModuleBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.AMMO_MODULE.get(), pPos, pBlockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AmmoModuleBlockEntity ammoModule) {
        if (level.m_5776_()) {
            return;
        }
        if (ammoModule.transferCooldown > 0) {
            --ammoModule.transferCooldown;
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)AmmoModuleBlock.FACING);
        Direction targetDirection = facing.m_122424_();
        BlockPos adjacentPos = pos.m_121945_(targetDirection);
        BlockEntity adjacentEntity = level.m_7702_(adjacentPos);
        if (adjacentEntity != null) {
            adjacentEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> AmmoModuleBlockEntity.transferItemToInventory(ammoModule, handler));
        }
        ammoModule.transferCooldown = 3;
    }

    private static void transferItemToInventory(AmmoModuleBlockEntity ammoModule, IItemHandler handler) {
        for (int i = 0; i < ammoModule.m_6643_(); ++i) {
            ItemStack stack = ammoModule.m_8020_(i);
            if (stack.m_41619_()) continue;
            ItemStack singleItemStack = stack.m_41620_(1);
            ItemStack remainingStack = TransferHelper.transferItemToInventory(handler, singleItemStack);
            if (!remainingStack.m_41619_()) {
                stack.m_41769_(remainingStack.m_41613_());
            }
            ammoModule.m_6836_(i, stack);
            ammoModule.m_6596_();
            break;
        }
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> items) {
        this.items = items;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.ammo_module");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory playerInventory) {
        return ChestMenu.m_39237_((int)id, (Inventory)playerInventory, (Container)this);
    }

    public int m_6643_() {
        return 27;
    }

    public void m_5856_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    void playSound(BlockState state, SoundEvent sound) {
        Vec3i directionVec = ((Direction)state.m_61143_((Property)AmmoModuleBlock.FACING)).m_122436_();
        double x = (double)this.f_58858_.m_123341_() + 0.5 + (double)directionVec.m_123341_() / 2.0;
        double y = (double)this.f_58858_.m_123342_() + 0.5 + (double)directionVec.m_123342_() / 2.0;
        double z = (double)this.f_58858_.m_123343_() + 0.5 + (double)directionVec.m_123343_() / 2.0;
        this.f_58857_.m_6263_(null, x, y, z, sound, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("TransferCooldown", this.transferCooldown);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.transferCooldown = tag.m_128451_("TransferCooldown");
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
    }

    public IItemHandlerModifiable getItemStackHandler() {
        return new IItemHandlerModifiable(){

            public void setStackInSlot(int slot, ItemStack stack) {
                AmmoModuleBlockEntity.this.items.set(slot, (Object)stack);
            }

            public int getSlots() {
                return AmmoModuleBlockEntity.this.items.size();
            }

            public ItemStack getStackInSlot(int slot) {
                return (ItemStack)AmmoModuleBlockEntity.this.items.get(slot);
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                return stack;
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return (ItemStack)AmmoModuleBlockEntity.this.items.get(slot);
            }

            public int getSlotLimit(int slot) {
                return 64;
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                return true;
            }
        };
    }

    public static class TransferHelper {
        public static ItemStack transferItemToInventory(IItemHandler inventory, ItemStack stack) {
            ItemStack remainingStack = stack.m_41777_();
            for (int slot = 0; slot < inventory.getSlots() && !(remainingStack = inventory.insertItem(slot, remainingStack, false)).m_41619_(); ++slot) {
            }
            return remainingStack;
        }
    }
}

