/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.blockentity;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.ribs.scguns.block.PoweredMechanicalPressBlock;
import top.ribs.scguns.client.screen.PoweredMechanicalPressMenu;
import top.ribs.scguns.client.screen.PoweredMechanicalPressRecipe;
import top.ribs.scguns.init.ModBlockEntities;
import top.ribs.scguns.item.MoldItem;

public class PoweredMechanicalPressBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            PoweredMechanicalPressBlockEntity.this.m_6596_();
            assert (PoweredMechanicalPressBlockEntity.this.f_58857_ != null);
            if (!PoweredMechanicalPressBlockEntity.this.f_58857_.m_5776_()) {
                PoweredMechanicalPressBlockEntity.this.f_58857_.m_7260_(PoweredMechanicalPressBlockEntity.this.m_58899_(), PoweredMechanicalPressBlockEntity.this.m_58900_(), PoweredMechanicalPressBlockEntity.this.m_58900_(), 3);
                if ((PoweredMechanicalPressBlockEntity.this.isInputSlot(slot) || PoweredMechanicalPressBlockEntity.this.isMoldSlot(slot)) && !PoweredMechanicalPressBlockEntity.this.isRecipeValid()) {
                    PoweredMechanicalPressBlockEntity.this.resetProgress();
                }
            }
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            ItemStack moldStack;
            if (stack.m_41720_() instanceof MoldItem && ((moldStack = PoweredMechanicalPressBlockEntity.this.itemHandler.getStackInSlot(3)).m_41619_() || moldStack.m_41763_() && moldStack.m_41773_() < moldStack.m_41776_())) {
                return super.insertItem(3, stack, simulate);
            }
            return super.insertItem(slot, stack, simulate);
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final ContainerData data;
    private int progress = 0;
    private int maxProgress = 100;
    private final EnergyStorage energyStorage = new EnergyStorage(16000){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int received = super.receiveEnergy(maxReceive, simulate);
            if (!simulate && received > 0) {
                PoweredMechanicalPressBlockEntity.this.m_6596_();
                PoweredMechanicalPressBlockEntity.this.sync();
            }
            return received;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int extracted = super.extractEnergy(maxExtract, simulate);
            if (!simulate && extracted > 0) {
                PoweredMechanicalPressBlockEntity.this.m_6596_();
                PoweredMechanicalPressBlockEntity.this.sync();
            }
            return extracted;
        }
    };
    private final LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);
    public static final int FIRST_INPUT_SLOT = 0;
    public static final int LAST_INPUT_SLOT = 2;
    public static final int MOLD_SLOT = 3;
    public static final int OUTPUT_SLOT = 4;
    private float pressPosition = 0.0f;
    private final float pressSpeed = 0.04f;
    private boolean movingDown = true;

    private boolean isInputSlot(int slot) {
        return slot >= 0 && slot <= 2;
    }

    private boolean isMoldSlot(int slot) {
        return slot == 3;
    }

    public PoweredMechanicalPressBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.POWERED_MECHANICAL_PRESS.get(), pos, state);
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> PoweredMechanicalPressBlockEntity.this.progress;
                    case 1 -> PoweredMechanicalPressBlockEntity.this.maxProgress;
                    case 2 -> PoweredMechanicalPressBlockEntity.this.energyStorage.getEnergyStored();
                    case 3 -> PoweredMechanicalPressBlockEntity.this.energyStorage.getMaxEnergyStored();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        PoweredMechanicalPressBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        PoweredMechanicalPressBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int m_6499_() {
                return 4;
            }
        };
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.powered_mechanical_press");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new PoweredMechanicalPressMenu(id, inv, this, this.data);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            if (side == Direction.DOWN) {
                return LazyOptional.of(() -> new OutputItemHandler(this.itemHandler)).cast();
            }
            return LazyOptional.of(() -> new TopItemHandler(this.itemHandler)).cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("powered_mechanical_press.progress", this.progress);
        tag.m_128365_("Energy", this.energyStorage.serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.progress = tag.m_128451_("powered_mechanical_press.progress");
        this.energyStorage.deserializeNBT(tag.m_128423_("Energy"));
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PoweredMechanicalPressBlockEntity blockEntity) {
        boolean wasLit = (Boolean)state.m_61143_((Property)PoweredMechanicalPressBlock.LIT);
        boolean isLit = false;
        if (!level.f_46443_) {
            boolean hasValidRecipe = blockEntity.hasRecipe();
            boolean canOutput = blockEntity.canOutput();
            if (hasValidRecipe && blockEntity.hasEnoughEnergy(50) && canOutput) {
                isLit = true;
                ++blockEntity.progress;
                blockEntity.consumeEnergy(50);
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    blockEntity.craftItem();
                    blockEntity.resetProgress();
                }
            } else if (blockEntity.progress > 0) {
                blockEntity.resetProgress();
            }
            if (wasLit != isLit) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)PoweredMechanicalPressBlock.LIT, (Comparable)Boolean.valueOf(isLit)), 3);
            }
        }
        if (((Boolean)state.m_61143_((Property)PoweredMechanicalPressBlock.LIT)).booleanValue()) {
            blockEntity.updatePressPosition();
        }
    }

    private boolean canOutput() {
        ItemStack outputStack = this.itemHandler.getStackInSlot(4);
        SimpleContainer inventory = new SimpleContainer(4);
        for (int i = 0; i <= 2; ++i) {
            inventory.m_6836_(i - 0, this.itemHandler.getStackInSlot(i));
        }
        inventory.m_6836_(3, this.itemHandler.getStackInSlot(3));
        Optional match = this.f_58857_.m_7465_().m_44015_((RecipeType)PoweredMechanicalPressRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
        if (match.isPresent()) {
            ItemStack resultItem = ((PoweredMechanicalPressRecipe)match.get()).m_8043_(this.f_58857_.m_9598_());
            if (outputStack.m_41619_() || outputStack.m_41720_() == resultItem.m_41720_() && outputStack.m_41613_() + resultItem.m_41613_() <= outputStack.m_41741_()) {
                return true;
            }
        }
        return false;
    }

    public float getPressPosition(float partialTicks, boolean isLit) {
        if (isLit) {
            return this.pressPosition + (this.movingDown ? -0.04f : 0.04f) * partialTicks;
        }
        return this.pressPosition;
    }

    public void updatePressPosition() {
        if (this.movingDown) {
            this.pressPosition -= 0.04f;
            float endPosition = -0.25f;
            if (this.pressPosition <= endPosition) {
                this.movingDown = false;
                if (this.f_58857_ != null) {
                    this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12471_, SoundSource.BLOCKS, 0.05f, 0.6f);
                }
            }
        } else {
            this.pressPosition += 0.04f;
            float startPosition = 0.0f;
            if (this.pressPosition >= startPosition) {
                this.movingDown = true;
            }
        }
    }

    private boolean hasRecipe() {
        SimpleContainer inventory = new SimpleContainer(4);
        for (int i = 0; i <= 2; ++i) {
            inventory.m_6836_(i - 0, this.itemHandler.getStackInSlot(i));
        }
        inventory.m_6836_(3, this.itemHandler.getStackInSlot(3));
        assert (this.f_58857_ != null);
        Optional match = this.f_58857_.m_7465_().m_44015_((RecipeType)PoweredMechanicalPressRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
        if (match.isPresent()) {
            PoweredMechanicalPressRecipe recipe = (PoweredMechanicalPressRecipe)match.get();
            this.maxProgress = recipe.getProcessingTime();
            return true;
        }
        return false;
    }

    private void craftItem() {
        SimpleContainer inventory = new SimpleContainer(4);
        for (int i = 0; i <= 2; ++i) {
            inventory.m_6836_(i - 0, this.itemHandler.getStackInSlot(i));
        }
        inventory.m_6836_(3, this.itemHandler.getStackInSlot(3));
        assert (this.f_58857_ != null);
        Optional match = this.f_58857_.m_7465_().m_44015_((RecipeType)PoweredMechanicalPressRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
        if (match.isPresent()) {
            PoweredMechanicalPressRecipe recipe = (PoweredMechanicalPressRecipe)match.get();
            ItemStack resultItem = recipe.m_8043_(this.f_58857_.m_9598_());
            ItemStack outputStack = this.itemHandler.getStackInSlot(4);
            if (outputStack.m_41619_() || outputStack.m_41720_() == resultItem.m_41720_() && outputStack.m_41613_() + resultItem.m_41613_() <= outputStack.m_41741_()) {
                ItemStack moldStack;
                block1: for (Ingredient ingredient : recipe.m_7527_()) {
                    for (int i = 0; i <= 2; ++i) {
                        if (!ingredient.test(this.itemHandler.getStackInSlot(i))) continue;
                        this.itemHandler.extractItem(i, 1, false);
                        continue block1;
                    }
                }
                if (recipe.requiresMold() && !(moldStack = this.itemHandler.getStackInSlot(3)).m_41619_() && moldStack.m_41763_()) {
                    if (moldStack.m_220157_(1, this.f_58857_.f_46441_, null)) {
                        moldStack.m_41774_(1);
                    }
                    this.itemHandler.setStackInSlot(3, moldStack);
                }
                if (outputStack.m_41619_()) {
                    this.itemHandler.setStackInSlot(4, resultItem.m_41777_());
                } else {
                    outputStack.m_41769_(resultItem.m_41613_());
                }
            }
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private boolean isRecipeValid() {
        SimpleContainer inventory = new SimpleContainer(4);
        for (int i = 0; i <= 2; ++i) {
            inventory.m_6836_(i - 0, this.itemHandler.getStackInSlot(i));
        }
        inventory.m_6836_(3, this.itemHandler.getStackInSlot(3));
        Optional<PoweredMechanicalPressRecipe> currentRecipe = this.getCurrentRecipe();
        if (currentRecipe.isPresent()) {
            PoweredMechanicalPressRecipe recipe = currentRecipe.get();
            assert (this.f_58857_ != null);
            return recipe.matches(inventory, this.f_58857_);
        }
        return false;
    }

    private Optional<PoweredMechanicalPressRecipe> getCurrentRecipe() {
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        RecipeManager recipeManager = this.f_58857_.m_7465_();
        SimpleContainer inventory = new SimpleContainer(4);
        for (int i = 0; i <= 2; ++i) {
            inventory.m_6836_(i - 0, this.itemHandler.getStackInSlot(i));
        }
        inventory.m_6836_(3, this.itemHandler.getStackInSlot(3));
        return recipeManager.m_44013_((RecipeType)PoweredMechanicalPressRecipe.Type.INSTANCE).stream().filter(recipe -> recipe.matches(inventory, this.f_58857_)).findFirst();
    }

    private boolean hasEnoughEnergy(int amount) {
        return this.energyStorage.getEnergyStored() >= amount;
    }

    public void consumeEnergy(int amount) {
        this.energyStorage.extractEnergy(amount, false);
        this.m_6596_();
        this.sync();
    }

    public void addEnergy(int amount) {
        this.energyStorage.receiveEnergy(amount, false);
        this.m_6596_();
        this.sync();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.f_58857_ != null);
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    private void sync() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    private class TopItemHandler
    implements IItemHandlerModifiable {
        private final ItemStackHandler itemHandler;

        public TopItemHandler(ItemStackHandler itemHandler) {
            this.itemHandler = itemHandler;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            this.itemHandler.setStackInSlot(slot, stack);
        }

        public int getSlots() {
            return this.itemHandler.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.itemHandler.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (this.isItemValid(slot, stack)) {
                return this.itemHandler.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return this.itemHandler.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (stack.m_41720_() instanceof MoldItem) {
                return slot == 3 && (this.itemHandler.getStackInSlot(3).m_41619_() || this.itemHandler.getStackInSlot(3).m_41763_() && this.itemHandler.getStackInSlot(3).m_41773_() < this.itemHandler.getStackInSlot(3).m_41776_());
            }
            return slot >= 0 && slot <= 2;
        }
    }

    private static class OutputItemHandler
    implements IItemHandlerModifiable {
        private final ItemStackHandler itemHandler;

        public OutputItemHandler(ItemStackHandler itemHandler) {
            this.itemHandler = itemHandler;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            this.itemHandler.setStackInSlot(slot, stack);
        }

        public int getSlots() {
            return this.itemHandler.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.itemHandler.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 4) {
                return this.itemHandler.extractItem(slot, amount, simulate);
            }
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return this.itemHandler.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return false;
        }
    }

    private static class InputItemHandler
    implements IItemHandlerModifiable {
        private final ItemStackHandler itemHandler;

        public InputItemHandler(ItemStackHandler itemHandler) {
            this.itemHandler = itemHandler;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            this.itemHandler.setStackInSlot(slot, stack);
        }

        public int getSlots() {
            return this.itemHandler.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.itemHandler.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot == 0 || slot == 2 || stack.m_41720_() instanceof MoldItem) {
                return this.itemHandler.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot >= 0 && slot <= 2) {
                return this.itemHandler.extractItem(slot, amount, simulate);
            }
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return this.itemHandler.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return slot == 0 || slot == 2 || stack.m_41720_() instanceof MoldItem;
        }
    }
}

