/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.screen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class GunBenchRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final NonNullList<Ingredient> recipeItems;
    private final Ingredient blueprint;

    public GunBenchRecipe(ResourceLocation id, ItemStack output, NonNullList<Ingredient> recipeItems, Ingredient blueprint) {
        this.id = id;
        this.output = output;
        this.recipeItems = recipeItems;
        this.blueprint = blueprint;
    }

    public boolean m_5818_(Container container, Level level) {
        ItemStack blueprintStack = container.m_8020_(11);
        if (!this.blueprint.test(blueprintStack)) {
            return false;
        }
        for (int i = 0; i < this.recipeItems.size(); ++i) {
            ItemStack stackInSlot = container.m_8020_(i);
            Ingredient requiredIngredient = (Ingredient)this.recipeItems.get(i);
            if (!requiredIngredient.m_43947_() && !requiredIngredient.test(stackInSlot)) {
                return false;
            }
            if (!requiredIngredient.m_43947_() || stackInSlot.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(@NotNull RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public Ingredient getBlueprint() {
        return this.blueprint;
    }

    private ItemStack getResultItem() {
        return this.output;
    }

    public static class Serializer
    implements RecipeSerializer<GunBenchRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("scguns", "gun_bench");

        public GunBenchRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            JsonObject ingredients = GsonHelper.m_13930_((JsonObject)json, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)10, (Object)Ingredient.f_43901_);
            if (ingredients.has("gun_top_internal_1")) {
                inputs.set(0, (Object)Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)ingredients, (String)"gun_top_internal_1")));
            }
            if (ingredients.has("gun_top_internal_2")) {
                inputs.set(1, (Object)Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)ingredients, (String)"gun_top_internal_2")));
            }
            if (ingredients.has("gun_top_barrel_1")) {
                inputs.set(2, (Object)Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)ingredients, (String)"gun_top_barrel_1")));
            }
            if (ingredients.has("gun_top_barrel_2")) {
                inputs.set(3, (Object)Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)ingredients, (String)"gun_top_barrel_2")));
            }
            if (ingredients.has("gun_internal_1")) {
                inputs.set(4, (Object)Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)ingredients, (String)"gun_internal_1")));
            }
            if (ingredients.has("gun_internal_2")) {
                inputs.set(5, (Object)Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)ingredients, (String)"gun_internal_2")));
            }
            if (ingredients.has("gun_barrel_1")) {
                inputs.set(6, (Object)Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)ingredients, (String)"gun_barrel_1")));
            }
            if (ingredients.has("gun_barrel_2")) {
                inputs.set(7, (Object)Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)ingredients, (String)"gun_barrel_2")));
            }
            if (ingredients.has("gun_grip")) {
                inputs.set(8, (Object)Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)ingredients, (String)"gun_grip")));
            }
            if (ingredients.has("gun_magazine")) {
                inputs.set(9, (Object)Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)ingredients, (String)"gun_magazine")));
            }
            Ingredient blueprint = Ingredient.f_43901_;
            if (ingredients.has("blueprint")) {
                blueprint = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)ingredients, (String)"blueprint"));
            }
            return new GunBenchRecipe(recipeId, output, (NonNullList<Ingredient>)inputs, blueprint);
        }

        public GunBenchRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            NonNullList inputs = NonNullList.m_122780_((int)10, (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            Ingredient blueprint = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack output = buffer.m_130267_();
            return new GunBenchRecipe(recipeId, output, (NonNullList<Ingredient>)inputs, blueprint);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, GunBenchRecipe recipe) {
            for (Ingredient ing : recipe.m_7527_()) {
                ing.m_43923_(buffer);
            }
            recipe.blueprint.m_43923_(buffer);
            buffer.writeItemStack(recipe.getResultItem(), false);
        }
    }

    public static class Type
    implements RecipeType<GunBenchRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "gun_bench";
    }
}

