/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.util;

public class GunRotationHandler {
    private static final float ROTATION_LERP_SPEED = 0.6f;
    private float currentCylinderRotation = 0.0f;
    private float currentMagazineRotation = 0.0f;
    private float targetCylinderRotation = 0.0f;
    private float targetMagazineRotation = 0.0f;

    public void updateRotations(float partialTick) {
        this.currentCylinderRotation = this.lerpRotation(this.currentCylinderRotation, this.targetCylinderRotation, 0.6f);
        this.currentMagazineRotation = this.lerpRotation(this.currentMagazineRotation, this.targetMagazineRotation, 0.6f);
        this.currentCylinderRotation = this.normalizeRotation(this.currentCylinderRotation);
        this.currentMagazineRotation = this.normalizeRotation(this.currentMagazineRotation);
    }

    public void incrementCylinderRotation(float amount) {
        this.targetCylinderRotation = this.normalizeRotation(this.targetCylinderRotation + amount);
    }

    public void incrementMagazineRotation(float amount) {
        this.targetMagazineRotation = this.normalizeRotation(this.targetMagazineRotation + amount);
    }

    public float getCurrentCylinderRotation() {
        return this.currentCylinderRotation;
    }

    public float getCurrentMagazineRotation() {
        return this.currentMagazineRotation;
    }

    private float lerpRotation(float current, float target, float speed) {
        float shortestDistance = ((target - current) % 360.0f + 540.0f) % 360.0f - 180.0f;
        return current + shortestDistance * speed;
    }

    private float normalizeRotation(float rotation) {
        if ((rotation %= 360.0f) < 0.0f) {
            rotation += 360.0f;
        }
        return rotation;
    }
}

