/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common.exosuit;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.ribs.scguns.common.exosuit.ExoSuitData;
import top.ribs.scguns.common.exosuit.ExoSuitPowerManager;
import top.ribs.scguns.common.exosuit.ExoSuitUpgrade;
import top.ribs.scguns.common.exosuit.ExoSuitUpgradeManager;
import top.ribs.scguns.item.animated.ExoSuitItem;
import top.ribs.scguns.item.exosuit.EnergyUpgradeItem;
import top.ribs.scguns.item.exosuit.NightVisionModuleItem;
import top.ribs.scguns.item.exosuit.RebreatherModuleItem;

public class ExoSuitEffectsHandler {
    private static final UUID HELMET_ARMOR_UUID = UUID.fromString("f47ac10b-58cc-4372-a567-0e02b2c3d479");
    private static final UUID HELMET_TOUGHNESS_UUID = UUID.fromString("6ba7b810-9dad-11d1-80b4-00c04fd430c8");
    private static final UUID HELMET_KNOCKBACK_UUID = UUID.fromString("6ba7b811-9dad-11d1-80b4-00c04fd430c8");
    private static final UUID HELMET_SPEED_UUID = UUID.fromString("6ba7b812-9dad-11d1-80b4-00c04fd430c8");
    private static final UUID CHEST_ARMOR_UUID = UUID.fromString("550e8400-e29b-41d4-a716-446655440000");
    private static final UUID CHEST_TOUGHNESS_UUID = UUID.fromString("550e8400-e29b-41d4-a716-446655440001");
    private static final UUID CHEST_KNOCKBACK_UUID = UUID.fromString("550e8400-e29b-41d4-a716-446655440002");
    private static final UUID CHEST_SPEED_UUID = UUID.fromString("550e8400-e29b-41d4-a716-446655440003");
    private static final UUID LEGS_ARMOR_UUID = UUID.fromString("6ba7b814-9dad-11d1-80b4-00c04fd430c8");
    private static final UUID LEGS_TOUGHNESS_UUID = UUID.fromString("6ba7b815-9dad-11d1-80b4-00c04fd430c8");
    private static final UUID LEGS_KNOCKBACK_UUID = UUID.fromString("6ba7b816-9dad-11d1-80b4-00c04fd430c8");
    private static final UUID LEGS_SPEED_UUID = UUID.fromString("6ba7b817-9dad-11d1-80b4-00c04fd430c8");
    private static final UUID BOOTS_ARMOR_UUID = UUID.fromString("6ba7b818-9dad-11d1-80b4-00c04fd430c8");
    private static final UUID BOOTS_TOUGHNESS_UUID = UUID.fromString("6ba7b819-9dad-11d1-80b4-00c04fd430c8");
    private static final UUID BOOTS_KNOCKBACK_UUID = UUID.fromString("6ba7b81a-9dad-11d1-80b4-00c04fd430c8");
    private static final UUID BOOTS_SPEED_UUID = UUID.fromString("6ba7b81b-9dad-11d1-80b4-00c04fd430c8");
    private static final String EXOSUIT_TAG = "ExoSuitEffect";
    private static final Map<UUID, Map<String, Boolean>> activeExoSuitEffects = new HashMap<UUID, Map<String, Boolean>>();

    public static void applyExoSuitEffects(Player player) {
        ExoSuitEffectsHandler.removeExoSuitEffects(player);
        Map playerEffects = activeExoSuitEffects.computeIfAbsent(player.m_20148_(), k -> new HashMap());
        playerEffects.clear();
        for (ItemStack armorStack : player.m_6168_()) {
            Item item = armorStack.m_41720_();
            if (!(item instanceof ExoSuitItem)) continue;
            ExoSuitItem exosuit = (ExoSuitItem)item;
            ExoSuitEffectsHandler.applyArmorPieceEffects(player, armorStack, exosuit, playerEffects);
        }
    }

    public static ExoSuitUpgrade.Effects getTotalEffects(Player player) {
        ExoSuitUpgrade.Effects totalEffects = new ExoSuitUpgrade.Effects();
        for (ItemStack armorStack : player.m_6168_()) {
            if (!(armorStack.m_41720_() instanceof ExoSuitItem)) continue;
            ExoSuitUpgrade.Effects pieceEffects = ExoSuitEffectsHandler.calculateTotalEffects(player, armorStack);
            totalEffects.armorBonus += pieceEffects.getArmorBonus();
            totalEffects.armorToughness += pieceEffects.getArmorToughness();
            totalEffects.knockbackResistance += pieceEffects.getKnockbackResistance();
            totalEffects.speedModifier += pieceEffects.getSpeedModifier();
            totalEffects.jumpBoost += pieceEffects.getJumpBoost();
            totalEffects.fallDamageReduction += pieceEffects.getFallDamageReduction();
            totalEffects.nightVision = totalEffects.nightVision || pieceEffects.hasNightVision();
            boolean bl = totalEffects.flight = totalEffects.flight || pieceEffects.hasFlight();
            if (pieceEffects.getFlightSpeed() > totalEffects.flightSpeed) {
                totalEffects.flightSpeed = pieceEffects.getFlightSpeed();
            }
            totalEffects.recoilAngleReduction += pieceEffects.getRecoilAngleReduction();
            totalEffects.recoilKickReduction += pieceEffects.getRecoilKickReduction();
            totalEffects.spreadReduction += pieceEffects.getSpreadReduction();
        }
        return totalEffects;
    }

    public static void removeExoSuitEffects(Player player) {
        ExoSuitEffectsHandler.removeAttributeModifier(player, Attributes.f_22284_, HELMET_ARMOR_UUID);
        ExoSuitEffectsHandler.removeAttributeModifier(player, Attributes.f_22285_, HELMET_TOUGHNESS_UUID);
        ExoSuitEffectsHandler.removeAttributeModifier(player, Attributes.f_22278_, HELMET_KNOCKBACK_UUID);
        ExoSuitEffectsHandler.removeAttributeModifier(player, Attributes.f_22279_, HELMET_SPEED_UUID);
        ExoSuitEffectsHandler.removeAttributeModifier(player, Attributes.f_22284_, CHEST_ARMOR_UUID);
        ExoSuitEffectsHandler.removeAttributeModifier(player, Attributes.f_22285_, CHEST_TOUGHNESS_UUID);
        ExoSuitEffectsHandler.removeAttributeModifier(player, Attributes.f_22278_, CHEST_KNOCKBACK_UUID);
        ExoSuitEffectsHandler.removeAttributeModifier(player, Attributes.f_22279_, CHEST_SPEED_UUID);
        ExoSuitEffectsHandler.removeAttributeModifier(player, Attributes.f_22284_, LEGS_ARMOR_UUID);
        ExoSuitEffectsHandler.removeAttributeModifier(player, Attributes.f_22285_, LEGS_TOUGHNESS_UUID);
        ExoSuitEffectsHandler.removeAttributeModifier(player, Attributes.f_22278_, LEGS_KNOCKBACK_UUID);
        ExoSuitEffectsHandler.removeAttributeModifier(player, Attributes.f_22279_, LEGS_SPEED_UUID);
        ExoSuitEffectsHandler.removeAttributeModifier(player, Attributes.f_22284_, BOOTS_ARMOR_UUID);
        ExoSuitEffectsHandler.removeAttributeModifier(player, Attributes.f_22285_, BOOTS_TOUGHNESS_UUID);
        ExoSuitEffectsHandler.removeAttributeModifier(player, Attributes.f_22278_, BOOTS_KNOCKBACK_UUID);
        ExoSuitEffectsHandler.removeAttributeModifier(player, Attributes.f_22279_, BOOTS_SPEED_UUID);
        Map<String, Boolean> playerEffects = activeExoSuitEffects.get(player.m_20148_());
        if (playerEffects == null) {
            return;
        }
        if (Boolean.TRUE.equals(playerEffects.get("nightVision"))) {
            ExoSuitEffectsHandler.removeExoSuitEffect(player, MobEffects.f_19611_);
        }
        if (Boolean.TRUE.equals(playerEffects.get("jumpBoost"))) {
            ExoSuitEffectsHandler.removeExoSuitEffect(player, MobEffects.f_19603_);
        }
        if (Boolean.TRUE.equals(playerEffects.get("waterBreathing"))) {
            ExoSuitEffectsHandler.removeExoSuitEffect(player, MobEffects.f_19608_);
        }
        playerEffects.clear();
    }

    private static void removeExoSuitEffect(Player player, MobEffect effect) {
        int maxDuration;
        if (!player.m_21023_(effect)) {
            return;
        }
        MobEffectInstance currentEffect = player.m_21124_(effect);
        if (currentEffect == null) {
            return;
        }
        int n = maxDuration = effect == MobEffects.f_19611_ ? 400 : 200;
        if (currentEffect.m_19557_() <= maxDuration && !currentEffect.m_19571_() && !currentEffect.m_19572_() && currentEffect.m_19564_() <= 1) {
            player.m_21195_(effect);
        }
    }

    private static void applyArmorPieceEffects(Player player, ItemStack armorStack, ExoSuitItem exosuit, Map<String, Boolean> playerEffects) {
        ExoSuitUpgrade.Effects totalEffects = ExoSuitEffectsHandler.calculateTotalEffects(player, armorStack);
        UUID[] uuids = ExoSuitEffectsHandler.getUUIDsForArmorType(exosuit.m_266204_());
        UUID armorUUID = uuids[0];
        UUID toughnessUUID = uuids[1];
        UUID knockbackUUID = uuids[2];
        UUID speedUUID = uuids[3];
        if (totalEffects.getArmorBonus() > 0.0f) {
            ExoSuitEffectsHandler.addAttributeModifier(player, Attributes.f_22284_, armorUUID, "ExoSuit Armor Bonus", totalEffects.getArmorBonus(), AttributeModifier.Operation.ADDITION);
        }
        if (totalEffects.getArmorToughness() > 0.0f) {
            ExoSuitEffectsHandler.addAttributeModifier(player, Attributes.f_22285_, toughnessUUID, "ExoSuit Armor Toughness", totalEffects.getArmorToughness(), AttributeModifier.Operation.ADDITION);
        }
        if (totalEffects.getKnockbackResistance() > 0.0f) {
            ExoSuitEffectsHandler.addAttributeModifier(player, Attributes.f_22278_, knockbackUUID, "ExoSuit Knockback Resistance", totalEffects.getKnockbackResistance(), AttributeModifier.Operation.ADDITION);
        }
        if (totalEffects.getSpeedModifier() != 0.0f) {
            ExoSuitEffectsHandler.addAttributeModifier(player, Attributes.f_22279_, speedUUID, "ExoSuit Speed Modifier", totalEffects.getSpeedModifier(), AttributeModifier.Operation.MULTIPLY_TOTAL);
        }
        if (totalEffects.hasNightVision() && ExoSuitEffectsHandler.shouldApplyNightVision(player, armorStack)) {
            ExoSuitEffectsHandler.applyExoSuitEffect(player, MobEffects.f_19611_, 400, 0);
            playerEffects.put("nightVision", true);
        }
        if (totalEffects.getJumpBoost() > 0.0f && ExoSuitEffectsHandler.shouldApplyJumpBoost(player, armorStack)) {
            int amplifier = Math.max(0, (int)(totalEffects.getJumpBoost() * 5.0f) - 1);
            ExoSuitEffectsHandler.applyExoSuitEffect(player, MobEffects.f_19603_, 200, amplifier);
            playerEffects.put("jumpBoost", true);
        }
        if (ExoSuitEffectsHandler.shouldApplyWaterBreathing(player, armorStack)) {
            ExoSuitEffectsHandler.applyExoSuitEffect(player, MobEffects.f_19608_, 200, 0);
            playerEffects.put("waterBreathing", true);
        }
    }

    private static void applyExoSuitEffect(Player player, MobEffect effect, int duration, int amplifier) {
        MobEffectInstance currentEffect = player.m_21124_(effect);
        if (currentEffect == null || currentEffect.m_19557_() < 40) {
            player.m_7292_(new MobEffectInstance(effect, duration, amplifier, false, false, false));
        }
    }

    private static boolean shouldApplyNightVision(Player player, ItemStack armorStack) {
        ExoSuitItem exosuit;
        Item item = armorStack.m_41720_();
        if (!(item instanceof ExoSuitItem) || (exosuit = (ExoSuitItem)item).m_266204_() != ArmorItem.Type.HELMET) {
            return false;
        }
        if (!ExoSuitPowerManager.isPowerEnabled(player, "hud")) {
            return false;
        }
        for (int slot = 0; slot < 4; ++slot) {
            ExoSuitUpgrade upgrade;
            ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(armorStack, slot);
            if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null || !upgrade.getType().equals("hud") || !(upgradeItem.m_41720_() instanceof NightVisionModuleItem)) continue;
            return ExoSuitPowerManager.canUpgradeFunction(player, "hud");
        }
        return false;
    }

    private static boolean shouldApplyJumpBoost(Player player, ItemStack armorStack) {
        ExoSuitItem exosuit;
        Item item = armorStack.m_41720_();
        if (!(item instanceof ExoSuitItem) || (exosuit = (ExoSuitItem)item).m_266204_() != ArmorItem.Type.BOOTS) {
            return false;
        }
        if (!ExoSuitPowerManager.isPowerEnabled(player, "mobility")) {
            return false;
        }
        for (int slot = 0; slot < 4; ++slot) {
            ExoSuitUpgrade upgrade;
            ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(armorStack, slot);
            if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null || !upgrade.getType().equals("mobility")) continue;
            return ExoSuitPowerManager.canUpgradeFunction(player, "mobility");
        }
        return false;
    }

    private static boolean shouldApplyWaterBreathing(Player player, ItemStack armorStack) {
        ExoSuitItem exosuit;
        Item item = armorStack.m_41720_();
        if (!(item instanceof ExoSuitItem) || (exosuit = (ExoSuitItem)item).m_266204_() != ArmorItem.Type.HELMET) {
            return false;
        }
        if (!player.m_20069_() && !player.m_5842_()) {
            return false;
        }
        for (int slot = 0; slot < 4; ++slot) {
            ExoSuitUpgrade upgrade;
            ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(armorStack, slot);
            if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null || !upgrade.getType().equals("breathing") || !(upgradeItem.m_41720_() instanceof RebreatherModuleItem)) continue;
            return ExoSuitPowerManager.canUpgradeFunction(player, "breathing");
        }
        return false;
    }

    private static ExoSuitUpgrade.Effects calculateTotalEffects(Player player, ItemStack armorStack) {
        ExoSuitUpgrade.Effects totalEffects = new ExoSuitUpgrade.Effects();
        String slotContext = ExoSuitEffectsHandler.getSlotContextForArmorType(armorStack);
        for (int slot = 0; slot < 4; ++slot) {
            ExoSuitUpgrade upgrade;
            ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(armorStack, slot);
            if (upgradeItem.m_41619_() || (upgrade = ExoSuitEffectsHandler.getUpgradeForSlotContext(upgradeItem, slot, slotContext)) == null) continue;
            ExoSuitUpgrade.Effects effects = upgrade.getEffects();
            if (ExoSuitEffectsHandler.requiresPowerAndEnabled(player, upgrade, upgradeItem)) {
                totalEffects.armorBonus += effects.getArmorBonus();
                totalEffects.armorToughness += effects.getArmorToughness();
                totalEffects.knockbackResistance += effects.getKnockbackResistance();
                totalEffects.speedModifier += effects.getSpeedModifier();
                totalEffects.jumpBoost += effects.getJumpBoost();
                totalEffects.fallDamageReduction += effects.getFallDamageReduction();
                totalEffects.nightVision = totalEffects.nightVision || effects.hasNightVision();
                boolean bl = totalEffects.flight = totalEffects.flight || effects.hasFlight();
                if (!(effects.getFlightSpeed() > totalEffects.flightSpeed)) continue;
                totalEffects.flightSpeed = effects.getFlightSpeed();
                continue;
            }
            if (ExoSuitEffectsHandler.isEnergyUpgrade(upgradeItem)) continue;
            totalEffects.armorBonus += effects.getArmorBonus();
            totalEffects.armorToughness += effects.getArmorToughness();
            totalEffects.knockbackResistance += effects.getKnockbackResistance();
            totalEffects.speedModifier += effects.getSpeedModifier();
            totalEffects.jumpBoost += effects.getJumpBoost();
            totalEffects.fallDamageReduction += effects.getFallDamageReduction();
            boolean bl = totalEffects.flight = totalEffects.flight || effects.hasFlight();
            if (!(effects.getFlightSpeed() > totalEffects.flightSpeed)) continue;
            totalEffects.flightSpeed = effects.getFlightSpeed();
        }
        return totalEffects;
    }

    private static ExoSuitUpgrade getUpgradeForSlotContext(ItemStack upgradeItem, int slotIndex, String armorContext) {
        String slotType = ExoSuitEffectsHandler.determineSlotType(armorContext, slotIndex);
        ExoSuitUpgrade slotSpecific = ExoSuitUpgradeManager.getUpgradeForItemInSlot(upgradeItem, slotType);
        if (slotSpecific != null) {
            return slotSpecific;
        }
        return ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem);
    }

    private static String determineSlotType(String armorContext, int slotIndex) {
        return switch (armorContext) {
            case "helmet" -> {
                switch (slotIndex) {
                    case 0: {
                        yield "plating";
                    }
                    case 1: {
                        yield "hud";
                    }
                    case 2: {
                        yield "breathing";
                    }
                }
                yield "unknown";
            }
            case "chestplate" -> {
                switch (slotIndex) {
                    case 0: {
                        yield "plating";
                    }
                    case 1: {
                        yield "pauldron";
                    }
                    case 2: {
                        yield "power_core";
                    }
                    case 3: {
                        yield "utility";
                    }
                }
                yield "unknown";
            }
            case "leggings" -> {
                switch (slotIndex) {
                    case 0: {
                        yield "plating";
                    }
                    case 1: {
                        yield "knee_guard";
                    }
                    case 2: {
                        yield "utility";
                    }
                }
                yield "unknown";
            }
            case "boots" -> {
                switch (slotIndex) {
                    case 0: {
                        yield "plating";
                    }
                    case 1: {
                        yield "mobility";
                    }
                }
                yield "unknown";
            }
            default -> "unknown";
        };
    }

    private static String getSlotContextForArmorType(ItemStack armorStack) {
        Item item = armorStack.m_41720_();
        if (item instanceof ExoSuitItem) {
            ExoSuitItem exosuit = (ExoSuitItem)item;
            return switch (exosuit.m_266204_()) {
                default -> throw new IncompatibleClassChangeError();
                case ArmorItem.Type.HELMET -> "helmet";
                case ArmorItem.Type.CHESTPLATE -> "chestplate";
                case ArmorItem.Type.LEGGINGS -> "leggings";
                case ArmorItem.Type.BOOTS -> "boots";
            };
        }
        return "unknown";
    }

    private static boolean requiresPowerAndEnabled(Player player, ExoSuitUpgrade upgrade, ItemStack upgradeItem) {
        String upgradeType = upgrade.getType();
        Item item = upgradeItem.m_41720_();
        if (item instanceof EnergyUpgradeItem) {
            EnergyUpgradeItem energyUpgrade = (EnergyUpgradeItem)item;
            boolean powerEnabled = ExoSuitPowerManager.isPowerEnabled(player, upgradeType);
            if (!powerEnabled) {
                return false;
            }
            if (!energyUpgrade.canFunctionWithoutPower()) {
                return ExoSuitPowerManager.canUpgradeFunction(player, upgradeType);
            }
            return true;
        }
        return true;
    }

    private static boolean isEnergyUpgrade(ItemStack upgradeItem) {
        return upgradeItem.m_41720_() instanceof EnergyUpgradeItem;
    }

    private static UUID[] getUUIDsForArmorType(ArmorItem.Type type) {
        UUID[] uUIDArray;
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case HELMET: {
                UUID[] uUIDArray2 = new UUID[4];
                uUIDArray2[0] = HELMET_ARMOR_UUID;
                uUIDArray2[1] = HELMET_TOUGHNESS_UUID;
                uUIDArray2[2] = HELMET_KNOCKBACK_UUID;
                uUIDArray = uUIDArray2;
                uUIDArray2[3] = HELMET_SPEED_UUID;
                break;
            }
            case CHESTPLATE: {
                UUID[] uUIDArray3 = new UUID[4];
                uUIDArray3[0] = CHEST_ARMOR_UUID;
                uUIDArray3[1] = CHEST_TOUGHNESS_UUID;
                uUIDArray3[2] = CHEST_KNOCKBACK_UUID;
                uUIDArray = uUIDArray3;
                uUIDArray3[3] = CHEST_SPEED_UUID;
                break;
            }
            case LEGGINGS: {
                UUID[] uUIDArray4 = new UUID[4];
                uUIDArray4[0] = LEGS_ARMOR_UUID;
                uUIDArray4[1] = LEGS_TOUGHNESS_UUID;
                uUIDArray4[2] = LEGS_KNOCKBACK_UUID;
                uUIDArray = uUIDArray4;
                uUIDArray4[3] = LEGS_SPEED_UUID;
                break;
            }
            case BOOTS: {
                UUID[] uUIDArray5 = new UUID[4];
                uUIDArray5[0] = BOOTS_ARMOR_UUID;
                uUIDArray5[1] = BOOTS_TOUGHNESS_UUID;
                uUIDArray5[2] = BOOTS_KNOCKBACK_UUID;
                uUIDArray = uUIDArray5;
                uUIDArray5[3] = BOOTS_SPEED_UUID;
            }
        }
        return uUIDArray;
    }

    private static void addAttributeModifier(Player player, Attribute attribute, UUID uuid, String name, double value, AttributeModifier.Operation operation) {
        AttributeInstance instance = player.m_21051_(attribute);
        if (instance != null && instance.m_22111_(uuid) == null) {
            AttributeModifier modifier = new AttributeModifier(uuid, name, value, operation);
            instance.m_22125_(modifier);
        }
    }

    private static void removeAttributeModifier(Player player, Attribute attribute, UUID uuid) {
        AttributeInstance instance = player.m_21051_(attribute);
        if (instance != null) {
            instance.m_22120_(uuid);
        }
    }

    public static void cleanupPlayerData(UUID playerId) {
        activeExoSuitEffects.remove(playerId);
    }
}

