/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common.exosuit;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.DispenserMenu;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.common.exosuit.ExoSuitData;
import top.ribs.scguns.common.exosuit.ExoSuitUpgrade;
import top.ribs.scguns.common.exosuit.ExoSuitUpgradeManager;
import top.ribs.scguns.item.animated.ExoSuitItem;

public class ExoSuitPouchHandler {
    private static final String POUCH_DATA_TAG = "PouchData";

    public static void openPouchInventory(ServerPlayer player) {
        ItemStack chestplate = ExoSuitPouchHandler.getEquippedChestplate((Player)player);
        if (chestplate.m_41619_()) {
            return;
        }
        ItemStack pouchUpgrade = ExoSuitPouchHandler.findPouchUpgrade(chestplate);
        if (pouchUpgrade.m_41619_()) {
            return;
        }
        ExoSuitUpgrade upgrade = ExoSuitUpgradeManager.getUpgradeForItem(pouchUpgrade);
        if (upgrade == null) {
            return;
        }
        int storageSize = upgrade.getDisplay().getStorageSize();
        String containerType = upgrade.getDisplay().getContainerType();
        String pouchId = ExoSuitPouchHandler.getPouchId(pouchUpgrade);
        ExoSuitPouchHandler.openPouchContainer(player, chestplate, pouchId, storageSize, containerType, upgrade);
    }

    private static void openPouchContainer(ServerPlayer player, final ItemStack chestplate, final String pouchId, final int storageSize, final String containerType, final ExoSuitUpgrade upgrade) {
        final ItemStackHandler pouchInventory = ExoSuitPouchHandler.getOrCreatePouchInventory(chestplate, pouchId, storageSize);
        MenuProvider menuProvider = new MenuProvider(){

            @NotNull
            public Component m_5446_() {
                return Component.m_237110_((String)"container.scguns.pouch", (Object[])new Object[]{upgrade.getDisplay().getModel()});
            }

            public AbstractContainerMenu m_7208_(int id, @NotNull Inventory playerInventory, @NotNull Player player) {
                ItemStackHandlerContainer container = new ItemStackHandlerContainer(pouchInventory, chestplate, pouchId);
                return switch (containerType.toLowerCase()) {
                    case "chest" -> ChestMenu.m_39237_((int)id, (Inventory)playerInventory, (Container)container);
                    case "double_chest" -> ChestMenu.m_39246_((int)id, (Inventory)playerInventory, (Container)container);
                    case "dispenser" -> new DispenserMenu(id, playerInventory, (Container)container);
                    default -> storageSize <= 9 ? new DispenserMenu(id, playerInventory, (Container)container) : (storageSize <= 27 ? ChestMenu.m_39237_((int)id, (Inventory)playerInventory, (Container)container) : ChestMenu.m_39246_((int)id, (Inventory)playerInventory, (Container)container));
                };
            }
        };
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)menuProvider);
    }

    public static boolean canRemovePouch(ItemStack chestplate, ItemStack pouchUpgrade) {
        if (pouchUpgrade.m_41619_()) {
            return true;
        }
        ExoSuitUpgrade upgrade = ExoSuitUpgradeManager.getUpgradeForItem(pouchUpgrade);
        if (upgrade == null || !upgrade.getType().equals("pouches")) {
            return true;
        }
        String pouchId = ExoSuitPouchHandler.getPouchId(pouchUpgrade);
        CompoundTag pouchData = ExoSuitPouchHandler.getPouchData(chestplate);
        if (!pouchData.m_128441_(pouchId)) {
            return true;
        }
        ItemStackHandler handler = new ItemStackHandler(upgrade.getDisplay().getStorageSize());
        handler.deserializeNBT(pouchData.m_128469_(pouchId));
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    private static ItemStackHandler getOrCreatePouchInventory(final ItemStack chestplate, final String pouchId, int size) {
        CompoundTag pouchData = ExoSuitPouchHandler.getPouchData(chestplate);
        ItemStackHandler handler = new ItemStackHandler(size){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                ExoSuitPouchHandler.savePouchInventory(chestplate, pouchId, this);
            }
        };
        if (pouchData.m_128441_(pouchId)) {
            handler.deserializeNBT(pouchData.m_128469_(pouchId));
        }
        return handler;
    }

    private static void savePouchInventory(ItemStack chestplate, String pouchId, ItemStackHandler handler) {
        CompoundTag pouchData = ExoSuitPouchHandler.getPouchData(chestplate);
        pouchData.m_128365_(pouchId, (Tag)handler.serializeNBT());
        ExoSuitPouchHandler.setPouchData(chestplate, pouchData);
    }

    private static ItemStack findPouchUpgrade(ItemStack chestplate) {
        for (int slot = 0; slot < 4; ++slot) {
            ExoSuitUpgrade upgrade;
            ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(chestplate, slot);
            if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null || !upgrade.getType().equals("pouches")) continue;
            return upgradeItem;
        }
        return ItemStack.f_41583_;
    }

    private static String getPouchId(ItemStack pouchUpgrade) {
        return pouchUpgrade.m_41720_().toString();
    }

    private static ItemStack getEquippedChestplate(Player player) {
        for (ItemStack armorStack : player.m_6168_()) {
            ExoSuitItem exosuit;
            Item item = armorStack.m_41720_();
            if (!(item instanceof ExoSuitItem) || (exosuit = (ExoSuitItem)item).m_266204_() != ArmorItem.Type.CHESTPLATE) continue;
            return armorStack;
        }
        return ItemStack.f_41583_;
    }

    private static CompoundTag getPouchData(ItemStack chestplate) {
        return chestplate.m_41784_().m_128469_(POUCH_DATA_TAG);
    }

    private static void setPouchData(ItemStack chestplate, CompoundTag pouchData) {
        chestplate.m_41784_().m_128365_(POUCH_DATA_TAG, (Tag)pouchData);
    }

    private record ItemStackHandlerContainer(ItemStackHandler handler, ItemStack chestplate, String pouchId) implements Container
    {
        public int m_6643_() {
            return this.handler.getSlots();
        }

        public boolean m_7983_() {
            for (int i = 0; i < this.handler.getSlots(); ++i) {
                if (this.handler.getStackInSlot(i).m_41619_()) continue;
                return false;
            }
            return true;
        }

        @NotNull
        public ItemStack m_8020_(int slot) {
            return this.handler.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack m_7407_(int slot, int count) {
            ItemStack result = this.handler.extractItem(slot, count, false);
            this.m_6596_();
            return result;
        }

        @NotNull
        public ItemStack m_8016_(int slot) {
            ItemStack stack = this.handler.getStackInSlot(slot);
            this.handler.setStackInSlot(slot, ItemStack.f_41583_);
            this.m_6596_();
            return stack;
        }

        public void m_6836_(int slot, ItemStack stack) {
            this.handler.setStackInSlot(slot, stack);
            this.m_6596_();
        }

        public void m_6596_() {
            ExoSuitPouchHandler.savePouchInventory(this.chestplate, this.pouchId, this.handler);
        }

        public boolean m_6542_(Player player) {
            return true;
        }

        public void m_6211_() {
            for (int i = 0; i < this.handler.getSlots(); ++i) {
                this.handler.setStackInSlot(i, ItemStack.f_41583_);
            }
            this.m_6596_();
        }
    }
}

