/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common.exosuit;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.ribs.scguns.common.exosuit.ExoSuitData;
import top.ribs.scguns.common.exosuit.ExoSuitPowerManager;
import top.ribs.scguns.common.exosuit.ExoSuitUpgrade;
import top.ribs.scguns.common.exosuit.ExoSuitUpgradeManager;
import top.ribs.scguns.item.animated.ExoSuitItem;
import top.ribs.scguns.item.exosuit.RebreatherModuleItem;

@Mod.EventBusSubscriber(modid="scguns", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ExoSuitRebreatherHandler {
    private static final int REFRESH_INTERVAL = 160;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().f_46443_) {
            return;
        }
        Player player = event.player;
        if (player.f_19797_ % 20 != 0) {
            return;
        }
        ExoSuitRebreatherHandler.handleRebreatherEnergy(player);
    }

    private static void handleRebreatherEnergy(Player player) {
        RebreatherModuleItem rebreatherModule;
        Item item;
        boolean inWater;
        boolean bl = inWater = player.m_20069_() || player.m_5842_();
        if (!inWater) {
            return;
        }
        if (!ExoSuitRebreatherHandler.hasRebreatherModule(player)) {
            return;
        }
        if (!ExoSuitPowerManager.canConsumeEnergy(player, "breathing", 160)) {
            return;
        }
        if (!ExoSuitPowerManager.canUpgradeFunction(player, "breathing")) {
            return;
        }
        ItemStack helmetUpgrade = ExoSuitRebreatherHandler.findRebreatherModule(player);
        if (!helmetUpgrade.m_41619_() && (item = helmetUpgrade.m_41720_()) instanceof RebreatherModuleItem && !(rebreatherModule = (RebreatherModuleItem)item).canFunctionWithoutPower()) {
            ExoSuitPowerManager.consumeEnergyForUpgrade(player, "breathing", helmetUpgrade);
        }
    }

    private static boolean hasRebreatherModule(Player player) {
        return !ExoSuitRebreatherHandler.findRebreatherModule(player).m_41619_();
    }

    private static ItemStack findRebreatherModule(Player player) {
        for (ItemStack armorStack : player.m_6168_()) {
            ExoSuitItem exosuit;
            Item item = armorStack.m_41720_();
            if (!(item instanceof ExoSuitItem) || (exosuit = (ExoSuitItem)item).m_266204_() != ArmorItem.Type.HELMET) continue;
            for (int slot = 0; slot < 4; ++slot) {
                ExoSuitUpgrade upgrade;
                ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(armorStack, slot);
                if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null || !upgrade.getType().equals("breathing") || !(upgradeItem.m_41720_() instanceof RebreatherModuleItem)) continue;
                return upgradeItem;
            }
        }
        return ItemStack.f_41583_;
    }

    public static void onPlayerLogout(Player player) {
    }
}

