/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.config;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="scguns")
public class AdvancedComposterDropsConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation CONFIG_LOCATION = new ResourceLocation("scguns", "composter/advanced_composter_drops.json");
    private static ComposterLootTable LOOT_TABLE = new ComposterLootTable();

    public static void loadConfig(ResourceManager resourceManager) {
        block12: {
            LOOT_TABLE.clear();
            try {
                Resource resource = resourceManager.m_213713_(CONFIG_LOCATION).orElse(null);
                if (resource != null) {
                    try (InputStreamReader reader = new InputStreamReader(resource.m_215507_(), StandardCharsets.UTF_8);){
                        Gson gson = new Gson();
                        JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                        if (json != null) {
                            if (json.has("min_drops") && json.has("max_drops")) {
                                int minDrops = json.get("min_drops").getAsInt();
                                int maxDrops = json.get("max_drops").getAsInt();
                                LOOT_TABLE.setDropRange(minDrops, maxDrops);
                            }
                            if (json.has("drops")) {
                                JsonArray dropsArray = json.getAsJsonArray("drops");
                                for (JsonElement dropElement : dropsArray) {
                                    DropEntry entry = DropEntry.fromJson(dropElement.getAsJsonObject());
                                    if (entry == null) continue;
                                    LOOT_TABLE.addDrop(entry);
                                }
                            }
                            LOGGER.info("Loaded advanced composter drops config: {} drops configured, total weight: {}", (Object)LOOT_TABLE.getDropCount(), (Object)AdvancedComposterDropsConfig.LOOT_TABLE.totalWeight);
                        }
                        break block12;
                    }
                }
                LOGGER.warn("Advanced composter drops config not found at {}", (Object)CONFIG_LOCATION);
                AdvancedComposterDropsConfig.loadDefaultConfig();
            }
            catch (Exception e) {
                LOGGER.error("Failed to load advanced composter drops config at {}", (Object)CONFIG_LOCATION, (Object)e);
                AdvancedComposterDropsConfig.loadDefaultConfig();
            }
        }
    }

    private static void loadDefaultConfig() {
        LOGGER.info("Loading default composter drops configuration");
        LOOT_TABLE.clear();
        Item bonemeal = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft:bone_meal"));
        if (bonemeal != null) {
            LOOT_TABLE.addDrop(new DropEntry(bonemeal, 100, 1, 3));
        }
        LOOT_TABLE.setDropRange(1, 3);
    }

    public static List<ItemStack> generateDrops(Random random) {
        return LOOT_TABLE.generateDrops(random);
    }

    public static boolean hasDropsConfigured() {
        return !LOOT_TABLE.isEmpty();
    }

    @SubscribeEvent
    public static void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SimplePreparableReloadListener<Void>(){

            protected Void prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
                return null;
            }

            protected void apply(Void object, ResourceManager resourceManager, ProfilerFiller profiler) {
                AdvancedComposterDropsConfig.loadConfig(resourceManager);
            }
        });
    }

    public static class ComposterLootTable {
        private final List<DropEntry> drops = new ArrayList<DropEntry>();
        private int totalWeight = 0;
        private int minDrops = 1;
        private int maxDrops = 3;

        public void addDrop(DropEntry entry) {
            this.drops.add(entry);
            this.totalWeight += entry.weight();
        }

        public void setDropRange(int min, int max) {
            this.minDrops = Math.max(1, min);
            this.maxDrops = Math.max(this.minDrops, max);
        }

        public List<ItemStack> generateDrops(Random random) {
            if (this.drops.isEmpty()) {
                LOGGER.warn("No drops configured for advanced composter!");
                return Collections.emptyList();
            }
            int dropCount = this.minDrops;
            if (this.maxDrops > this.minDrops) {
                dropCount = this.minDrops + random.nextInt(this.maxDrops - this.minDrops + 1);
            }
            ArrayList<ItemStack> result = new ArrayList<ItemStack>();
            for (int i = 0; i < dropCount; ++i) {
                DropEntry entry = this.selectWeightedDrop(random);
                if (entry == null) continue;
                result.add(entry.createStack(random));
            }
            return result;
        }

        @Nullable
        private DropEntry selectWeightedDrop(Random random) {
            if (this.drops.isEmpty() || this.totalWeight <= 0) {
                return null;
            }
            int randomWeight = random.nextInt(this.totalWeight);
            int currentWeight = 0;
            for (DropEntry entry : this.drops) {
                if (randomWeight >= (currentWeight += entry.weight())) continue;
                return entry;
            }
            return this.drops.get(this.drops.size() - 1);
        }

        public void clear() {
            this.drops.clear();
            this.totalWeight = 0;
            this.minDrops = 1;
            this.maxDrops = 3;
        }

        public boolean isEmpty() {
            return this.drops.isEmpty();
        }

        public int getDropCount() {
            return this.drops.size();
        }
    }

    public record DropEntry(Item item, int weight, int minCount, int maxCount) {
        public ItemStack createStack(Random random) {
            int count = this.minCount;
            if (this.maxCount > this.minCount) {
                count = this.minCount + random.nextInt(this.maxCount - this.minCount + 1);
            }
            return new ItemStack((ItemLike)this.item, count);
        }

        public static DropEntry fromJson(JsonObject json) {
            String itemId = json.get("item").getAsString();
            int weight = json.has("weight") ? json.get("weight").getAsInt() : 1;
            int minCount = json.has("min_count") ? json.get("min_count").getAsInt() : 1;
            int maxCount = json.has("max_count") ? json.get("max_count").getAsInt() : minCount;
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId));
            if (item == null) {
                LOGGER.warn("Unknown item in composter drops: {}", (Object)itemId);
                return null;
            }
            return new DropEntry(item, weight, minCount, maxCount);
        }
    }
}

