/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="scguns")
public class EnemyProjectileConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, Double> DAMAGE_VALUES = new HashMap<String, Double>();
    private static final double DEFAULT_DAMAGE = 4.0;
    private static final ResourceLocation CONFIG_LOCATION = new ResourceLocation("scguns", "entity/enemy_projectile_damage.json");

    public static void loadConfig(ResourceManager resourceManager) {
        block10: {
            DAMAGE_VALUES.clear();
            try {
                Resource resource = resourceManager.m_213713_(CONFIG_LOCATION).orElse(null);
                if (resource != null) {
                    try (InputStreamReader reader = new InputStreamReader(resource.m_215507_(), StandardCharsets.UTF_8);){
                        Gson gson = new Gson();
                        JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                        JsonObject damageValues = json.getAsJsonObject("damage_values");
                        if (damageValues != null) {
                            for (Map.Entry entry : damageValues.entrySet()) {
                                DAMAGE_VALUES.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsDouble());
                            }
                        }
                        break block10;
                    }
                }
                LOGGER.warn("Enemy Projectile damage config not found at {}", (Object)CONFIG_LOCATION);
            }
            catch (Exception e) {
                LOGGER.error("Failed to load Enemy Projectile damage config at {}", (Object)CONFIG_LOCATION, (Object)e);
            }
        }
    }

    public static double getDamageForEntity(EntityType<?> entityType) {
        String entityId = EntityType.m_20613_(entityType).toString();
        return DAMAGE_VALUES.getOrDefault(entityId, 4.0);
    }

    @SubscribeEvent
    public static void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SimplePreparableReloadListener<Void>(){

            protected Void prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
                return null;
            }

            protected void apply(Void object, ResourceManager resourceManager, ProfilerFiller profiler) {
                EnemyProjectileConfig.loadConfig(resourceManager);
            }
        });
    }
}

