/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.effect;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.ribs.scguns.effect.CustomExplosion;
import top.ribs.scguns.entity.projectile.ProjectileEntity;

public class PlasmaExplosion
extends CustomExplosion {
    private static final float OWNER_DAMAGE_REDUCTION = 0.1f;
    private final RandomSource random = RandomSource.m_216327_();
    private final Entity source;

    public PlasmaExplosion(Level pLevel, @Nullable Entity pSource, double pToBlowX, double pToBlowY, double pToBlowZ, float pRadius, boolean pFire, CustomExplosion.CustomBlockInteraction customBlockInteraction) {
        super(pLevel, pSource, pToBlowX, pToBlowY, pToBlowZ, pRadius, pFire, customBlockInteraction);
        this.source = pSource;
    }

    @Override
    public void m_46061_() {
        super.m_46061_();
        if (this.f_46012_.f_46443_) {
            for (int i = 0; i < 100; ++i) {
                double offsetX = (this.random.m_188500_() - 0.5) * 2.0;
                double offsetY = (this.random.m_188500_() - 0.5) * 2.0;
                double offsetZ = (this.random.m_188500_() - 0.5) * 2.0;
                this.f_46012_.m_7106_((ParticleOptions)ParticleTypes.f_175830_, this.f_46013_ + offsetX, this.f_46014_ + offsetY, this.f_46015_ + offsetZ, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void m_46075_(boolean pSpawnParticles) {
        if (!this.f_46012_.f_46443_) {
            DamageSource damageSource = this.m_46077_();
            LivingEntity shooter = null;
            Entity entity = this.source;
            if (entity instanceof ProjectileEntity) {
                ProjectileEntity projectile = (ProjectileEntity)entity;
                shooter = projectile.getShooter();
            }
            for (LivingEntity entity2 : this.f_46012_.m_45976_(LivingEntity.class, this.getBoundingBox().m_82400_((double)this.f_46017_ * 2.0))) {
                double deltaZ;
                double exposure;
                double distance;
                if (!entity2.m_6084_() || (distance = Math.sqrt(entity2.m_20275_(this.f_46013_, this.f_46014_, this.f_46015_)) / (double)this.f_46017_) > 1.0 || (exposure = (double)Explosion.m_46064_((Vec3)this.getPosition(), (Entity)entity2)) <= 0.0) continue;
                float damage = (float)((1.0 - distance) * exposure * (double)this.f_46017_ * 2.0);
                if (entity2 == shooter) {
                    damage *= 0.1f;
                }
                entity2.m_6469_(damageSource, damage);
                double deltaX = entity2.m_20185_() - this.f_46013_;
                double distance2D = Math.sqrt(deltaX * deltaX + (deltaZ = entity2.m_20189_() - this.f_46015_) * deltaZ);
                if (!(distance2D > 0.0)) continue;
                entity2.m_20256_(entity2.m_20184_().m_82520_(deltaX / distance2D * exposure * 0.3, exposure * 0.3, deltaZ / distance2D * exposure * 0.3));
            }
        }
        super.m_46075_(pSpawnParticles);
    }

    @NotNull
    public Vec3 getPosition() {
        return new Vec3(this.f_46013_, this.f_46014_, this.f_46015_);
    }

    private AABB getBoundingBox() {
        return new AABB(this.f_46013_ - (double)this.f_46017_, this.f_46014_ - (double)this.f_46017_, this.f_46015_ - (double)this.f_46017_, this.f_46013_ + (double)this.f_46017_, this.f_46014_ + (double)this.f_46017_, this.f_46015_ + (double)this.f_46017_);
    }
}

