/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.ai;

import com.mrcrayfish.framework.api.network.LevelLocation;
import com.mrcrayfish.framework.network.message.IMessage;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.Config;
import top.ribs.scguns.client.util.PropertyHelper;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.common.ProjectileManager;
import top.ribs.scguns.entity.projectile.ProjectileEntity;
import top.ribs.scguns.init.ModBlocks;
import top.ribs.scguns.init.ModEffects;
import top.ribs.scguns.interfaces.IProjectileFactory;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.S2CMessageBulletTrail;
import top.ribs.scguns.network.message.S2CMessageEntityCasingEject;
import top.ribs.scguns.network.message.S2CMessageEntityMuzzleFlash;
import top.ribs.scguns.util.GunEnchantmentHelper;
import top.ribs.scguns.util.GunModifierHelper;

public class AIGunEvent {
    public static Vec3 getLeadingDirection(LivingEntity shooter, LivingEntity target, double projectileSpeed) {
        Vec3 targetPos = target.m_20182_().m_82520_(0.0, (double)target.m_20192_() * 0.8, 0.0);
        Vec3 targetVelocity = target.m_20184_();
        Vec3 shooterPos = shooter.m_20182_().m_82520_(0.0, (double)shooter.m_20192_(), 0.0);
        Vec3 toTarget = targetPos.m_82546_(shooterPos);
        double distance = toTarget.m_82553_();
        double timeToHit = distance / projectileSpeed;
        Vec3 predictedPos = targetPos.m_82549_(targetVelocity.m_82490_(timeToHit));
        return predictedPos.m_82546_(shooterPos).m_82541_();
    }

    public static void performGunAttack(Mob shooter, LivingEntity target, ItemStack itemStack, Gun modifiedGun, float accuracyModifier) {
        ResourceLocation particleLocation;
        Level level = shooter.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        int count = modifiedGun.getProjectile().getProjectileAmount();
        Gun.Projectile projectileProps = modifiedGun.getProjectile();
        ProjectileEntity[] spawnedProjectiles = new ProjectileEntity[count];
        if (shooter.m_21023_((MobEffect)ModEffects.DEAFENED.get()) || shooter.m_21023_((MobEffect)ModEffects.BLINDED.get())) {
            accuracyModifier *= 0.5f;
        }
        if (target.m_21023_((MobEffect)ModEffects.DEAFENED.get())) {
            accuracyModifier *= 0.75f;
        }
        float difficultyDamageMultiplier = AIGunEvent.getDifficultyDamageMultiplier(level.m_46791_());
        float configDamageMultiplier = ((Double)Config.COMMON.gameplay.mobGunDamageMultiplier.get()).floatValue();
        float finalDamageMultiplier = difficultyDamageMultiplier * configDamageMultiplier;
        for (int i = 0; i < count; ++i) {
            IProjectileFactory factory = ProjectileManager.getInstance().getFactory(BuiltInRegistries.f_257033_.m_7981_((Object)Objects.requireNonNull(projectileProps.getItem())));
            ProjectileEntity projectileEntity = factory.create(level, (LivingEntity)shooter, itemStack, (GunItem)itemStack.m_41720_(), modifiedGun);
            projectileEntity.setWeapon(itemStack);
            float originalDamage = Gun.getAdditionalDamage(itemStack);
            float scaledDamage = originalDamage * finalDamageMultiplier;
            projectileEntity.setAdditionalDamage(scaledDamage);
            projectileEntity.getPersistentData().m_128350_("AIDamageScale", finalDamageMultiplier);
            Vec3 dir = AIGunEvent.getDirection((LivingEntity)shooter, target, itemStack, (GunItem)itemStack.m_41720_(), modifiedGun, accuracyModifier);
            double speedModifier = GunEnchantmentHelper.getProjectileSpeedModifier(itemStack);
            double speed = GunModifierHelper.getModifiedProjectileSpeed(itemStack, projectileEntity.getProjectile().getSpeed() * speedModifier);
            projectileEntity.m_20334_(dir.f_82479_ * speed, dir.f_82480_ * speed, dir.f_82481_ * speed);
            projectileEntity.updateHeading();
            double posX = shooter.f_19790_ + (shooter.m_20185_() - shooter.f_19790_) / 2.0;
            double posY = shooter.f_19791_ + (shooter.m_20186_() - shooter.f_19791_) / 2.0 + (double)shooter.m_20192_();
            double posZ = shooter.f_19792_ + (shooter.m_20189_() - shooter.f_19792_) / 2.0;
            projectileEntity.m_6034_(posX, posY, posZ);
            level.m_7967_((Entity)projectileEntity);
            spawnedProjectiles[i] = projectileEntity;
            projectileEntity.m_8119_();
        }
        int radius = (int)shooter.m_20185_();
        int y1 = (int)(shooter.m_20186_() + 1.0);
        int z1 = (int)shooter.m_20189_();
        double r = (Double)Config.COMMON.network.projectileTrackingRange.get();
        ParticleOptions data = GunEnchantmentHelper.getParticle(itemStack);
        boolean isVisible = !modifiedGun.getProjectile().shouldHideTrail();
        S2CMessageBulletTrail messageBulletTrail = new S2CMessageBulletTrail(spawnedProjectiles, projectileProps, shooter.m_19879_(), data, isVisible);
        PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)level, (double)radius, (double)y1, (double)z1, (double)r), (IMessage)messageBulletTrail);
        if (modifiedGun.getDisplay().getFlash() != null) {
            float randomValue = level.f_46441_.m_188501_();
            Vec3 weaponOrigin = PropertyHelper.getModelOrigin(itemStack, PropertyHelper.GUN_DEFAULT_ORIGIN);
            Vec3 flashPosition = PropertyHelper.getMuzzleFlashPosition(itemStack, modifiedGun).m_82546_(weaponOrigin);
            S2CMessageEntityMuzzleFlash flashMessage = new S2CMessageEntityMuzzleFlash(shooter.m_19879_(), randomValue, flashPosition, false);
            PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)level, (double)radius, (double)y1, (double)z1, (double)r), (IMessage)flashMessage);
        }
        if (((Boolean)Config.COMMON.gameplay.spawnCasings.get()).booleanValue() && modifiedGun.getProjectile().ejectsCasing() && !modifiedGun.getProjectile().ejectDuringReload() && (particleLocation = modifiedGun.getProjectile().getCasingParticle()) != null) {
            S2CMessageEntityCasingEject casingMessage = new S2CMessageEntityCasingEject(shooter.m_19879_(), particleLocation);
            PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)level, (double)radius, (double)y1, (double)z1, (double)r), (IMessage)casingMessage);
        }
        if (((Boolean)Config.CLIENT.display.fireLights.get()).booleanValue()) {
            BlockState targetState = shooter.m_9236_().m_8055_(BlockPos.m_274446_((Position)shooter.m_146892_()));
            if (targetState.m_60734_() == ModBlocks.TEMPORARY_LIGHT.get()) {
                if (AIGunEvent.getValue((LevelAccessor)shooter.m_9236_(), BlockPos.m_274446_((Position)shooter.m_146892_()), "Delay") < 1.0) {
                    AIGunEvent.updateDelayAndNotify((LevelAccessor)shooter.m_9236_(), BlockPos.m_274446_((Position)shooter.m_146892_()), targetState);
                }
            } else if (targetState.m_60734_() == Blocks.f_50016_ || targetState.m_60734_() == Blocks.f_50627_) {
                BlockState dynamicLightState = ((Block)ModBlocks.TEMPORARY_LIGHT.get()).m_49966_();
                shooter.m_9236_().m_7731_(BlockPos.m_274446_((Position)shooter.m_146892_()), dynamicLightState, 3);
            }
        }
    }

    private static float getDifficultyDamageMultiplier(Difficulty difficulty) {
        return switch (difficulty) {
            default -> throw new IncompatibleClassChangeError();
            case Difficulty.PEACEFUL -> 0.05f;
            case Difficulty.EASY -> 0.4f;
            case Difficulty.NORMAL -> 0.55f;
            case Difficulty.HARD -> 0.7f;
        };
    }

    public static Vec3 getDirection(LivingEntity shooter, LivingEntity target, ItemStack weapon, GunItem item, Gun modifiedGun, float accuracyModifier) {
        float gunSpread = GunModifierHelper.getModifiedSpread(weapon, modifiedGun.getProjectile().getSpread());
        float baseAimError = 5.0f;
        float difficultyMod = switch (shooter.m_9236_().m_46791_()) {
            default -> throw new IncompatibleClassChangeError();
            case Difficulty.PEACEFUL -> 3.0f;
            case Difficulty.EASY -> 2.0f;
            case Difficulty.NORMAL -> 1.5f;
            case Difficulty.HARD -> 1.0f;
        };
        float aimError = baseAimError * difficultyMod / accuracyModifier;
        aimError = Math.min(aimError, 25.0f);
        Vec3 baseDirection = AIGunEvent.getVectorFromRotation(shooter.m_5686_(1.0f), shooter.m_5675_(1.0f));
        if (shooter.m_9236_().m_46791_() == Difficulty.HARD && target.m_20184_().m_82556_() > 0.01) {
            double speed = modifiedGun.getProjectile().getSpeed();
            Vec3 leadDir = AIGunEvent.getLeadingDirection(shooter, target, speed);
            baseDirection = baseDirection.m_82549_(leadDir.m_82490_(0.3)).m_82541_();
        }
        float aimErrorRad = aimError * ((float)Math.PI / 180);
        float theta1 = shooter.m_9236_().f_46441_.m_188501_() * 2.0f * (float)Math.PI;
        float r1 = Mth.m_14116_((float)shooter.m_9236_().f_46441_.m_188501_()) * (float)Math.tan(aimErrorRad);
        Vec3 vecUpwards = AIGunEvent.getVectorFromRotation(shooter.m_5686_(1.0f) + 90.0f, shooter.m_5675_(1.0f));
        Vec3 vecSideways = baseDirection.m_82537_(vecUpwards);
        float a1 = Mth.m_14089_((float)theta1) * r1;
        float a2 = Mth.m_14031_((float)theta1) * r1;
        Vec3 aimedDirection = baseDirection.m_82549_(vecSideways.m_82490_((double)a1)).m_82549_(vecUpwards.m_82490_((double)a2)).m_82541_();
        if (gunSpread == 0.0f) {
            return aimedDirection;
        }
        gunSpread = Math.min(gunSpread, 170.0f) * 0.5f * ((float)Math.PI / 180);
        Vec3 spreadUpwards = AIGunEvent.getVectorFromRotation(shooter.m_5686_(1.0f) + 90.0f, shooter.m_5675_(1.0f));
        Vec3 spreadSideways = aimedDirection.m_82537_(spreadUpwards);
        float theta2 = shooter.m_9236_().f_46441_.m_188501_() * 2.0f * (float)Math.PI;
        float r2 = Mth.m_14116_((float)shooter.m_9236_().f_46441_.m_188501_()) * (float)Math.tan(gunSpread);
        float b1 = Mth.m_14089_((float)theta2) * r2;
        float b2 = Mth.m_14031_((float)theta2) * r2;
        return aimedDirection.m_82549_(spreadSideways.m_82490_((double)b1)).m_82549_(spreadUpwards.m_82490_((double)b2)).m_82541_();
    }

    private static Vec3 getVectorFromRotation(float pitch, float yaw) {
        float f = Mth.m_14089_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = Mth.m_14031_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -Mth.m_14089_((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = Mth.m_14031_((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    private static void updateDelayAndNotify(LevelAccessor world, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity != null) {
            blockEntity.getPersistentData().m_128347_("Delay", 1.0);
        }
        if (world instanceof Level) {
            ((Level)world).m_7260_(pos, state, state, 3);
        }
    }

    public static double getValue(LevelAccessor world, BlockPos pos, String tag) {
        BlockEntity blockEntity = world.m_7702_(pos);
        return blockEntity != null ? blockEntity.getPersistentData().m_128459_(tag) : -1.0;
    }
}

