/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.ai;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.event.BatPoopEvent;

public class BatGlowberryGoal
extends Goal {
    private final Bat bat;
    private final double speedModifier;
    private final int searchRange;
    @Nullable
    private BlockPos targetBerry;
    private int eatCooldown = 0;
    private boolean shouldRoostAfterEating = false;

    public BatGlowberryGoal(Bat bat, double speedModifier, int searchRange) {
        this.bat = bat;
        this.speedModifier = speedModifier;
        this.searchRange = searchRange;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (BatPoopEvent.isWellFed(this.bat)) {
            return false;
        }
        if (this.eatCooldown > 0) {
            --this.eatCooldown;
            return false;
        }
        if (this.bat.m_27452_() && !this.shouldRoostAfterEating) {
            return false;
        }
        if (this.shouldRoostAfterEating) {
            return true;
        }
        if (this.bat.m_217043_().m_188503_(20) != 0) {
            return false;
        }
        this.targetBerry = this.findNearbyGlowBerry();
        return this.targetBerry != null;
    }

    public boolean m_8045_() {
        if (this.shouldRoostAfterEating) {
            return !this.bat.m_27452_();
        }
        return this.targetBerry != null && !BatPoopEvent.isWellFed(this.bat) && this.bat.m_9236_().m_8055_(this.targetBerry).m_60734_() instanceof CaveVines && CaveVines.m_152951_((BlockState)this.bat.m_9236_().m_8055_(this.targetBerry));
    }

    public void m_8056_() {
        if (this.bat.m_27452_()) {
            this.bat.m_27456_(false);
        }
    }

    public void m_8037_() {
        if (this.shouldRoostAfterEating) {
            this.tryToRoost();
            return;
        }
        if (this.targetBerry == null) {
            return;
        }
        Vec3 targetVec = Vec3.m_82512_((Vec3i)this.targetBerry);
        double distance = this.bat.m_20182_().m_82554_(targetVec);
        if (distance < 1.5) {
            this.eatBerry();
        } else {
            this.moveTowardsBerry(targetVec);
        }
    }

    public void m_8041_() {
        this.targetBerry = null;
        this.shouldRoostAfterEating = false;
    }

    private void eatBerry() {
        Level level = this.bat.m_9236_();
        assert (this.targetBerry != null);
        BlockState state = level.m_8055_(this.targetBerry);
        if (CaveVines.m_152951_((BlockState)state)) {
            BlockState newState = (BlockState)state.m_61124_((Property)CaveVines.f_152949_, (Comparable)Boolean.valueOf(false));
            level.m_7731_(this.targetBerry, newState, 3);
            level.m_5594_(null, this.bat.m_20183_(), SoundEvents.f_144088_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            BatPoopEvent.setWellFed(this.bat);
            this.shouldRoostAfterEating = true;
            this.eatCooldown = 1200;
            this.targetBerry = null;
        }
    }

    private void tryToRoost() {
        BlockPos batPos = this.bat.m_20183_();
        BlockPos abovePos = batPos.m_7494_();
        if (this.bat.m_9236_().m_8055_(abovePos).m_60796_((BlockGetter)this.bat.m_9236_(), abovePos)) {
            this.bat.m_27456_(true);
            this.shouldRoostAfterEating = false;
            return;
        }
        BlockPos roostSpot = this.findNearbyRoostingSpot();
        if (roostSpot != null) {
            this.moveTowardsPosition(Vec3.m_82512_((Vec3i)roostSpot));
        }
    }

    private void moveTowardsBerry(Vec3 target) {
        Vec3 batPos = this.bat.m_20182_();
        Vec3 direction = target.m_82546_(batPos).m_82541_().m_82490_(this.speedModifier);
        Vec3 currentMotion = this.bat.m_20184_();
        Vec3 newMotion = currentMotion.m_82520_((direction.f_82479_ - currentMotion.f_82479_) * 0.1, (direction.f_82480_ - currentMotion.f_82480_) * 0.1, (direction.f_82481_ - currentMotion.f_82481_) * 0.1);
        this.bat.m_20256_(newMotion);
        float yaw = (float)(Math.atan2(newMotion.f_82481_, newMotion.f_82479_) * 57.29577951308232) - 90.0f;
        this.bat.m_146922_(yaw);
    }

    private void moveTowardsPosition(Vec3 target) {
        this.moveTowardsBerry(target);
    }

    @Nullable
    private BlockPos findNearbyGlowBerry() {
        BlockPos batPos = this.bat.m_20183_();
        for (int x = -this.searchRange; x <= this.searchRange; ++x) {
            for (int y = -this.searchRange; y <= this.searchRange; ++y) {
                for (int z = -this.searchRange; z <= this.searchRange; ++z) {
                    BlockPos checkPos = batPos.m_7918_(x, y, z);
                    BlockState state = this.bat.m_9236_().m_8055_(checkPos);
                    if (!(state.m_60734_() instanceof CaveVines) || !CaveVines.m_152951_((BlockState)state)) continue;
                    return checkPos;
                }
            }
        }
        return null;
    }

    @Nullable
    private BlockPos findNearbyRoostingSpot() {
        BlockPos batPos = this.bat.m_20183_();
        for (int x = -5; x <= 5; ++x) {
            for (int y = -3; y <= 5; ++y) {
                for (int z = -5; z <= 5; ++z) {
                    BlockPos checkPos = batPos.m_7918_(x, y, z);
                    BlockPos abovePos = checkPos.m_7494_();
                    if (!this.bat.m_9236_().m_8055_(abovePos).m_60796_((BlockGetter)this.bat.m_9236_(), abovePos) || !this.bat.m_9236_().m_8055_(checkPos).m_60795_()) continue;
                    return checkPos;
                }
            }
        }
        return null;
    }
}

