/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Locale;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;
import software.bernie.geckolib.animatable.GeoItem;
import top.ribs.scguns.entity.client.CogMinionModel;
import top.ribs.scguns.entity.client.ModModelLayers;
import top.ribs.scguns.entity.monster.CogMinionEntity;

public class CogMinionRenderer
extends MobRenderer<CogMinionEntity, CogMinionModel<CogMinionEntity>> {
    public CogMinionRenderer(EntityRendererProvider.Context pContext) {
        super(pContext, new CogMinionModel(pContext.m_174023_(ModModelLayers.COG_MINION_LAYER)), 0.5f);
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, pContext.m_234598_()));
        this.m_115326_(new CogMinionHelmetLayer(this, pContext.m_174027_(), pContext.m_234598_()));
    }

    public ResourceLocation getTextureLocation(CogMinionEntity pEntity) {
        return new ResourceLocation("scguns", "textures/entity/cog_minion.png");
    }

    public void render(CogMinionEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        pMatrixStack.m_85836_();
        pMatrixStack.m_85841_(1.0f, 1.0f, 1.0f);
        super.m_7392_((Mob)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        pMatrixStack.m_85849_();
    }

    private static class CogMinionHelmetLayer
    extends RenderLayer<CogMinionEntity, CogMinionModel<CogMinionEntity>> {
        private final ItemInHandRenderer itemInHandRenderer;
        private final HumanoidModel<CogMinionEntity> helmetModel;
        private final HumanoidModel<CogMinionEntity> geoArmorProxy;

        public CogMinionHelmetLayer(MobRenderer<CogMinionEntity, CogMinionModel<CogMinionEntity>> renderer, EntityModelSet modelSet, ItemInHandRenderer itemInHandRenderer) {
            super(renderer);
            this.itemInHandRenderer = itemInHandRenderer;
            this.helmetModel = new HumanoidModel(modelSet.m_171103_(ModelLayers.f_171164_));
            this.geoArmorProxy = new HumanoidModel(modelSet.m_171103_(ModelLayers.f_171164_));
        }

        public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, CogMinionEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            ItemStack helmetStack = entity.m_6844_(EquipmentSlot.HEAD);
            if (helmetStack.m_41619_()) {
                return;
            }
            Item item = helmetStack.m_41720_();
            if (item instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                if (item instanceof GeoItem) {
                    this.renderGeoHelmet(poseStack, buffer, packedLight, entity, helmetStack, armorItem, partialTicks);
                } else {
                    poseStack.m_85836_();
                    ((CogMinionModel)this.m_117386_()).head.m_104299_(poseStack);
                    this.renderVanillaHelmet(poseStack, buffer, packedLight, entity, helmetStack, armorItem);
                    poseStack.m_85849_();
                }
            } else if (item instanceof BlockItem) {
                poseStack.m_85836_();
                ((CogMinionModel)this.m_117386_()).head.m_104299_(poseStack);
                poseStack.m_85841_(0.625f, -0.625f, -0.625f);
                poseStack.m_85837_(0.0, -0.5, 0.0);
                this.itemInHandRenderer.m_269530_((LivingEntity)entity, helmetStack, ItemDisplayContext.HEAD, false, poseStack, buffer, packedLight);
                poseStack.m_85849_();
            }
        }

        private void renderGeoHelmet(PoseStack poseStack, MultiBufferSource buffer, int packedLight, CogMinionEntity entity, ItemStack helmetStack, ArmorItem armorItem, float partialTicks) {
            this.copyHeadTransform(((CogMinionModel)this.m_117386_()).head, this.geoArmorProxy.f_102808_);
            this.geoArmorProxy.f_102808_.f_104201_ -= 17.0f;
            this.geoArmorProxy.f_102808_.f_104207_ = true;
            this.geoArmorProxy.f_102810_.f_104207_ = false;
            this.geoArmorProxy.f_102811_.f_104207_ = false;
            this.geoArmorProxy.f_102812_.f_104207_ = false;
            this.geoArmorProxy.f_102813_.f_104207_ = false;
            this.geoArmorProxy.f_102814_.f_104207_ = false;
            this.geoArmorProxy.f_102809_.f_104207_ = false;
            HumanoidModel<?> armorModel = this.getArmorModel(entity, helmetStack, EquipmentSlot.HEAD, this.geoArmorProxy);
            if (armorModel != null) {
                poseStack.m_85836_();
                float scale = 1.4f;
                poseStack.m_85841_(scale, scale, scale);
                armorModel.m_7695_(poseStack, buffer.m_6299_(RenderType.m_110431_((ResourceLocation)this.getArmorTexture(helmetStack))), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                poseStack.m_85849_();
            }
        }

        private void copyHeadTransform(ModelPart source, ModelPart target) {
            target.f_104200_ = source.f_104200_;
            target.f_104201_ = source.f_104201_;
            target.f_104202_ = source.f_104202_;
            target.f_104203_ = source.f_104203_;
            target.f_104204_ = source.f_104204_;
            target.f_104205_ = source.f_104205_;
            target.f_233553_ = source.f_233553_;
            target.f_233554_ = source.f_233554_;
            target.f_233555_ = source.f_233555_;
        }

        private HumanoidModel<?> getArmorModel(CogMinionEntity entity, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> defaultModel) {
            return (HumanoidModel)ForgeHooksClient.getArmorModel((LivingEntity)entity, (ItemStack)stack, (EquipmentSlot)slot, defaultModel);
        }

        private void renderVanillaHelmet(PoseStack poseStack, MultiBufferSource buffer, int packedLight, CogMinionEntity entity, ItemStack helmetStack, ArmorItem armorItem) {
            poseStack.m_85841_(1.1f, 1.0f, 1.1f);
            poseStack.m_85837_(0.0, -0.09, 0.0);
            this.helmetModel.f_102808_.f_104203_ = 0.0f;
            this.helmetModel.f_102808_.f_104204_ = 0.0f;
            this.helmetModel.f_102808_.f_104205_ = 0.0f;
            this.helmetModel.f_102810_.f_104207_ = false;
            this.helmetModel.f_102811_.f_104207_ = false;
            this.helmetModel.f_102812_.f_104207_ = false;
            this.helmetModel.f_102813_.f_104207_ = false;
            this.helmetModel.f_102814_.f_104207_ = false;
            this.helmetModel.f_102809_.f_104207_ = false;
            this.helmetModel.f_102808_.f_104207_ = true;
            ResourceLocation texture = this.getArmorTexture(helmetStack);
            RenderType renderType = RenderType.m_110431_((ResourceLocation)texture);
            VertexConsumer vertexConsumer = buffer.m_6299_(renderType);
            this.helmetModel.f_102808_.m_104306_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            this.helmetModel.f_102810_.f_104207_ = true;
            this.helmetModel.f_102811_.f_104207_ = true;
            this.helmetModel.f_102812_.f_104207_ = true;
            this.helmetModel.f_102813_.f_104207_ = true;
            this.helmetModel.f_102814_.f_104207_ = true;
        }

        private ResourceLocation getArmorTexture(ItemStack stack) {
            ArmorItem item = (ArmorItem)stack.m_41720_();
            String texture = item.m_40401_().m_6082_();
            String domain = "minecraft";
            int idx = texture.indexOf(58);
            if (idx != -1) {
                domain = texture.substring(0, idx);
                texture = texture.substring(idx + 1);
            }
            String s1 = String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_%d.png", domain, texture, 1);
            return new ResourceLocation(s1);
        }
    }
}

