/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import top.ribs.scguns.entity.monster.DissidentEntity;

public class DissidentModel<T extends Entity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart seal_2;
    private final ModelPart seal_1;
    private final ModelPart head;
    private final ModelPart jaw;
    private final ModelPart tongue_1;
    private final ModelPart tongue_2;
    private final ModelPart tongue_3;
    private final ModelPart back_right_leg;
    private final ModelPart back_left_leg;
    private final ModelPart front_right_leg;
    private final ModelPart front_left_leg;
    private final PartPose bodyDefault;
    private final PartPose headDefault;
    private final PartPose jawDefault;
    private final PartPose tongue1Default;
    private final PartPose tongue2Default;
    private final PartPose tongue3Default;
    private final PartPose frontRightLegDefault;
    private final PartPose frontLeftLegDefault;
    private final PartPose backRightLegDefault;
    private final PartPose backLeftLegDefault;
    private float attackStartTime = -1.0f;
    private int lastAttackTimeout = 0;
    private static final float ATTACK_DURATION = 12.0f;

    public DissidentModel(ModelPart root) {
        this.root = root;
        this.body = root.m_171324_("body");
        this.seal_2 = this.body.m_171324_("seal_2");
        this.seal_1 = this.body.m_171324_("seal_1");
        this.head = root.m_171324_("head");
        this.jaw = this.head.m_171324_("jaw");
        this.tongue_1 = this.jaw.m_171324_("tongue_1");
        this.tongue_2 = this.tongue_1.m_171324_("tongue_2");
        this.tongue_3 = this.tongue_2.m_171324_("tongue_3");
        this.back_right_leg = root.m_171324_("back_right_leg");
        this.back_left_leg = root.m_171324_("back_left_leg");
        this.front_right_leg = root.m_171324_("front_right_leg");
        this.front_left_leg = root.m_171324_("front_left_leg");
        this.bodyDefault = this.body.m_171308_();
        this.headDefault = this.head.m_171308_();
        this.jawDefault = this.jaw.m_171308_();
        this.tongue1Default = this.tongue_1.m_171308_();
        this.tongue2Default = this.tongue_2.m_171308_();
        this.tongue3Default = this.tongue_3.m_171308_();
        this.frontRightLegDefault = this.front_right_leg.m_171308_();
        this.frontLeftLegDefault = this.front_left_leg.m_171308_();
        this.backRightLegDefault = this.back_right_leg.m_171308_();
        this.backLeftLegDefault = this.back_left_leg.m_171308_();
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(31, 32).m_171488_(-6.0f, -5.875f, -3.75f, 12.0f, 2.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-7.0f, -3.875f, -6.75f, 14.0f, 13.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(34, 55).m_171488_(-2.0f, -1.875f, -8.75f, 4.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 23).m_171488_(-6.0f, -3.875f, 3.25f, 12.0f, 11.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.625f, (float)1.25f));
        PartDefinition seal_2 = body.m_171599_("seal_2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.125f, 0.45f, -1.5f, 0.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)7.375f, (float)4.925f, (float)-1.25f));
        PartDefinition bone3_r1 = seal_2.m_171599_("bone3_r1", CubeListBuilder.m_171558_().m_171514_(38, 0).m_171488_(-0.5f, -1.5f, -1.5f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.125f, (float)-0.05f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition seal_1 = body.m_171599_("seal_1", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-7.375f, (float)-1.125f, (float)1.75f));
        PartDefinition bone2_r1 = seal_1.m_171599_("bone2_r1", CubeListBuilder.m_171558_().m_171514_(38, 0).m_171488_(-0.5f, -1.5f, -1.5f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.125f, (float)0.0f, (float)0.0f, (float)2.3562f, (float)0.0f, (float)3.1416f));
        PartDefinition bone2_r2 = seal_1.m_171599_("bone2_r2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.125f, -1.0f, -1.5f, 0.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.75f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(22, 45).m_171488_(-4.0f, -5.9667f, -3.9667f, 8.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(33, 25).m_171488_(-3.5f, -0.0667f, -4.0667f, 7.0f, 3.0f, 4.0f, new CubeDeformation(-0.1f)).m_171514_(0, 23).m_171488_(-1.0f, -1.4667f, -4.4667f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.4667f, (float)-5.5333f));
        PartDefinition jaw = head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(39, 14).m_171488_(-4.0f, -0.0357f, -8.9062f, 8.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(4, 0).m_171488_(-3.75f, -2.0357f, -7.699f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(2, 0).m_171488_(-3.75f, -2.0357f, -5.449f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-3.75f, -2.0357f, -3.649f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(3.75f, -2.0357f, -3.649f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(2, 0).m_171488_(3.75f, -2.0357f, -5.449f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(4, 0).m_171488_(3.75f, -2.0357f, -7.699f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)3.1761f, (float)-0.1131f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition tongue_1 = jaw.m_171599_("tongue_1", CubeListBuilder.m_171558_().m_171514_(58, 28).m_171488_(-1.55f, -1.0f, 0.5f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.05f, (float)-0.8916f, (float)-1.8211f));
        PartDefinition tongue_r1_r1 = tongue_1.m_171599_("tongue_r1_r1", CubeListBuilder.m_171558_().m_171514_(38, 0).m_171488_(-2.0f, -1.0f, -4.0f, 4.0f, 2.0f, 8.0f, new CubeDeformation(0.1f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-3.25f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition tongue_2 = tongue_1.m_171599_("tongue_2", CubeListBuilder.m_171558_().m_171514_(55, 25).m_171488_(-1.5f, -1.0f, -4.6414f, 3.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.05f, (float)0.0f, (float)-7.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition tongue_3 = tongue_2.m_171599_("tongue_3", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)-0.025f, (float)-4.475f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition tongue2_r1_r1 = tongue_3.m_171599_("tongue2_r1_r1", CubeListBuilder.m_171558_().m_171514_(54, 0).m_171488_(-1.5f, -0.9459f, -2.6307f, 3.0f, 2.0f, 5.0f, new CubeDeformation(-0.2f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition back_right_leg = partdefinition.m_171599_("back_right_leg", CubeListBuilder.m_171558_().m_171514_(18, 55).m_171488_(-3.175f, 5.25f, -0.75f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.5f, (float)6.75f, (float)10.0f));
        PartDefinition back_right_leg_r1 = back_right_leg.m_171599_("back_right_leg_r1", CubeListBuilder.m_171558_().m_171514_(0, 43).m_171488_(-2.5f, -4.5f, -3.0f, 5.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.75f, (float)1.75f, (float)0.25f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition back_left_leg = partdefinition.m_171599_("back_left_leg", CubeListBuilder.m_171558_().m_171514_(18, 55).m_171480_().m_171488_(-0.825f, 5.25f, -0.75f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)4.5f, (float)6.75f, (float)10.0f));
        PartDefinition back_left_leg_r1 = back_left_leg.m_171599_("back_left_leg_r1", CubeListBuilder.m_171558_().m_171514_(0, 43).m_171480_().m_171488_(-2.5f, -4.5f, -3.0f, 5.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)1.75f, (float)1.75f, (float)0.25f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition front_right_leg = partdefinition.m_171599_("front_right_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)7.75f, (float)-2.5f));
        PartDefinition back_right_leg_r2 = front_right_leg.m_171599_("back_right_leg_r2", CubeListBuilder.m_171558_().m_171514_(58, 58).m_171488_(-2.5f, -3.0f, -2.0f, 5.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-6.25f, (float)1.5021f, (float)-1.6118f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition back_right_leg_r3 = front_right_leg.m_171599_("back_right_leg_r3", CubeListBuilder.m_171558_().m_171514_(46, 45).m_171488_(-7.725f, -6.5f, -2.0f, 4.0f, 13.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)10.25f, (float)-2.35f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition front_left_leg = partdefinition.m_171599_("front_left_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)7.75f, (float)-2.5f));
        PartDefinition back_left_leg_r2 = front_left_leg.m_171599_("back_left_leg_r2", CubeListBuilder.m_171558_().m_171514_(58, 58).m_171480_().m_171488_(-2.5f, -3.0f, -2.0f, 5.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)6.25f, (float)1.5021f, (float)-1.6118f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition back_left_leg_r3 = front_left_leg.m_171599_("back_left_leg_r3", CubeListBuilder.m_171558_().m_171514_(46, 45).m_171480_().m_171488_(3.725f, -6.5f, -2.0f, 4.0f, 13.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)10.25f, (float)-2.35f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_6973_(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!(entity instanceof DissidentEntity)) {
            return;
        }
        DissidentEntity dissident = (DissidentEntity)entity;
        this.body.m_171322_(this.bodyDefault);
        this.head.m_171322_(this.headDefault);
        this.jaw.m_171322_(this.jawDefault);
        this.tongue_1.m_171322_(this.tongue1Default);
        this.tongue_2.m_171322_(this.tongue2Default);
        this.tongue_3.m_171322_(this.tongue3Default);
        this.front_right_leg.m_171322_(this.frontRightLegDefault);
        this.front_left_leg.m_171322_(this.frontLeftLegDefault);
        this.back_right_leg.m_171322_(this.backRightLegDefault);
        this.back_left_leg.m_171322_(this.backLeftLegDefault);
        this.jaw.f_104203_ += 0.3927f;
        this.tongue_2.f_104203_ += 0.3927f;
        this.tongue_3.f_104203_ += 0.3927f;
        boolean isLeaping = dissident.isLeaping();
        boolean isLanding = dissident.isLanding();
        if (isLeaping) {
            this.front_right_leg.f_104203_ += -0.8f;
            this.front_left_leg.f_104203_ += -0.8f;
            this.back_right_leg.f_104203_ += 0.6f;
            this.back_left_leg.f_104203_ += 0.6f;
            this.body.f_104203_ = -0.15f;
            this.head.f_104203_ += -0.3f;
            this.jaw.f_104203_ = 0.6f;
            this.tongue_2.f_104203_ = 0.5f;
            this.tongue_3.f_104203_ = 0.5f;
        } else if (isLanding && dissident.landingAnimationTimeout > 0) {
            float landProgress = (float)dissident.landingAnimationTimeout / 8.0f;
            this.front_right_leg.f_104203_ += -0.4f * landProgress;
            this.front_left_leg.f_104203_ += -0.4f * landProgress;
            this.back_right_leg.f_104203_ += 0.3f * landProgress;
            this.back_left_leg.f_104203_ += 0.3f * landProgress;
            this.body.f_104203_ = -0.1f * landProgress;
            this.body.f_104201_ -= 0.5f * landProgress;
            this.head.f_104203_ += -0.2f * landProgress;
            this.jaw.f_104203_ += 0.15f * landProgress;
            this.tongue_2.f_104203_ += 0.1f * landProgress;
            this.tongue_3.f_104203_ += 0.1f * landProgress;
        } else {
            float walkSpeed = 0.5f;
            float walkAmount = 0.6f;
            float frontLegSwing = Mth.m_14089_((float)(limbSwing * walkSpeed)) * walkAmount * limbSwingAmount;
            this.front_right_leg.f_104203_ += frontLegSwing;
            this.front_left_leg.f_104203_ += -frontLegSwing;
            float backLegSwing = Mth.m_14089_((float)(limbSwing * walkSpeed + (float)Math.PI)) * walkAmount * limbSwingAmount;
            this.back_right_leg.f_104203_ += backLegSwing;
            this.back_left_leg.f_104203_ += -backLegSwing;
            this.body.f_104205_ += Mth.m_14089_((float)(limbSwing * walkSpeed * 0.5f)) * 0.02f * limbSwingAmount;
        }
        if (!isLeaping && !isLanding) {
            float clampedYaw = Mth.m_14036_((float)netHeadYaw, (float)-75.0f, (float)75.0f);
            float clampedPitch = Mth.m_14036_((float)headPitch, (float)-45.0f, (float)45.0f);
            this.head.f_104204_ += clampedYaw * ((float)Math.PI / 180);
            this.head.f_104203_ += clampedPitch * ((float)Math.PI / 180);
        }
        if (dissident.isAttacking() && dissident.attackAnimationTimeout > 0) {
            this.animateAttackSmooth(dissident.attackAnimationTimeout, ageInTicks);
        } else {
            this.attackStartTime = -1.0f;
            this.lastAttackTimeout = 0;
            if (!isLeaping && !isLanding) {
                this.jaw.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.04f)) * 0.02f;
            }
        }
        if (!isLeaping && !isLanding) {
            float breathe = Mth.m_14031_((float)(ageInTicks * 0.06f)) * 0.01f;
            this.body.f_104201_ += breathe;
        }
    }

    private void animateAttackSmooth(int attackTimeout, float ageInTicks) {
        if (attackTimeout <= 0) {
            this.attackStartTime = -1.0f;
            this.lastAttackTimeout = 0;
            return;
        }
        if (attackTimeout > this.lastAttackTimeout || this.attackStartTime < 0.0f) {
            this.attackStartTime = ageInTicks;
        }
        this.lastAttackTimeout = attackTimeout;
        float elapsedTime = ageInTicks - this.attackStartTime;
        float attackProgress = elapsedTime / 12.0f;
        attackProgress = Mth.m_14036_((float)attackProgress, (float)0.0f, (float)1.0f);
        float attackCurve = Mth.m_14031_((float)(attackProgress * (float)Math.PI));
        this.body.f_104203_ = -attackCurve * 0.25f;
        this.head.f_104203_ += -attackCurve * 0.6f;
        this.jaw.f_104203_ = 0.3927f - attackCurve * 0.3f;
        float tongueExtend = attackCurve * 0.3927f;
        this.tongue_2.f_104203_ = 0.3927f - tongueExtend;
        this.tongue_3.f_104203_ = 0.3927f - tongueExtend;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.back_right_leg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.back_left_leg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.front_right_leg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.front_left_leg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

