/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.entity.monster.ViventrumEntity;
import top.ribs.scguns.item.GunItem;

public class ViventrumModel<T extends ViventrumEntity>
extends EntityModel<T>
implements ArmedModel,
HeadedModel {
    private final ModelPart body;
    private final ModelPart tail_top;
    private final ModelPart tail_middle;
    private final ModelPart tail_end;
    private final ModelPart head;
    private final ModelPart left_arm;
    private final PartPose bodyDefault;
    private final PartPose tailTopDefault;
    private final PartPose tailMiddleDefault;
    private final PartPose tailEndDefault;
    private final PartPose headDefault;
    private final PartPose leftArmDefault;
    private float attackStartTime = -1.0f;
    private int lastAttackTimeout = 0;
    private static final float ATTACK_DURATION = 10.0f;

    public ViventrumModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.tail_top = this.body.m_171324_("tail_top");
        this.tail_middle = this.tail_top.m_171324_("tail_middle");
        this.tail_end = this.tail_middle.m_171324_("tail_end");
        this.head = root.m_171324_("head");
        this.left_arm = root.m_171324_("left_arm");
        this.bodyDefault = this.body.m_171308_();
        this.tailTopDefault = this.tail_top.m_171308_();
        this.tailMiddleDefault = this.tail_middle.m_171308_();
        this.tailEndDefault = this.tail_end.m_171308_();
        this.headDefault = this.head.m_171308_();
        this.leftArmDefault = this.left_arm.m_171308_();
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(38, 41).m_171488_(-2.5f, -6.0f, -2.5f, 4.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(37, 15).m_171488_(-1.5f, -7.0f, -1.5f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 15).m_171488_(-3.5f, -4.0f, -3.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(20, 24).m_171488_(-4.0f, -5.0f, 1.0f, 7.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)13.0f, (float)0.0f));
        PartDefinition cube_r1 = body.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(24, 4).m_171488_(-0.5f, 0.0f, 0.0f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-6.5f, (float)-3.25f, (float)-1.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = body.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(38, 37).m_171488_(-0.5f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)-2.5f, (float)-1.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = body.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(20, 28).m_171488_(-1.5f, -1.5f, -3.0f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)-1.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition tail_top = body.m_171599_("tail_top", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-0.75f, (float)1.0f));
        PartDefinition cube_r4 = tail_top.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(42, 14).m_171488_(-1.5f, -1.5f, -4.0f, 2.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.25f, (float)-0.5f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition tail_middle = tail_top.m_171599_("tail_middle", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)3.25f, (float)0.0f));
        PartDefinition cube_r5 = tail_middle.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-1.5f, -1.5f, 2.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)-0.5f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r6 = tail_middle.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(8, 42).m_171488_(-2.0f, -2.0f, -3.0f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)-0.5f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition tail_end = tail_middle.m_171599_("tail_end", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)2.75f, (float)0.0f));
        PartDefinition cube_r7 = tail_end.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(41, 27).m_171488_(-0.5f, 0.0f, -2.0f, 1.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)3.25f, (float)0.0f, (float)1.5708f, (float)-0.7854f, (float)-3.1416f));
        PartDefinition cube_r8 = tail_end.m_171599_("cube_r8", CubeListBuilder.m_171558_().m_171514_(40, 5).m_171488_(-0.5f, 0.0f, -2.0f, 1.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)3.25f, (float)0.0f, (float)-1.5708f, (float)-0.7854f, (float)0.0f));
        PartDefinition cube_r9 = tail_end.m_171599_("cube_r9", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(-1.5f, -1.0f, 3.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)-3.75f, (float)-0.5f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -7.0f, -4.4f, 8.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(32, 0).m_171488_(4.25f, -2.0f, -2.1929f, 0.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 15).m_171488_(-6.0144f, -3.6411f, -4.265f, 0.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(38, 33).m_171488_(-4.75f, -5.5f, -5.25f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(24, 21).m_171488_(-2.65f, -3.5f, -5.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(32, 11).m_171488_(-4.25f, -2.5f, -5.25f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 34).m_171488_(-4.75f, -5.5f, -4.25f, 1.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(36, 28).m_171488_(-5.25f, -5.0f, -4.25f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.4f));
        PartDefinition cube_r10 = head.m_171599_("cube_r10", CubeListBuilder.m_171558_().m_171514_(32, 5).m_171488_(-1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.75f, (float)-4.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition cube_r11 = head.m_171599_("cube_r11", CubeListBuilder.m_171558_().m_171514_(40, 11).m_171488_(0.0f, -1.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.3f, (float)-4.3f, (float)-5.15f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition cube_r12 = head.m_171599_("cube_r12", CubeListBuilder.m_171558_().m_171514_(30, 36).m_171488_(-1.0f, -2.0f, -0.5f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.3f, (float)-3.55f, (float)-4.9f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition cube_r13 = head.m_171599_("cube_r13", CubeListBuilder.m_171558_().m_171514_(4, 0).m_171488_(0.0f, -0.5f, -0.5f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.0934f, (float)-3.9225f, (float)0.2305f, (float)-0.2317f, (float)0.5856f, (float)0.1474f));
        PartDefinition cube_r14 = head.m_171599_("cube_r14", CubeListBuilder.m_171558_().m_171514_(0, 3).m_171488_(0.0f, -0.5f, -0.5f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.56f, (float)-4.4294f, (float)-1.616f, (float)-0.1966f, (float)0.2016f, (float)0.2372f));
        PartDefinition cube_r15 = head.m_171599_("cube_r15", CubeListBuilder.m_171558_().m_171514_(4, 5).m_171488_(-0.6638f, -0.7727f, -0.4641f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.3146f, (float)-4.3321f, (float)-2.9058f, (float)-0.2132f, (float)0.4409f, (float)0.185f));
        PartDefinition cube_r16 = head.m_171599_("cube_r16", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.7976f, -0.7727f, -1.8588f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.3146f, (float)-4.3321f, (float)-2.9058f, (float)-0.2036f, (float)-0.3291f, (float)0.3437f));
        PartDefinition cube_r17 = head.m_171599_("cube_r17", CubeListBuilder.m_171558_().m_171514_(18, 18).m_171488_(0.0f, -0.5f, -0.5f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.8958f, (float)-3.1411f, (float)0.9356f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition cube_r18 = head.m_171599_("cube_r18", CubeListBuilder.m_171558_().m_171514_(18, 15).m_171488_(0.0f, -0.5f, -0.5f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.8232f, (float)-3.1411f, (float)-0.8034f, (float)0.0f, (float)0.3927f, (float)0.0f));
        PartDefinition cube_r19 = head.m_171599_("cube_r19", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, -0.5f, -0.5f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.6612f, (float)-3.1411f, (float)-4.6178f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition cube_r20 = head.m_171599_("cube_r20", CubeListBuilder.m_171558_().m_171514_(2, 0).m_171488_(0.0f, -0.5f, -0.5f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.8083f, (float)-3.1411f, (float)-4.9711f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition cube_r21 = head.m_171599_("cube_r21", CubeListBuilder.m_171558_().m_171514_(4, 3).m_171488_(0.0f, -0.5f, -0.5f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.8083f, (float)-4.8911f, (float)-4.9711f, (float)-0.7494f, (float)-1.2344f, (float)1.0165f));
        PartDefinition cube_r22 = head.m_171599_("cube_r22", CubeListBuilder.m_171558_().m_171514_(34, 40).m_171488_(-0.9148f, -1.1672f, 1.0609f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.5777f, (float)-0.4363f, (float)-2.5259f, (float)-0.3927f, (float)0.5061f, (float)-1.5708f));
        PartDefinition cube_r23 = head.m_171599_("cube_r23", CubeListBuilder.m_171558_().m_171514_(30, 40).m_171488_(-0.961f, -0.6723f, -0.554f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.5777f, (float)-0.4363f, (float)-2.5259f, (float)0.0f, (float)0.5061f, (float)-1.5708f));
        PartDefinition cube_r24 = head.m_171599_("cube_r24", CubeListBuilder.m_171558_().m_171514_(40, 24).m_171488_(-1.0713f, -0.6723f, -1.7122f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.5777f, (float)-0.4363f, (float)-2.5259f, (float)0.0f, (float)-0.2793f, (float)-1.5708f));
        PartDefinition cube_r25 = head.m_171599_("cube_r25", CubeListBuilder.m_171558_().m_171514_(36, 33).m_171488_(-1.6449f, -0.6723f, -2.1715f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.5777f, (float)-0.4363f, (float)-2.5259f, (float)0.0f, (float)-0.672f, (float)-1.5708f));
        PartDefinition cube_r26 = head.m_171599_("cube_r26", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(1.0f, 0.5f, -2.5f, 3.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 24).m_171488_(-2.0f, -1.0f, -3.5f, 3.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)5.6f, (float)-1.5708f, (float)-0.7854f, (float)0.0f));
        PartDefinition cube_r27 = head.m_171599_("cube_r27", CubeListBuilder.m_171558_().m_171514_(36, 21).m_171488_(-1.5f, -0.5f, 3.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(30, 21).m_171488_(-1.5f, -0.5f, -4.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)5.6f, (float)-1.5708f, (float)-0.7854f, (float)0.0f));
        PartDefinition cube_r28 = head.m_171599_("cube_r28", CubeListBuilder.m_171558_().m_171514_(4, 41).m_171488_(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)-4.0f, (float)0.6f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r29 = head.m_171599_("cube_r29", CubeListBuilder.m_171558_().m_171514_(22, 15).m_171488_(-0.5f, -1.5f, -0.5f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)-2.0f, (float)-1.9f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r30 = head.m_171599_("cube_r30", CubeListBuilder.m_171558_().m_171514_(0, 41).m_171488_(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)-4.0f, (float)-2.4f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(10, 34).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(18, 36).m_171488_(0.0f, 5.0f, -1.5f, 0.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)10.5f, (float)-1.0f));
        PartDefinition cube_r31 = left_arm.m_171599_("cube_r31", CubeListBuilder.m_171558_().m_171514_(24, 36).m_171488_(0.0f, -2.0f, -1.5f, 0.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)7.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.m_171322_(this.bodyDefault);
        this.tail_top.m_171322_(this.tailTopDefault);
        this.tail_middle.m_171322_(this.tailMiddleDefault);
        this.tail_end.m_171322_(this.tailEndDefault);
        this.head.m_171322_(this.headDefault);
        this.left_arm.m_171322_(this.leftArmDefault);
        boolean holdingGun = entity.m_21205_().m_41720_() instanceof GunItem;
        if (entity.m_21824_() && ((ViventrumEntity)((Object)entity)).isDefensive()) {
            this.animateDefensive(ageInTicks);
            return;
        }
        if (entity.m_21824_() && ((ViventrumEntity)((Object)entity)).isPartying()) {
            this.animateDancing(ageInTicks);
            return;
        }
        float bobAmount = Mth.m_14031_((float)(ageInTicks * 0.1f)) * 0.1f;
        this.body.f_104201_ += bobAmount;
        this.head.f_104201_ += bobAmount;
        this.body.f_104205_ = Mth.m_14089_((float)(ageInTicks * 0.08f)) * 0.04f;
        float tailTime = ageInTicks * 0.12f;
        float tailSwayAmount = 0.3f;
        this.tail_top.f_104203_ = Mth.m_14031_((float)tailTime) * tailSwayAmount;
        this.tail_top.f_104205_ = Mth.m_14089_((float)(tailTime * 0.8f)) * tailSwayAmount * 0.5f;
        this.tail_middle.f_104203_ = Mth.m_14031_((float)(tailTime + 0.8f)) * tailSwayAmount * 0.8f;
        this.tail_middle.f_104205_ = Mth.m_14089_((float)(tailTime * 0.8f + 0.6f)) * tailSwayAmount * 0.4f;
        this.tail_end.f_104203_ = Mth.m_14031_((float)(tailTime + 1.6f)) * tailSwayAmount * 0.6f;
        this.tail_end.f_104204_ = Mth.m_14089_((float)(tailTime + 1.2f)) * 0.2f;
        if (!holdingGun && !((ViventrumEntity)((Object)entity)).isAttacking()) {
            float armTime = ageInTicks * 0.08f;
            this.left_arm.f_104203_ = Mth.m_14031_((float)armTime) * 0.15f - 0.15f;
            this.left_arm.f_104205_ = Mth.m_14089_((float)(armTime * 0.6f)) * 0.08f;
            this.left_arm.f_104204_ = Mth.m_14031_((float)(armTime * 0.5f)) * 0.05f;
        }
        if (((ViventrumEntity)((Object)entity)).isAttacking() && ((ViventrumEntity)((Object)entity)).getAttackTimeout() > 0 && !holdingGun) {
            this.animateAttackSmooth(((ViventrumEntity)((Object)entity)).getAttackTimeout(), ageInTicks);
        }
        if (holdingGun) {
            this.left_arm.f_104203_ = -1.5708f;
            this.left_arm.f_104204_ = 0.0f;
            this.left_arm.f_104205_ = 0.0f;
        }
        float clampedYaw = Mth.m_14036_((float)netHeadYaw, (float)-60.0f, (float)60.0f);
        float clampedPitch = Mth.m_14036_((float)headPitch, (float)-30.0f, (float)30.0f);
        this.head.f_104204_ = clampedYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = clampedPitch * ((float)Math.PI / 180) * 0.5f;
    }

    private void animateAttackSmooth(int attackTimeout, float ageInTicks) {
        if (attackTimeout <= 0) {
            this.left_arm.f_104203_ = 0.0f;
            this.left_arm.f_104204_ = 0.0f;
            this.left_arm.f_104205_ = 0.0f;
            this.attackStartTime = -1.0f;
            this.lastAttackTimeout = 0;
            return;
        }
        if (attackTimeout > this.lastAttackTimeout || this.attackStartTime < 0.0f) {
            this.attackStartTime = ageInTicks;
        }
        this.lastAttackTimeout = attackTimeout;
        float elapsedTime = ageInTicks - this.attackStartTime;
        float attackProgress = elapsedTime / 10.0f;
        attackProgress = Mth.m_14036_((float)attackProgress, (float)0.0f, (float)1.0f);
        float swingCurve = Mth.m_14031_((float)(attackProgress * (float)Math.PI));
        this.left_arm.f_104203_ = -swingCurve * 1.8f;
        this.left_arm.f_104204_ = swingCurve * 0.3f;
        this.left_arm.f_104205_ = 0.0f;
    }

    private void animateDefensive(float ageInTicks) {
        float bob = Mth.m_14031_((float)(ageInTicks * 0.08f)) * 0.15f;
        this.body.f_104201_ += 1.5f + bob;
        this.body.f_104203_ = -0.8f;
        this.body.f_104205_ = 0.0f;
        this.head.f_104203_ = 1.2f;
        this.head.f_104204_ = 0.0f;
        this.head.f_104205_ = 0.0f;
        this.head.f_104201_ += 0.5f + bob * 0.8f;
        this.left_arm.f_104203_ = -1.8f;
        this.left_arm.f_104204_ = 0.4f;
        this.left_arm.f_104205_ = 0.6f;
        this.left_arm.f_104201_ += 1.0f + bob * 0.7f;
        this.tail_top.f_104203_ = 2.0f;
        this.tail_top.f_104204_ = 0.0f;
        this.tail_top.f_104205_ = 0.0f;
        this.tail_middle.f_104203_ = 1.8f;
        this.tail_middle.f_104204_ = 0.0f;
        this.tail_middle.f_104205_ = 0.0f;
        this.tail_end.f_104203_ = 1.4f;
        this.tail_end.f_104204_ = 0.0f;
        this.tail_end.f_104205_ = 0.0f;
    }

    private void animateDancing(float ageInTicks) {
        float danceSpeed = 0.4f;
        float bounce = Mth.m_14154_((float)Mth.m_14031_((float)(ageInTicks * danceSpeed))) * 1.5f;
        this.body.f_104201_ += bounce;
        this.head.f_104201_ += bounce * 1.2f;
        this.body.f_104205_ = Mth.m_14031_((float)(ageInTicks * danceSpeed * 0.8f)) * 0.25f;
        this.body.f_104203_ = Mth.m_14089_((float)(ageInTicks * danceSpeed * 0.5f)) * 0.12f;
        this.head.f_104203_ = Mth.m_14031_((float)(ageInTicks * danceSpeed * 2.0f)) * 0.2f;
        this.head.f_104204_ = Mth.m_14031_((float)(ageInTicks * danceSpeed * 1.2f)) * 0.35f;
        this.head.f_104205_ = Mth.m_14089_((float)(ageInTicks * danceSpeed * 1.5f)) * 0.15f;
        float armPhase = ageInTicks * danceSpeed;
        this.left_arm.f_104203_ = -2.2f + Mth.m_14031_((float)(armPhase * 1.3f)) * 0.3f;
        this.left_arm.f_104205_ = Mth.m_14031_((float)(armPhase * 0.9f)) * 0.4f;
        this.left_arm.f_104204_ = Mth.m_14089_((float)(armPhase * 0.7f)) * 0.2f;
        float tailTime = ageInTicks * danceSpeed * 1.5f;
        this.tail_top.f_104203_ = Mth.m_14031_((float)tailTime) * 0.6f;
        this.tail_top.f_104205_ = Mth.m_14089_((float)(tailTime * 0.9f)) * 0.5f;
        this.tail_top.f_104204_ = Mth.m_14031_((float)(tailTime * 0.7f)) * 0.3f;
        this.tail_middle.f_104203_ = Mth.m_14031_((float)(tailTime + 1.0f)) * 0.7f;
        this.tail_middle.f_104205_ = Mth.m_14089_((float)(tailTime * 0.8f + 0.8f)) * 0.6f;
        this.tail_middle.f_104204_ = Mth.m_14089_((float)(tailTime + 0.5f)) * 0.4f;
        this.tail_end.f_104203_ = Mth.m_14031_((float)(tailTime + 2.0f)) * 0.5f;
        this.tail_end.f_104204_ = Mth.m_14089_((float)(tailTime + 1.5f)) * 0.5f;
        this.tail_end.f_104205_ = Mth.m_14031_((float)(tailTime * 1.2f)) * 0.3f;
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.left_arm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void m_6002_(HumanoidArm pSide, PoseStack pPoseStack) {
        if (pSide == HumanoidArm.LEFT) {
            this.left_arm.m_104299_(pPoseStack);
            pPoseStack.m_85837_(-0.05, 0.0, 0.0);
            pPoseStack.m_85841_(0.9f, 0.9f, 0.9f);
        }
    }

    public ModelPart m_5585_() {
        return this.head;
    }
}

