/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.monster;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.ribs.scguns.init.ModSounds;

public class PraetorEntity
extends Monster {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(PraetorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ATTACK_TIMEOUT = SynchedEntityData.m_135353_(PraetorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_VARIATION = SynchedEntityData.m_135353_(PraetorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_IN_SECOND_PHASE = SynchedEntityData.m_135353_(PraetorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_ROARING = SynchedEntityData.m_135353_(PraetorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ROAR_TICK = SynchedEntityData.m_135353_(PraetorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final float SECOND_PHASE_HEALTH_THRESHOLD = 30.0f;
    private static final float REGENERATION_TARGET = 60.0f;
    private static final float REGENERATION_RATE = 0.5f;
    private static final int REGENERATION_DURATION = 100;
    private static final int ROAR_DURATION = 40;
    private boolean hasTriggeredSecondPhase = false;
    private boolean isRegenerating = false;
    private int regenerationTicks = 0;
    private static final UUID SPEED_MODIFIER_UUID = UUID.fromString("d4c7f9a2-8b3e-4a1c-9d6e-2f8c4b1a5e3d");
    private static final UUID DAMAGE_MODIFIER_UUID = UUID.fromString("e5d8f0b3-9c4f-5b2d-0e7f-3a9d5c2b6f4e");

    public PraetorEntity(EntityType<? extends PraetorEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 90.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.28).m_22268_(Attributes.f_22285_, 2.0).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22278_, (double)0.7f).m_22268_(Attributes.f_22282_, (double)1.2f).m_22268_(Attributes.f_22281_, 10.0);
    }

    @NotNull
    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(ATTACK_TIMEOUT, (Object)0);
        this.f_19804_.m_135372_(ATTACK_VARIATION, (Object)0);
        this.f_19804_.m_135372_(IS_IN_SECOND_PHASE, (Object)false);
        this.f_19804_.m_135372_(IS_ROARING, (Object)false);
        this.f_19804_.m_135372_(ROAR_TICK, (Object)0);
    }

    public boolean isInSecondPhase() {
        return (Boolean)this.f_19804_.m_135370_(IS_IN_SECOND_PHASE);
    }

    public void setInSecondPhase(boolean inSecondPhase) {
        this.f_19804_.m_135381_(IS_IN_SECOND_PHASE, (Object)inSecondPhase);
    }

    public boolean isRoaring() {
        return (Boolean)this.f_19804_.m_135370_(IS_ROARING);
    }

    public void setRoaring(boolean roaring) {
        this.f_19804_.m_135381_(IS_ROARING, (Object)roaring);
    }

    public int getRoarTick() {
        return (Integer)this.f_19804_.m_135370_(ROAR_TICK);
    }

    public void setRoarTick(int tick) {
        this.f_19804_.m_135381_(ROAR_TICK, (Object)tick);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            this.handleSecondPhase();
            this.handleRegeneration();
            this.handleRoaring();
            if (this.isAttacking() && this.getAttackTimeout() > 0) {
                LivingEntity target;
                this.setAttackTimeout(this.getAttackTimeout() - 1);
                if (this.getAttackTimeout() == 6 && (target = this.m_5448_()) != null && this.m_20280_((Entity)target) <= (double)(this.m_20205_() * 2.5f * this.m_20205_() * 2.5f + target.m_20205_())) {
                    this.m_7327_((Entity)target);
                }
                if (this.getAttackTimeout() <= 0) {
                    this.setAttacking(false);
                }
            }
        } else if (this.isRoaring()) {
            this.spawnRoarParticles();
        }
    }

    private void handleSecondPhase() {
        if (!this.hasTriggeredSecondPhase && this.m_21223_() <= 30.0f) {
            this.hasTriggeredSecondPhase = true;
            this.isRegenerating = true;
            this.regenerationTicks = 0;
            this.setInSecondPhase(true);
            this.setRoaring(true);
            this.setRoarTick(0);
            this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 2, false, false));
            if (Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22111_(SPEED_MODIFIER_UUID) == null) {
                Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22125_(new AttributeModifier(SPEED_MODIFIER_UUID, "Second phase speed boost", 0.08, AttributeModifier.Operation.ADDITION));
            }
            if (Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22111_(DAMAGE_MODIFIER_UUID) == null) {
                Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22125_(new AttributeModifier(DAMAGE_MODIFIER_UUID, "Second phase damage boost", 3.0, AttributeModifier.Operation.ADDITION));
            }
            this.m_5496_((SoundEvent)ModSounds.PRAETOR_ROAR.get(), 1.5f, 0.8f);
        }
    }

    private void handleRegeneration() {
        if (this.isRegenerating) {
            ++this.regenerationTicks;
            if (this.regenerationTicks <= 100 && this.m_21223_() < 60.0f) {
                this.m_5634_(0.5f);
            } else if (this.regenerationTicks > 100 || this.m_21223_() >= 60.0f) {
                this.isRegenerating = false;
                this.m_21195_(MobEffects.f_19606_);
            }
        }
    }

    private void handleRoaring() {
        if (this.isRoaring()) {
            int currentTick = this.getRoarTick();
            if (currentTick >= 40) {
                this.setRoaring(false);
                this.setRoarTick(0);
            } else {
                this.setRoarTick(currentTick + 1);
            }
        }
    }

    private void spawnRoarParticles() {
        if (this.f_19796_.m_188501_() < 0.3f) {
            double offsetX = (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 1.5;
            double offsetY = this.f_19796_.m_188500_() * (double)this.m_20206_();
            double offsetZ = (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 1.5;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 0.0, 0.05, 0.0);
            if (this.f_19796_.m_188501_() < 0.5f) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 0.0, 0.02, 0.0);
            }
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
                if (pDistToEnemySqr <= this.m_6639_(pEnemy) && this.m_25565_() <= 0 && !PraetorEntity.this.isAttacking()) {
                    PraetorEntity.this.setAttacking(true);
                    this.m_25563_();
                    this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
                }
            }

            protected double m_6639_(LivingEntity pEnemy) {
                return super.m_6639_(pEnemy) * 2.0;
            }

            protected void m_25563_() {
                this.m_183277_(30);
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 1.0, 35.0f));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{PraetorEntity.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, player -> !((Player)player).m_7500_() && !player.m_5833_()));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
        if (attacking) {
            this.setAttackTimeout(12);
            this.f_19804_.m_135381_(ATTACK_VARIATION, (Object)this.f_19796_.m_188503_(3));
        }
    }

    public void setAttackTimeout(int timeout) {
        this.f_19804_.m_135381_(ATTACK_TIMEOUT, (Object)timeout);
    }

    public int getAttackTimeout() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TIMEOUT);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public int getAttackVariation() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_VARIATION);
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.hasTriggeredSecondPhase = compound.m_128471_("HasTriggeredSecondPhase");
        this.isRegenerating = compound.m_128471_("IsRegenerating");
        this.regenerationTicks = compound.m_128451_("RegenerationTicks");
        if (compound.m_128471_("IsInSecondPhase")) {
            this.setInSecondPhase(true);
        }
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("HasTriggeredSecondPhase", this.hasTriggeredSecondPhase);
        compound.m_128379_("IsRegenerating", this.isRegenerating);
        compound.m_128405_("RegenerationTicks", this.regenerationTicks);
        compound.m_128379_("IsInSecondPhase", this.isInSecondPhase());
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.PRAETOR_IDLE.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.PRAETOR_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.PRAETOR_DIE.get();
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.m_5496_(SoundEvents.f_12361_, 0.8f, 1.0f);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_20096_() && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.7, 1.0));
        }
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        double velocityThreshold = -0.6;
        if (y >= velocityThreshold) {
            this.f_19789_ = 0.0f;
        } else {
            super.m_7840_(y, onGroundIn, state, pos);
        }
    }
}

