/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.monster;

import java.util.EnumSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.ribs.scguns.Config;
import top.ribs.scguns.entity.monster.SignalBeaconEntity;
import top.ribs.scguns.entity.projectile.TraumaHookEntity;
import top.ribs.scguns.init.ModEntities;

public class TraumaUnitEntity
extends Monster {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(TraumaUnitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ATTACK_TIMEOUT = SynchedEntityData.m_135353_(TraumaUnitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HOOKED_ENTITY_ID = SynchedEntityData.m_135353_(TraumaUnitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> PRIMED = SynchedEntityData.m_135353_(TraumaUnitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final float LOW_HEALTH_THRESHOLD = 0.35f;
    private static final float EXPLOSION_DAMAGE = 8.0f;
    private static final float EXPLOSION_RADIUS = 3.5f;
    private int primeTicks = 0;
    private static final int HOOK_DURATION = 5;
    private int hookTicks = 0;
    private int oldSwell;
    private int swell;
    private static final int MAX_SWELL = 40;
    public final AnimationState idleAnimationState = new AnimationState();

    public TraumaUnitEntity(EntityType<? extends TraumaUnitEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public boolean m_7301_(@NotNull MobEffectInstance pPotionEffect) {
        MobEffect effect = pPotionEffect.m_19544_();
        if (effect == MobEffects.f_19614_ || effect == MobEffects.f_19615_ || effect == MobEffects.f_19612_ || effect == MobEffects.f_19605_ || effect == MobEffects.f_19618_ || effect == MobEffects.f_19604_ || effect == MobEffects.f_19610_ || effect == MobEffects.f_19613_ || effect == MobEffects.f_19597_ || effect == MobEffects.f_19599_ || effect == MobEffects.f_19602_ || effect == MobEffects.f_19601_) {
            return false;
        }
        return super.m_7301_(pPotionEffect);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22279_, 0.27).m_22268_(Attributes.f_22285_, 0.5).m_22268_(Attributes.f_22284_, 3.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22282_, (double)0.8f).m_22268_(Attributes.f_22281_, 6.0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            LivingEntity target;
            LivingEntity hooked;
            Entity entity;
            if (this.isAttacking() && this.getAttackTimeout() > 0) {
                this.setAttackTimeout(this.getAttackTimeout() - 1);
                if (this.getAttackTimeout() <= 0) {
                    this.setAttacking(false);
                }
            }
            this.manageHookLifecycle();
            TraumaHookEntity hook = this.findActiveHook();
            if (hook != null && hook.m_37170_() != null && (entity = hook.m_37170_()) instanceof LivingEntity) {
                LivingEntity hookedEntity = (LivingEntity)entity;
                if (this.getHookedEntity() == null) {
                    this.setHookedEntity(hookedEntity);
                    this.hookTicks = 0;
                }
            } else if (hook == null) {
                this.setHookedEntity(null);
            }
            if ((hooked = this.getHookedEntity()) != null) {
                ++this.hookTicks;
                double dist = this.m_20270_((Entity)hooked);
                if (this.hookTicks >= 5 || dist <= 2.0) {
                    this.setHookedEntity(null);
                    this.hookTicks = 0;
                    if (hook != null) {
                        hook.m_146870_();
                    }
                    if (dist <= 2.5) {
                        this.m_7327_((Entity)hooked);
                    }
                } else {
                    Vec3 direction = this.m_20182_().m_82546_(hooked.m_20182_()).m_82541_();
                    double pullStrength = 1.0;
                    Vec3 pull = direction.m_82490_(pullStrength).m_82520_(0.0, 0.15, 0.0);
                    hooked.m_20256_(hooked.m_20184_().m_82549_(pull));
                    hooked.f_19864_ = true;
                }
            }
            if ((target = this.m_5448_()) != null && this.isLowHealth()) {
                double dist = this.m_20270_((Entity)target);
                if (this.isPrimed()) {
                    if (this.swell >= 40) {
                        this.swell = 40;
                        this.explode();
                        return;
                    }
                } else if (dist <= 3.0) {
                    this.setPrimed(true);
                    this.m_9236_().m_7605_((Entity)this, (byte)5);
                    this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.5f);
                }
            } else if (this.isPrimed() && !this.isLowHealth()) {
                this.setPrimed(false);
            }
        }
        if (this.m_6084_()) {
            this.oldSwell = this.swell++;
            if (!this.isPrimed() && this.swell > 0) {
                --this.swell;
            }
            if (this.swell < 0) {
                this.swell = 0;
            }
        }
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    public float getSwelling(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.oldSwell, (float)this.swell) / 38.0f;
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        if (!this.m_9236_().f_46443_) {
            float skeletonChance = 0.75f;
            float beaconChance = Math.min(((Double)Config.COMMON.gameplay.cogBeaconSpawnChance.get()).floatValue(), 0.25f);
            float rand = this.f_19796_.m_188501_();
            if (rand < skeletonChance) {
                Skeleton skeleton = new Skeleton(EntityType.f_20524_, this.m_9236_());
                skeleton.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
                skeleton.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                skeleton.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                this.m_9236_().m_7967_((Entity)skeleton);
            } else if (rand < skeletonChance + beaconChance && source.m_7639_() instanceof Player) {
                SignalBeaconEntity beacon = new SignalBeaconEntity((EntityType<? extends Mob>)((EntityType)ModEntities.SIGNAL_BEACON.get()), this.m_9236_());
                beacon.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
                this.m_9236_().m_7967_((Entity)beacon);
            }
        }
    }

    private TraumaHookEntity findActiveHook() {
        for (TraumaHookEntity hook : this.m_9236_().m_45976_(TraumaHookEntity.class, this.m_20191_().m_82400_(20.0))) {
            if (hook.m_19749_() != this || hook.m_213877_()) continue;
            return hook;
        }
        return null;
    }

    private void manageHookLifecycle() {
        LivingEntity target;
        TraumaHookEntity hook = this.findActiveHook();
        if (!(hook != null && ((target = this.m_5448_()) == null || (double)this.m_20270_((Entity)target) < 3.0 || hook.m_20096_() && hook.m_37170_() == null && hook.f_19797_ > 20) && hook.isRetracting())) {
            // empty if block
        }
    }

    private void setupAnimationStates() {
        if (!this.idleAnimationState.m_216984_()) {
            this.idleAnimationState.m_216977_(this.f_19797_);
        }
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
        if (attacking) {
            this.setAttackTimeout(15);
        }
    }

    public void setAttackTimeout(int timeout) {
        this.f_19804_.m_135381_(ATTACK_TIMEOUT, (Object)timeout);
    }

    public int getAttackTimeout() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TIMEOUT);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public void setHookedEntity(@Nullable LivingEntity entity) {
        this.f_19804_.m_135381_(HOOKED_ENTITY_ID, (Object)(entity == null ? 0 : entity.m_19879_()));
    }

    @Nullable
    public LivingEntity getHookedEntity() {
        int id = (Integer)this.f_19804_.m_135370_(HOOKED_ENTITY_ID);
        if (id == 0) {
            return null;
        }
        Entity entity = this.m_9236_().m_6815_(id);
        return entity instanceof LivingEntity ? (LivingEntity)entity : null;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(ATTACK_TIMEOUT, (Object)0);
        this.f_19804_.m_135372_(HOOKED_ENTITY_ID, (Object)0);
        this.f_19804_.m_135372_(PRIMED, (Object)false);
    }

    public void setPrimed(boolean primed) {
        this.f_19804_.m_135381_(PRIMED, (Object)primed);
    }

    public boolean isPrimed() {
        return (Boolean)this.f_19804_.m_135370_(PRIMED);
    }

    public boolean isLowHealth() {
        return this.m_21223_() / this.m_21233_() <= 0.35f;
    }

    private void explode() {
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(3.5), entity -> entity != this && entity.m_6084_()).forEach(entity -> {
                float distance = this.m_20270_((Entity)entity);
                float damageFactor = 1.0f - distance / 3.5f;
                float damage = 8.0f * Math.max(0.0f, damageFactor);
                entity.m_6469_(this.m_269291_().m_269036_((Entity)this, (Entity)this), damage);
                Vec3 direction = entity.m_20182_().m_82546_(this.m_20182_()).m_82541_();
                entity.m_20256_(entity.m_20184_().m_82520_(direction.f_82479_ * 0.8 * (double)damageFactor, 0.4 * (double)damageFactor, direction.f_82481_ * 0.8 * (double)damageFactor));
            });
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.5f, Level.ExplosionInteraction.NONE);
            this.m_5496_(SoundEvents.f_11913_, 1.5f, 0.9f);
            this.m_9236_().m_7605_((Entity)this, (byte)6);
            this.m_146870_();
        }
    }

    public void m_7822_(byte pId) {
        if (pId == 6) {
            int i;
            for (i = 0; i < 50; ++i) {
                double offsetX = (this.f_19796_.m_188500_() - 0.5) * 2.0;
                double offsetY = this.f_19796_.m_188500_() * 1.5;
                double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 2.0;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 0.0, 0.0, 0.0);
            }
            for (i = 0; i < 60; ++i) {
                double velocityX = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                double velocityY = this.f_19796_.m_188500_() * 0.4;
                double velocityZ = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), velocityX, velocityY, velocityZ);
            }
        } else {
            super.m_7822_(pId);
        }
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new CastHookGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
                if (pDistToEnemySqr <= this.m_6639_(pEnemy) && this.m_25565_() <= 0 && !TraumaUnitEntity.this.isAttacking()) {
                    TraumaUnitEntity.this.setAttacking(true);
                    this.m_25563_();
                    this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
                    this.f_25540_.m_7327_((Entity)pEnemy);
                }
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 1.0, 30.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{TraumaUnitEntity.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, player -> !((Player)player).m_7500_() && !((Player)player).m_5833_()));
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6040_() {
        return true;
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return SoundEvents.f_12008_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12059_;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_20096_() && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("HookTicks", this.hookTicks);
        tag.m_128405_("PrimeTicks", this.primeTicks);
        tag.m_128376_("Swell", (short)this.swell);
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.hookTicks = tag.m_128451_("HookTicks");
        this.primeTicks = tag.m_128451_("PrimeTicks");
        this.oldSwell = this.swell = (int)tag.m_128448_("Swell");
    }

    private static class CastHookGoal
    extends Goal {
        private final TraumaUnitEntity mob;
        private int cooldown = 0;
        private LivingEntity lastTarget = null;

        public CastHookGoal(TraumaUnitEntity mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            LivingEntity target = this.mob.m_5448_();
            if (target == null) {
                return false;
            }
            double distance = this.mob.m_20270_((Entity)target);
            boolean inRange = distance > 3.0 && distance < 28.0;
            boolean noHookedEntity = this.mob.getHookedEntity() == null;
            boolean hasLineOfSight = this.mob.m_142582_((Entity)target);
            boolean noActiveHook = this.mob.findActiveHook() == null;
            boolean newTarget = this.lastTarget != target;
            return inRange && noHookedEntity && hasLineOfSight && noActiveHook && (newTarget || this.mob.m_217043_().m_188501_() < 0.3f);
        }

        public void m_8056_() {
            LivingEntity target = this.mob.m_5448_();
            if (target == null) {
                return;
            }
            this.lastTarget = target;
            Vec3 mobPos = this.mob.m_20182_().m_82520_(0.0, (double)this.mob.m_20192_() * 0.8, 0.0);
            Vec3 forward = Vec3.m_82498_((float)0.0f, (float)this.mob.m_146908_()).m_82490_(0.5);
            Vec3 hookStartPos = mobPos.m_82549_(forward);
            TraumaHookEntity hook = new TraumaHookEntity((EntityType<? extends TraumaHookEntity>)((EntityType)ModEntities.TRAUMA_HOOK.get()), (LivingEntity)this.mob, this.mob.m_9236_());
            hook.m_7678_(hookStartPos.f_82479_, hookStartPos.f_82480_, hookStartPos.f_82481_, this.mob.m_146908_(), 0.0f);
            Vec3 targetPos = target.m_20182_().m_82520_(0.0, (double)target.m_20192_() * 0.5, 0.0);
            Vec3 targetVelocity = target.m_20184_();
            double timeToTarget = hookStartPos.m_82554_(targetPos) / 1.25;
            Vec3 predictedPos = targetPos.m_82549_(targetVelocity.m_82490_(timeToTarget * 0.7));
            Vec3 direction = predictedPos.m_82546_(hookStartPos);
            direction = direction.m_82520_(0.0, Math.min(direction.m_165924_() * 0.1, 2.0), 0.0);
            hook.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, 1.5f, 0.5f);
            boolean added = this.mob.m_9236_().m_7967_((Entity)hook);
            if (added) {
                this.mob.setAttacking(true);
                this.mob.m_5496_(SoundEvents.f_11941_, 0.8f, 0.8f + this.mob.m_217043_().m_188501_() * 0.4f);
                this.cooldown = 40 + this.mob.m_217043_().m_188503_(40);
            } else {
                this.cooldown = 20;
            }
        }

        public boolean m_8045_() {
            return false;
        }
    }
}

