/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.player;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import top.ribs.scguns.entity.player.GunTier;
import top.ribs.scguns.entity.player.GunTierRegistry;
import top.ribs.scguns.entity.player.GunTiers;
import top.ribs.scguns.init.ModTags;

public class PlayerGunProgression {
    private static final String NBT_KEY = "SCGunsProgression";
    private static final String TIER_KEY = "CurrentTier";
    private static final String RAID_LEVEL_KEY = "RaidLevel";
    private GunTier currentTier = GunTiers.NONE;
    private int currentRaidLevel = 0;

    public GunTier getCurrentTier() {
        return this.currentTier;
    }

    public int getCurrentRaidLevel() {
        return this.currentRaidLevel;
    }

    public List<GunTier> getAvailableMobTiers() {
        return this.currentTier.getAvailableMobTiers();
    }

    public boolean updateTier(GunTier newTier) {
        if (newTier == null) {
            return false;
        }
        if (newTier.getLevel() > this.currentTier.getLevel()) {
            this.currentTier = newTier;
            this.currentRaidLevel = newTier.getRaidLevel();
            return true;
        }
        return false;
    }

    public void setTier(GunTier tier) {
        if (tier == null) {
            this.currentTier = GunTiers.NONE;
            this.currentRaidLevel = 0;
        } else {
            this.currentTier = tier;
            this.currentRaidLevel = tier.getRaidLevel();
        }
    }

    public void setRaidLevel(int level) {
        this.currentRaidLevel = Math.max(0, level);
    }

    public boolean checkAndUpdateFromItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        for (GunTier tier : GunTierRegistry.getAllTiers()) {
            if (tier.getTagName() == null || !ModTags.Items.isInTierTag(stack, tier)) continue;
            return this.updateTier(tier);
        }
        return false;
    }

    public CompoundTag saveNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("TierId", this.currentTier.getId());
        tag.m_128405_(TIER_KEY, this.currentTier.getLevel());
        tag.m_128405_(RAID_LEVEL_KEY, this.currentRaidLevel);
        return tag;
    }

    public void loadNBT(CompoundTag tag) {
        String tierId;
        GunTier tier;
        this.currentTier = tag.m_128441_("TierId") ? ((tier = GunTierRegistry.getTier(tierId = tag.m_128461_("TierId"))) != null ? tier : this.migrateLegacyTier(tag)) : this.migrateLegacyTier(tag);
        this.currentRaidLevel = tag.m_128441_(RAID_LEVEL_KEY) ? tag.m_128451_(RAID_LEVEL_KEY) : this.currentTier.getRaidLevel();
    }

    @Nullable
    private GunTier migrateLegacyTier(CompoundTag tag) {
        int level;
        String tierName;
        GunTier tier;
        if (tag.m_128441_("TierName") && (tier = GunTierRegistry.getTier(tierName = tag.m_128461_("TierName").toLowerCase())) != null) {
            return tier;
        }
        if (tag.m_128441_(TIER_KEY) && (tier = GunTierRegistry.getTierByLevel(level = tag.m_128451_(TIER_KEY))) != null) {
            return tier;
        }
        return GunTiers.NONE;
    }

    public static PlayerGunProgression get(Player player) {
        CompoundTag persistentData = player.getPersistentData();
        PlayerGunProgression progression = new PlayerGunProgression();
        if (persistentData.m_128441_(NBT_KEY)) {
            progression.loadNBT(persistentData.m_128469_(NBT_KEY));
        }
        return progression;
    }

    public static void save(Player player, PlayerGunProgression progression) {
        CompoundTag persistentData = player.getPersistentData();
        persistentData.m_128365_(NBT_KEY, (Tag)progression.saveNBT());
    }

    public static boolean updateAndSave(Player player, ItemStack stack) {
        PlayerGunProgression progression = PlayerGunProgression.get(player);
        boolean updated = progression.checkAndUpdateFromItem(stack);
        if (updated) {
            PlayerGunProgression.save(player, progression);
        }
        return updated;
    }
}

