/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.projectile;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.entity.projectile.ProjectileEntity;
import top.ribs.scguns.init.ModDamageTypes;
import top.ribs.scguns.init.ModParticleTypes;
import top.ribs.scguns.item.GunItem;

public class BouncyGrenadeRoundEntity
extends ProjectileEntity {
    private static final float EXPLOSION_RADIUS = 4.0f;
    private static final int MAX_BOUNCES = 3;
    private static final float BOUNCE_VELOCITY_RETENTION = 0.75f;
    private static final float MIN_BOUNCE_VELOCITY = 0.05f;
    private int bouncesLeft = 3;

    public BouncyGrenadeRoundEntity(EntityType<? extends ProjectileEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public BouncyGrenadeRoundEntity(EntityType<? extends ProjectileEntity> entityType, Level worldIn, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, weapon, item, modifiedGun);
    }

    @Override
    public void m_8119_() {
        this.updateHeading();
        this.onProjectileTick();
        if (!this.m_9236_().m_5776_()) {
            Vec3 startVec = this.m_20182_();
            Vec3 endVec = startVec.m_82549_(this.m_20184_());
            BlockHitResult blockResult = this.m_9236_().m_45547_(new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            List<ProjectileEntity.EntityResult> entityResults = this.findEntitiesOnPath(startVec, endVec);
            double blockDistance = Double.MAX_VALUE;
            double entityDistance = Double.MAX_VALUE;
            if (blockResult.m_6662_() != HitResult.Type.MISS) {
                blockDistance = startVec.m_82557_(blockResult.m_82450_());
            }
            ProjectileEntity.EntityResult closestEntity = null;
            if (!entityResults.isEmpty()) {
                for (ProjectileEntity.EntityResult entityResult : entityResults) {
                    double dist = startVec.m_82557_(entityResult.getHitPos());
                    if (!(dist < entityDistance)) continue;
                    entityDistance = dist;
                    closestEntity = entityResult;
                }
            }
            if (closestEntity != null && entityDistance < blockDistance) {
                this.handleEntityImpact(closestEntity.getEntity(), closestEntity.getHitPos());
            } else if (blockResult.m_6662_() != HitResult.Type.MISS) {
                this.handleBlockImpact(blockResult);
            }
        }
        double nextPosX = this.m_20185_() + this.m_20184_().m_7096_();
        double nextPosY = this.m_20186_() + this.m_20184_().m_7098_();
        double nextPosZ = this.m_20189_() + this.m_20184_().m_7094_();
        this.m_6034_(nextPosX, nextPosY, nextPosZ);
        if (this.projectile.isGravity()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, this.modifiedGravity, 0.0));
        }
        if (this.f_19797_ >= this.life) {
            if (this.m_6084_()) {
                this.onExpired();
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    private void handleEntityImpact(Entity entity, Vec3 hitVec) {
        if (entity instanceof Player) {
            boolean isBlockingOffHand;
            Player player = (Player)entity;
            ItemStack mainHandItem = player.m_21205_();
            ItemStack offHandItem = player.m_21206_();
            boolean isBlockingMainHand = player.m_21254_() && mainHandItem.m_41720_() instanceof ShieldItem;
            boolean bl = isBlockingOffHand = player.m_21254_() && offHandItem.m_41720_() instanceof ShieldItem;
            if (isBlockingMainHand || isBlockingOffHand) {
                ItemStack shield = isBlockingMainHand ? mainHandItem : offHandItem;
                InteractionHand hand = isBlockingMainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                player.m_36335_().m_41524_(shield.m_41720_(), 100);
                player.m_5810_();
                player.m_9236_().m_7605_((Entity)player, (byte)30);
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12347_, SoundSource.PLAYERS, 1.0f, 0.8f + player.m_9236_().m_213780_().m_188501_() * 0.4f);
                shield.m_41622_(15, (LivingEntity)player, p -> p.m_21190_(hand));
            }
        }
        this.createBouncyGrenadeExplosion(this, 4.0f);
    }

    private void handleBlockImpact(BlockHitResult result) {
        Vec3 hitVec = result.m_82450_();
        BlockPos pos = result.m_82425_();
        BlockState state = this.m_9236_().m_8055_(pos);
        Direction face = result.m_82434_();
        if (this.bouncesLeft > 0 && this.canBounce() && !state.m_247087_()) {
            this.bounce(face, hitVec);
            --this.bouncesLeft;
            this.m_9236_().m_6263_(null, hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, SoundEvents.f_12391_, SoundSource.NEUTRAL, 0.8f, 1.0f + (this.f_19796_.m_188501_() - 0.5f) * 0.4f);
            this.spawnBounceParticles(hitVec);
        } else {
            this.createBouncyGrenadeExplosion(this, 4.0f);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    private void bounce(Direction face, Vec3 hitPos) {
        Vec3 velocity = this.m_20184_();
        Vec3 newVelocity = switch (face.m_122434_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> new Vec3(-velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
            case Direction.Axis.Y -> new Vec3(velocity.f_82479_, -velocity.f_82480_, velocity.f_82481_);
            case Direction.Axis.Z -> new Vec3(velocity.f_82479_, velocity.f_82480_, -velocity.f_82481_);
        };
        newVelocity = newVelocity.m_82490_(0.75);
        newVelocity = newVelocity.m_82520_((this.f_19796_.m_188500_() - 0.5) * 0.05, (this.f_19796_.m_188500_() - 0.5) * 0.05, (this.f_19796_.m_188500_() - 0.5) * 0.05);
        this.m_20256_(newVelocity);
        Vec3 offset = Vec3.m_82528_((Vec3i)face.m_122436_()).m_82490_(0.2);
        this.m_146884_(hitPos.m_82549_(offset));
    }

    private boolean canBounce() {
        double currentSpeed = this.m_20184_().m_82553_();
        return currentSpeed > (double)0.05f;
    }

    private void spawnBounceParticles(Vec3 position) {
        if (!this.m_9236_().f_46443_) {
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            for (int i = 0; i < 6; ++i) {
                double velocityX = (this.f_19796_.m_188500_() - 0.5) * 0.4;
                double velocityY = this.f_19796_.m_188500_() * 0.4;
                double velocityZ = (this.f_19796_.m_188500_() - 0.5) * 0.4;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, position.f_82479_, position.f_82480_, position.f_82481_, 1, velocityX, velocityY, velocityZ, 0.05);
            }
        }
    }

    @Override
    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
    }

    @Override
    protected void onHitBlock(BlockState state, BlockPos pos, Direction face, double x, double y, double z) {
    }

    @Override
    public void onExpired() {
        this.createBouncyGrenadeExplosion(this, 4.0f);
    }

    private void createBouncyGrenadeExplosion(Entity entity, float radius) {
        Level world = entity.m_9236_();
        if (world.m_5776_()) {
            return;
        }
        Vec3 explosionPos = new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        this.playExplosionSound(world, explosionPos, radius);
        this.spawnExplosionParticles(world, explosionPos, radius);
        this.applyExplosionDamage(world, explosionPos, radius, this.getDamage(), entity);
    }

    private void playExplosionSound(Level world, Vec3 pos, float radius) {
        float volume = Math.min(3.0f, radius * 0.5f);
        float pitch = 0.9f + world.f_46441_.m_188501_() * 0.3f;
        world.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11913_, SoundSource.BLOCKS, volume, pitch);
    }

    private void spawnExplosionParticles(Level world, Vec3 explosionPos, float radius) {
        ServerLevel serverLevel = (ServerLevel)world;
        double sizeMultiplier = (double)radius / 3.5;
        BlockPos blockPos = BlockPos.m_274561_((double)explosionPos.f_82479_, (double)explosionPos.f_82480_, (double)explosionPos.f_82481_);
        BlockState blockAtExplosion = world.m_8055_(blockPos);
        double adjustedY = blockAtExplosion.m_60795_() ? explosionPos.f_82480_ + 0.2 : (double)blockPos.m_123342_() + 1.0;
        double renderDistance = 128.0;
        List nearbyPlayers = serverLevel.m_45976_(ServerPlayer.class, new AABB(explosionPos.f_82479_ - renderDistance, explosionPos.f_82480_ - renderDistance, explosionPos.f_82481_ - renderDistance, explosionPos.f_82479_ + renderDistance, explosionPos.f_82480_ + renderDistance, explosionPos.f_82481_ + renderDistance));
        for (ServerPlayer player : nearbyPlayers) {
            serverLevel.m_8624_(player, (ParticleOptions)((SimpleParticleType)ModParticleTypes.GRENADE_EXPLOSION.get()), true, explosionPos.f_82479_, adjustedY, explosionPos.f_82481_, 1, sizeMultiplier, 0.0, 0.0, 0.0);
        }
        for (int burstWave = 0; burstWave < 2; ++burstWave) {
            int particlesInBurst = 8 + burstWave * 4;
            double burstRadius = (double)radius * (0.3 + (double)burstWave * 0.15);
            for (int i = 0; i < particlesInBurst; ++i) {
                double angle = (double)i / (double)particlesInBurst * 2.0 * Math.PI;
                double distance = burstRadius * (0.5 + world.f_46441_.m_188500_() * 0.5);
                double burstX = Math.cos(angle) * distance;
                double burstZ = Math.sin(angle) * distance;
                double burstY = (world.f_46441_.m_188500_() - 0.3) * (double)radius * 0.15;
                double speedX = Math.cos(angle) * (0.2 + world.f_46441_.m_188500_() * 0.3);
                double speedY = 0.15 + world.f_46441_.m_188500_() * 0.25;
                double speedZ = Math.sin(angle) * (0.2 + world.f_46441_.m_188500_() * 0.3);
                for (ServerPlayer player : nearbyPlayers) {
                    serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123744_, true, explosionPos.f_82479_ + burstX, adjustedY + burstY, explosionPos.f_82481_ + burstZ, 1, speedX, speedY, speedZ, 0.08);
                }
            }
        }
        for (int scatter = 0; scatter < 12; ++scatter) {
            double scatterRadius = (double)radius * 1.0;
            double scatterAngle = world.f_46441_.m_188500_() * 2.0 * Math.PI;
            double scatterDistance = world.f_46441_.m_188500_() * scatterRadius;
            double scatterX = Math.cos(scatterAngle) * scatterDistance;
            double scatterZ = Math.sin(scatterAngle) * scatterDistance;
            double scatterY = (world.f_46441_.m_188500_() - 0.5) * (double)radius * 0.25;
            double scatterSpeedX = (world.f_46441_.m_188500_() - 0.5) * 0.5;
            double scatterSpeedY = world.f_46441_.m_188500_() * 0.35;
            double scatterSpeedZ = (world.f_46441_.m_188500_() - 0.5) * 0.5;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, explosionPos.f_82479_ + scatterX, adjustedY + scatterY, explosionPos.f_82481_ + scatterZ, 1, scatterSpeedX, scatterSpeedY, scatterSpeedZ, 0.04);
        }
    }

    private void applyExplosionDamage(Level world, Vec3 explosionPos, float radius, float baseDamage, Entity sourceEntity) {
        float damageRadius = radius * 1.5f;
        int minX = Mth.m_14107_((double)(explosionPos.f_82479_ - (double)damageRadius - 1.0));
        int maxX = Mth.m_14107_((double)(explosionPos.f_82479_ + (double)damageRadius + 1.0));
        int minY = Mth.m_14107_((double)(explosionPos.f_82480_ - (double)damageRadius - 1.0));
        int maxY = Mth.m_14107_((double)(explosionPos.f_82480_ + (double)damageRadius + 1.0));
        int minZ = Mth.m_14107_((double)(explosionPos.f_82481_ - (double)damageRadius - 1.0));
        int maxZ = Mth.m_14107_((double)(explosionPos.f_82481_ + (double)damageRadius + 1.0));
        List entities = world.m_45976_(Entity.class, new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        DamageSource damageSource = ModDamageTypes.Sources.projectile(world.m_9598_(), sourceEntity, (Entity)this.getShooter());
        for (Entity entity : entities) {
            double distance;
            if (entity.m_6128_() || (distance = Math.sqrt(entity.m_20238_(explosionPos))) >= (double)damageRadius) continue;
            float damageMultiplier = 1.0f - (float)(distance / (double)damageRadius);
            float damage = baseDamage * damageMultiplier;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                damage = this.applyBlastProtection(livingEntity, damage);
            }
            if (!(damage > 0.0f)) continue;
            entity.m_6469_(damageSource, damage);
            double deltaX = entity.m_20185_() - explosionPos.f_82479_;
            double deltaY = entity.m_20188_() - explosionPos.f_82480_;
            double deltaZ = entity.m_20189_() - explosionPos.f_82481_;
            double distanceToExplosion = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
            if (distanceToExplosion != 0.0) {
                deltaX /= distanceToExplosion;
                deltaY /= distanceToExplosion;
                deltaZ /= distanceToExplosion;
            } else {
                deltaX = 0.0;
                deltaY = 1.0;
                deltaZ = 0.0;
            }
            double knockbackStrength = Math.max(0.0, (1.0 - distance / (double)damageRadius) * 0.5);
            entity.m_20256_(entity.m_20184_().m_82520_(deltaX * knockbackStrength, deltaY * knockbackStrength, deltaZ * knockbackStrength));
        }
    }

    private float applyBlastProtection(LivingEntity target, float damage) {
        int protectionLevel = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44968_, (LivingEntity)target);
        if (protectionLevel > 0) {
            float reduction = (float)protectionLevel * 0.08f;
            reduction = Math.min(reduction, 0.8f);
            damage *= 1.0f - reduction;
        }
        return damage;
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("BouncesLeft", this.bouncesLeft);
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.bouncesLeft = compound.m_128451_("BouncesLeft");
    }

    @Override
    public void writeSpawnData(FriendlyByteBuf buffer) {
        super.writeSpawnData(buffer);
        buffer.writeInt(this.bouncesLeft);
    }

    @Override
    public void readSpawnData(FriendlyByteBuf buffer) {
        super.readSpawnData(buffer);
        this.bouncesLeft = buffer.readInt();
    }
}

