/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.entity.projectile.ProjectileEntity;
import top.ribs.scguns.entity.projectile.SulfurGasCloudEntity;
import top.ribs.scguns.init.ModEntities;
import top.ribs.scguns.init.ModParticleTypes;
import top.ribs.scguns.item.GunItem;

public class GasGrenadeRoundEntity
extends ProjectileEntity {
    private static final float EXPLOSION_RADIUS = 3.0f;
    private static final float GAS_CLOUD_RADIUS = 6.0f;

    public GasGrenadeRoundEntity(EntityType<? extends ProjectileEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public GasGrenadeRoundEntity(EntityType<? extends ProjectileEntity> entityType, Level worldIn, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, weapon, item, modifiedGun);
    }

    @Override
    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
        if (entity instanceof Player) {
            boolean isBlockingOffHand;
            Player player = (Player)entity;
            ItemStack mainHandItem = player.m_21205_();
            ItemStack offHandItem = player.m_21206_();
            boolean isBlockingMainHand = player.m_21254_() && mainHandItem.m_41720_() instanceof ShieldItem;
            boolean bl = isBlockingOffHand = player.m_21254_() && offHandItem.m_41720_() instanceof ShieldItem;
            if (isBlockingMainHand || isBlockingOffHand) {
                ItemStack shield = isBlockingMainHand ? mainHandItem : offHandItem;
                InteractionHand hand = isBlockingMainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                player.m_36335_().m_41524_(shield.m_41720_(), 100);
                player.m_5810_();
                player.m_9236_().m_7605_((Entity)player, (byte)30);
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12347_, SoundSource.PLAYERS, 1.0f, 0.8f + player.m_9236_().m_213780_().m_188501_() * 0.4f);
                shield.m_41622_(15, (LivingEntity)player, p -> p.m_21190_(hand));
            }
        }
        this.createGasGrenadeExplosion(this, 3.0f, 6.0f);
    }

    @Override
    protected void onHitBlock(BlockState state, BlockPos pos, Direction face, double x, double y, double z) {
        this.createGasGrenadeExplosion(this, 3.0f, 6.0f);
    }

    @Override
    public void onExpired() {
        this.createGasGrenadeExplosion(this, 3.0f, 6.0f);
    }

    private void createGasGrenadeExplosion(Entity entity, float explosionRadius, float gasCloudRadius) {
        Level world = entity.m_9236_();
        if (world.m_5776_()) {
            return;
        }
        Vec3 explosionPos = new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        this.playGasReleaseSound(world, explosionPos);
        this.spawnGasReleaseParticles(world, explosionPos, explosionRadius);
        this.createSulfurGasCloud(world, explosionPos, gasCloudRadius);
    }

    private void playGasReleaseSound(Level world, Vec3 pos) {
        world.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11789_, SoundSource.BLOCKS, 2.0f, 1.0f);
    }

    private void spawnGasReleaseParticles(Level world, Vec3 explosionPos, float radius) {
        ServerLevel serverLevel = (ServerLevel)world;
        BlockPos blockPos = BlockPos.m_274561_((double)explosionPos.f_82479_, (double)explosionPos.f_82480_, (double)explosionPos.f_82481_);
        BlockState blockAtExplosion = world.m_8055_(blockPos);
        double adjustedY = blockAtExplosion.m_60795_() ? explosionPos.f_82480_ + 0.2 : (double)blockPos.m_123342_() + 1.0;
        double renderDistance = 128.0;
        serverLevel.m_45976_(ServerPlayer.class, new AABB(explosionPos.f_82479_ - renderDistance, explosionPos.f_82480_ - renderDistance, explosionPos.f_82481_ - renderDistance, explosionPos.f_82479_ + renderDistance, explosionPos.f_82480_ + renderDistance, explosionPos.f_82481_ + renderDistance));
        for (int i = 0; i < 30; ++i) {
            double angle = world.f_46441_.m_188500_() * 2.0 * Math.PI;
            double distance = world.f_46441_.m_188500_() * (double)radius * 1.5;
            double offsetX = Math.cos(angle) * distance;
            double offsetZ = Math.sin(angle) * distance;
            double offsetY = (world.f_46441_.m_188500_() - 0.5) * (double)radius * 0.5;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.SULFUR_DUST.get()), explosionPos.f_82479_ + offsetX, adjustedY + offsetY, explosionPos.f_82481_ + offsetZ, 3, (world.f_46441_.m_188500_() - 0.5) * 0.4, world.f_46441_.m_188500_() * 0.3, (world.f_46441_.m_188500_() - 0.5) * 0.4, 0.08);
        }
    }

    private void createSulfurGasCloud(Level world, Vec3 center, float radius) {
        if (world.m_5776_()) {
            return;
        }
        SulfurGasCloudEntity gasCloud = new SulfurGasCloudEntity((EntityType)ModEntities.SULFUR_GAS_CLOUD.get(), world, center, radius, 200, 100, 2);
        world.m_7967_((Entity)gasCloud);
    }
}

