/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.projectile;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.entity.projectile.ProjectileEntity;
import top.ribs.scguns.init.ModDamageTypes;
import top.ribs.scguns.init.ModParticleTypes;
import top.ribs.scguns.item.GunItem;

public class HeGrenadeRoundEntity
extends ProjectileEntity {
    private static final float EXPLOSION_RADIUS = 5.0f;

    public HeGrenadeRoundEntity(EntityType<? extends ProjectileEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public HeGrenadeRoundEntity(EntityType<? extends ProjectileEntity> entityType, Level worldIn, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, weapon, item, modifiedGun);
    }

    @Override
    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
        if (entity instanceof Player) {
            boolean isBlockingOffHand;
            Player player = (Player)entity;
            ItemStack mainHandItem = player.m_21205_();
            ItemStack offHandItem = player.m_21206_();
            boolean isBlockingMainHand = player.m_21254_() && mainHandItem.m_41720_() instanceof ShieldItem;
            boolean bl = isBlockingOffHand = player.m_21254_() && offHandItem.m_41720_() instanceof ShieldItem;
            if (isBlockingMainHand || isBlockingOffHand) {
                ItemStack shield = isBlockingMainHand ? mainHandItem : offHandItem;
                InteractionHand hand = isBlockingMainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                player.m_36335_().m_41524_(shield.m_41720_(), 100);
                player.m_5810_();
                player.m_9236_().m_7605_((Entity)player, (byte)30);
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12347_, SoundSource.PLAYERS, 1.0f, 0.8f + player.m_9236_().m_213780_().m_188501_() * 0.4f);
                shield.m_41622_(15, (LivingEntity)player, p -> p.m_21190_(hand));
            }
        }
        float exactDamage = this.getDamage();
        this.createHeGrenadeExplosion(this, 5.0f, exactDamage);
    }

    @Override
    protected void onHitBlock(BlockState state, BlockPos pos, Direction face, double x, double y, double z) {
        float exactDamage = this.getDamage();
        this.createHeGrenadeExplosion(this, 5.0f, exactDamage);
    }

    @Override
    public void onExpired() {
        float exactDamage = this.getDamage();
        this.createHeGrenadeExplosion(this, 5.0f, exactDamage);
    }

    private void createHeGrenadeExplosion(Entity entity, float radius, float damage) {
        Level world = entity.m_9236_();
        if (world.m_5776_()) {
            return;
        }
        Vec3 explosionPos = new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        this.playExplosionSound(world, explosionPos, radius);
        this.spawnExplosionParticles(world, explosionPos, radius);
        this.applyExplosionDamage(world, explosionPos, radius, damage, entity);
    }

    private void playExplosionSound(Level world, Vec3 pos, float radius) {
        float volume = Math.min(3.5f, radius * 0.5f);
        float pitch = 0.9f + world.f_46441_.m_188501_() * 0.3f;
        world.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11913_, SoundSource.BLOCKS, volume, pitch);
    }

    private void spawnExplosionParticles(Level world, Vec3 explosionPos, float radius) {
        ServerLevel serverLevel = (ServerLevel)world;
        double sizeMultiplier = (double)radius / 3.5;
        BlockPos blockPos = BlockPos.m_274561_((double)explosionPos.f_82479_, (double)explosionPos.f_82480_, (double)explosionPos.f_82481_);
        BlockState blockAtExplosion = world.m_8055_(blockPos);
        double adjustedY = !blockAtExplosion.m_60795_() ? (double)blockPos.m_123342_() + 1.0 : explosionPos.f_82480_ + 0.2;
        double renderDistance = 128.0;
        List nearbyPlayers = serverLevel.m_45976_(ServerPlayer.class, new AABB(explosionPos.f_82479_ - renderDistance, explosionPos.f_82480_ - renderDistance, explosionPos.f_82481_ - renderDistance, explosionPos.f_82479_ + renderDistance, explosionPos.f_82480_ + renderDistance, explosionPos.f_82481_ + renderDistance));
        for (ServerPlayer player : nearbyPlayers) {
            serverLevel.m_8624_(player, (ParticleOptions)((SimpleParticleType)ModParticleTypes.GRENADE_EXPLOSION.get()), true, explosionPos.f_82479_, adjustedY, explosionPos.f_82481_, 1, sizeMultiplier, 0.0, 0.0, 0.0);
        }
        for (int burstWave = 0; burstWave < 2; ++burstWave) {
            int particlesInBurst = 6 + burstWave * 3;
            double burstRadius = (double)radius * (0.3 + (double)burstWave * 0.15);
            for (int i = 0; i < particlesInBurst; ++i) {
                double angle = (double)i / (double)particlesInBurst * 2.0 * Math.PI;
                double distance = burstRadius * (0.5 + world.f_46441_.m_188500_() * 0.5);
                double burstX = Math.cos(angle) * distance;
                double burstZ = Math.sin(angle) * distance;
                double burstY = (world.f_46441_.m_188500_() - 0.3) * (double)radius * 0.1;
                double speedX = Math.cos(angle) * (0.2 + world.f_46441_.m_188500_() * 0.3);
                double speedY = 0.15 + world.f_46441_.m_188500_() * 0.25;
                double speedZ = Math.sin(angle) * (0.2 + world.f_46441_.m_188500_() * 0.3);
                for (ServerPlayer player : nearbyPlayers) {
                    serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123744_, true, explosionPos.f_82479_ + burstX, adjustedY + burstY, explosionPos.f_82481_ + burstZ, 1, speedX, speedY, speedZ, 0.08);
                }
            }
        }
        for (int scatter = 0; scatter < 15; ++scatter) {
            double scatterRadius = (double)radius * 1.0;
            double scatterAngle = world.f_46441_.m_188500_() * 2.0 * Math.PI;
            double scatterDistance = world.f_46441_.m_188500_() * scatterRadius;
            double scatterX = Math.cos(scatterAngle) * scatterDistance;
            double scatterZ = Math.sin(scatterAngle) * scatterDistance;
            double scatterY = (world.f_46441_.m_188500_() - 0.5) * (double)radius * 0.25;
            double scatterSpeedX = (world.f_46441_.m_188500_() - 0.5) * 0.5;
            double scatterSpeedY = world.f_46441_.m_188500_() * 0.35;
            double scatterSpeedZ = (world.f_46441_.m_188500_() - 0.5) * 0.5;
            if (world.f_46441_.m_188499_()) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, explosionPos.f_82479_ + scatterX, adjustedY + scatterY, explosionPos.f_82481_ + scatterZ, 1, scatterSpeedX, scatterSpeedY, scatterSpeedZ, 0.08);
                continue;
            }
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, explosionPos.f_82479_ + scatterX, adjustedY + scatterY, explosionPos.f_82481_ + scatterZ, 1, scatterSpeedX, scatterSpeedY, scatterSpeedZ, 0.04);
        }
    }

    private void applyExplosionDamage(Level world, Vec3 explosionPos, float radius, float baseDamage, Entity sourceEntity) {
        float damageRadius = radius * 2.0f;
        int minX = Mth.m_14107_((double)(explosionPos.f_82479_ - (double)damageRadius - 1.0));
        int maxX = Mth.m_14107_((double)(explosionPos.f_82479_ + (double)damageRadius + 1.0));
        int minY = Mth.m_14107_((double)(explosionPos.f_82480_ - (double)damageRadius - 1.0));
        int maxY = Mth.m_14107_((double)(explosionPos.f_82480_ + (double)damageRadius + 1.0));
        int minZ = Mth.m_14107_((double)(explosionPos.f_82481_ - (double)damageRadius - 1.0));
        int maxZ = Mth.m_14107_((double)(explosionPos.f_82481_ + (double)damageRadius + 1.0));
        List entities = world.m_45976_(Entity.class, new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        DamageSource damageSource = ModDamageTypes.Sources.projectile(world.m_9598_(), sourceEntity, (Entity)this.getShooter());
        for (Entity entity : entities) {
            float damage;
            if (entity.m_6128_()) continue;
            double distance = Math.sqrt(entity.m_20238_(explosionPos));
            double maxDamageDistance = radius;
            double maxDistance = (double)radius * 2.0;
            if (distance >= maxDistance) continue;
            if (distance <= maxDamageDistance) {
                damage = baseDamage;
            } else {
                float falloffMultiplier = 1.0f - (float)((distance - maxDamageDistance) / (maxDistance - maxDamageDistance));
                damage = baseDamage * falloffMultiplier;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                damage = this.applyBlastProtection(livingEntity, damage);
            }
            if (!(damage > 0.0f)) continue;
            entity.m_6469_(damageSource, damage);
            double deltaX = entity.m_20185_() - explosionPos.f_82479_;
            double deltaY = entity.m_20188_() - explosionPos.f_82480_;
            double deltaZ = entity.m_20189_() - explosionPos.f_82481_;
            double distanceToExplosion = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
            if (distanceToExplosion != 0.0) {
                deltaX /= distanceToExplosion;
                deltaY /= distanceToExplosion;
                deltaZ /= distanceToExplosion;
            } else {
                deltaX = 0.0;
                deltaY = 1.0;
                deltaZ = 0.0;
            }
            double knockbackStrength = Math.max(0.0, (1.0 - distance / maxDistance) * 0.4);
            entity.m_20256_(entity.m_20184_().m_82520_(deltaX * knockbackStrength, deltaY * knockbackStrength, deltaZ * knockbackStrength));
        }
    }

    private float applyBlastProtection(LivingEntity target, float damage) {
        int protectionLevel = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44968_, (LivingEntity)target);
        if (protectionLevel > 0) {
            float reduction = (float)protectionLevel * 0.08f;
            reduction = Math.min(reduction, 0.8f);
            damage *= 1.0f - reduction;
        }
        return damage;
    }
}

