/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.projectile;

import com.mrcrayfish.framework.network.message.IMessage;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.entity.projectile.ProjectileEntity;
import top.ribs.scguns.init.ModDamageTypes;
import top.ribs.scguns.init.ModTags;
import top.ribs.scguns.interfaces.IDamageable;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.S2CMessageBlood;
import top.ribs.scguns.network.message.S2CMessageProjectileHitBlock;
import top.ribs.scguns.particles.TrailData;

public class ShatterRoundProjectileEntity
extends ProjectileEntity {
    private static final int SHRAPNEL_COUNT = 20;
    private static final float SHRAPNEL_RANGE = 5.0f;
    private static final float SHRAPNEL_DAMAGE_MULTIPLIER = 0.3f;
    private boolean hasDetonated = false;

    public ShatterRoundProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public ShatterRoundProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, weapon, item, modifiedGun);
    }

    @Override
    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
        if (this.hasDetonated) {
            return;
        }
        super.onHitEntity(entity, hitVec, startVec, endVec, headshot);
        this.explode(hitVec);
    }

    @Override
    protected void onHitBlock(BlockState state, BlockPos pos, Direction face, double x, double y, double z) {
        boolean isOpen;
        if (this.hasDetonated) {
            return;
        }
        PacketHandler.getPlayChannel().sendToTrackingChunk(() -> this.m_9236_().m_46745_(pos), (IMessage)new S2CMessageProjectileHitBlock(x, y, z, pos, face));
        Block block = state.m_60734_();
        this.primeTNT(state, pos);
        if (block instanceof DoorBlock && !(isOpen = ((Boolean)state.m_61143_((Property)DoorBlock.f_52727_)).booleanValue())) {
            this.m_9236_().m_7731_(pos, (BlockState)state.m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf(true)), 10);
            this.m_9236_().m_5594_(null, pos, SoundEvents.f_12627_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (block instanceof IDamageable) {
            ((IDamageable)block).onBlockDamaged(this.m_9236_(), state, pos, this, this.getDamage(), (int)Math.ceil((double)this.getDamage() / 2.0) + 1);
        }
        this.explode(new Vec3(x, y, z));
    }

    @Override
    protected void onExpired() {
        if (!this.hasDetonated) {
            this.explode(this.m_20182_());
        }
    }

    private void explode(Vec3 explosionPos) {
        if (this.hasDetonated || this.m_9236_().m_5776_()) {
            return;
        }
        this.hasDetonated = true;
        this.createCentralExplosion(explosionPos);
        this.createExplosionEffects(explosionPos);
        this.fireShrapnel(explosionPos);
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    private void createCentralExplosion(Vec3 pos) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)this.m_9236_();
        this.m_9236_().m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11983_, SoundSource.NEUTRAL, 2.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
        this.m_9236_().m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_144050_, SoundSource.NEUTRAL, 1.5f, 1.2f + this.f_19796_.m_188501_() * 0.3f);
        for (int i = 0; i < 40; ++i) {
            double angle = this.f_19796_.m_188500_() * Math.PI * 2.0;
            double pitch = (this.f_19796_.m_188500_() - 0.5) * Math.PI * 0.5;
            double speed = 0.3 + this.f_19796_.m_188500_() * 0.4;
            double offsetX = Math.cos(angle) * Math.cos(pitch) * speed;
            double offsetY = Math.sin(pitch) * speed;
            double offsetZ = Math.sin(angle) * Math.cos(pitch) * speed;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, offsetX, offsetY, offsetZ, 0.02);
        }
        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.1, 0.1, 0.1, 0.0);
    }

    private void createExplosionEffects(Vec3 pos) {
        this.m_9236_().m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_144091_, SoundSource.NEUTRAL, 1.0f, 1.0f + this.f_19796_.m_188501_() * 0.4f);
        ServerLevel serverLevel = (ServerLevel)this.m_9236_();
    }

    private void fireShrapnel(Vec3 origin) {
        float shrapnelDamage = this.getDamage() * 0.3f;
        for (int i = 0; i < 20; ++i) {
            Vec3 direction = this.generateRandomDirection();
            Vec3 endPos = origin.m_82549_(direction.m_82490_(5.0));
            this.traceShrapnelRay(origin, endPos, shrapnelDamage, i);
        }
    }

    private Vec3 generateRandomDirection() {
        float z;
        float y;
        float x;
        float lengthSquared;
        while ((lengthSquared = (x = this.f_19796_.m_188501_() * 2.0f - 1.0f) * x + (y = this.f_19796_.m_188501_() * 2.0f - 1.0f) * y + (z = this.f_19796_.m_188501_() * 2.0f - 1.0f) * z) > 1.0f || lengthSquared < 0.001f) {
        }
        float length = Mth.m_14116_((float)lengthSquared);
        return new Vec3((double)(x / length), (double)(y / length), (double)(z / length));
    }

    private void traceShrapnelRay(Vec3 start, Vec3 end, float damage, int rayIndex) {
        BlockHitResult blockHit;
        List<Entity> hitEntities = this.findEntitiesAlongRay(start, end);
        Vec3 traceEnd = end;
        boolean hitSomething = false;
        Entity closestEntity = null;
        double closestDistance = Double.MAX_VALUE;
        Vec3 closestHitPos = null;
        for (Entity entity : hitEntities) {
            double distance;
            Vec3 hitPos;
            if (!this.isValidShrapnelTarget(entity) || (hitPos = this.getEntityHitPosition(entity, start, end)) == null || !((distance = start.m_82557_(hitPos)) < closestDistance)) continue;
            closestDistance = distance;
            closestEntity = entity;
            closestHitPos = hitPos;
        }
        if (closestEntity != null) {
            this.damageEntityWithShrapnel(closestEntity, closestHitPos, damage);
            traceEnd = closestHitPos;
            hitSomething = true;
        }
        if (!hitSomething && (blockHit = this.m_9236_().m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this))).m_6662_() != HitResult.Type.MISS) {
            traceEnd = blockHit.m_82450_();
        }
        this.createShrapnelTracer(start, traceEnd);
    }

    private List<Entity> findEntitiesAlongRay(Vec3 start, Vec3 end) {
        AABB searchBox = new AABB(start, end).m_82400_(1.0);
        return this.m_9236_().m_6249_((Entity)this, searchBox, entity -> entity != null && entity.m_6087_() && !entity.m_5833_() && entity != this.shooter && entity.m_19879_() != this.shooterId);
    }

    private boolean isValidShrapnelTarget(Entity entity) {
        if (entity == this.shooter || entity.m_19879_() == this.shooterId) {
            return false;
        }
        if (this.shooter instanceof Player && entity instanceof Player && this.shooter.m_20148_().equals(entity.m_20148_())) {
            return false;
        }
        if (this.shooter != null) {
            double distance = entity.m_20182_().m_82554_(this.shooter.m_20182_());
            return !(distance < 1.0);
        }
        return true;
    }

    private Vec3 getEntityHitPosition(Entity entity, Vec3 start, Vec3 end) {
        AABB boundingBox = entity.m_20191_();
        return boundingBox.m_82371_(start, end).orElse(null);
    }

    private void damageEntityWithShrapnel(Entity entity, Vec3 hitPos, float damage) {
        ResourceLocation advantage = this.getProjectile().getAdvantage();
        damage *= this.advantageMultiplier(entity);
        if (entity instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)entity;
            damage = this.applyProjectileProtection(livingTarget, damage);
            damage = this.calculateArmorBypassDamage(livingTarget, damage);
        }
        DamageSource source = ModDamageTypes.Sources.projectile(this.m_9236_().m_9598_(), this, this.shooter);
        if (!entity.m_6095_().m_204039_(ModTags.Entities.GHOST) || advantage.equals((Object)ModTags.Entities.UNDEAD.f_203868_())) {
            entity.m_6469_(source, damage);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                ResourceLocation effectLocation = this.projectile.getImpactEffect();
                if (effectLocation != null) {
                    MobEffect effect;
                    float effectChance = this.projectile.getImpactEffectChance();
                    if (this.f_19796_.m_188501_() < effectChance && (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectLocation)) != null) {
                        livingEntity.m_7292_(new MobEffectInstance(effect, this.projectile.getImpactEffectDuration(), this.projectile.getImpactEffectAmplifier()));
                    }
                }
            }
        }
        PacketHandler.getPlayChannel().sendToTracking(() -> entity, (IMessage)new S2CMessageBlood(hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, entity.m_6095_()));
        entity.f_19802_ = Math.min(entity.f_19802_, 3);
    }

    private void createShrapnelTracer(Vec3 start, Vec3 end) {
        ServerLevel serverLevel = (ServerLevel)this.m_9236_();
        Vec3 direction = end.m_82546_(start);
        double distance = direction.m_82553_();
        if (distance < 0.1) {
            return;
        }
        direction = direction.m_82541_();
        boolean isEnchanted = this.getWeapon() != null && this.getWeapon().m_41793_();
        TrailData trailData = new TrailData(isEnchanted);
        int maxSegments = Math.min(12, (int)(distance * 1.5));
        for (int i = 1; i <= maxSegments; ++i) {
            double progress = (double)i / (double)maxSegments;
            Vec3 particlePos = start.m_82549_(direction.m_82490_(distance * progress));
            double densityFactor = Math.max(0.2, 1.0 - progress * 0.8);
            int particlesAtThisPoint = Math.max(1, (int)(4.0 * densityFactor));
            double spreadRadius = 0.02 + progress * 0.1;
            for (int j = 0; j < particlesAtThisPoint; ++j) {
                double offsetX = (this.f_19796_.m_188500_() - 0.5) * spreadRadius;
                double offsetY = (this.f_19796_.m_188500_() - 0.5) * spreadRadius;
                double offsetZ = (this.f_19796_.m_188500_() - 0.5) * spreadRadius;
                serverLevel.m_8767_((ParticleOptions)trailData, particlePos.f_82479_ + offsetX, particlePos.f_82480_ + offsetY, particlePos.f_82481_ + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void onProjectileTick() {
        if (this.m_9236_().f_46443_ && !this.hasDetonated && this.f_19797_ % 3 == 0) {
            double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.1;
            double offsetY = (this.f_19796_.m_188500_() - 0.5) * 0.1;
            double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.1;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 0.0, 0.0, 0.0);
        }
    }
}

