/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.raid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.ribs.scguns.Config;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.config.GunnerMobSpawner;
import top.ribs.scguns.config.RaidConfig;
import top.ribs.scguns.entity.ai.GunAttackGoal;
import top.ribs.scguns.entity.player.PlayerGunProgression;
import top.ribs.scguns.entity.raid.ActiveRaid;
import top.ribs.scguns.entity.raid.RaidSaveData;
import top.ribs.scguns.item.GunItem;

@Mod.EventBusSubscriber(modid="scguns", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RaidManager {
    private static final UUID BOSS_HEALTH_MODIFIER_UUID = UUID.fromString("a1b2c3d4-e5f6-7890-abcd-ef1234567890");
    private static final UUID MOUNT_HEALTH_MODIFIER_UUID = UUID.fromString("b2c3d4e5-f6a7-8901-bcde-f12345678901");
    private static final long NIGHT_START = 13000L;
    private static final long RAID_SPAWN_TIME = 18000L;
    private static final int SAVE_INTERVAL = 100;
    private static final Map<ResourceLocation, RaidManager> INSTANCES = new HashMap<ResourceLocation, RaidManager>();
    private UUID currentActiveRaidId = null;
    private static final Map<UUID, ActiveRaid> activeRaids = new HashMap<UUID, ActiveRaid>();
    private boolean needsRestore = true;

    public static RaidManager get(ServerLevel level) {
        ResourceLocation dimension = level.m_46472_().m_135782_();
        return INSTANCES.computeIfAbsent(dimension, k -> new RaidManager());
    }

    public boolean hasActiveRaid() {
        if (this.currentActiveRaidId == null) {
            return false;
        }
        ActiveRaid raid = activeRaids.get(this.currentActiveRaidId);
        return raid != null && raid.isActive();
    }

    public static boolean hasActiveRaidInDimension(ServerLevel level) {
        RaidManager manager = RaidManager.get(level);
        return manager.hasActiveRaid();
    }

    @Nullable
    public ActiveRaid getCurrentActiveRaid() {
        if (this.currentActiveRaidId == null) {
            return null;
        }
        return activeRaids.get(this.currentActiveRaidId);
    }

    public static void surrenderRaid(ServerLevel level) {
        RaidManager manager = RaidManager.get(level);
        ActiveRaid raid = manager.getCurrentActiveRaid();
        if (raid != null && raid.isActive()) {
            Entity mount;
            LivingEntity boss = raid.getBoss();
            if (boss != null && boss.m_6084_()) {
                boss.m_146870_();
            }
            if ((mount = raid.getMount()) != null && mount.m_6084_()) {
                mount.m_146870_();
            }
            for (UUID henchmanUUID : raid.getHenchmenUUIDs()) {
                Entity henchman = level.m_8791_(henchmanUUID);
                if (henchman == null || !henchman.m_6084_()) continue;
                henchman.m_146870_();
            }
            raid.announceToNearbyPlayers((Component)Component.m_237115_((String)"raid.scguns.surrendered").m_130940_(ChatFormatting.YELLOW), 64.0);
            if (raid.getBossBar() != null) {
                raid.getBossBar().m_8321_(false);
                raid.getBossBar().m_7706_();
            }
            raid.setActive(false);
            manager.currentActiveRaidId = null;
            activeRaids.remove(raid.getRaidId());
            RaidSaveData saveData = RaidSaveData.get(level);
            saveData.removeActiveRaid(raid.getRaidId());
        }
    }

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load event) {
        ServerLevel serverLevel;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (serverLevel = (ServerLevel)levelAccessor) == serverLevel.m_7654_().m_129783_()) {
            RaidManager manager = RaidManager.get(serverLevel);
            if (manager.needsRestore) {
                manager.restoreRaidsFromSave(serverLevel);
                manager.needsRestore = false;
            }
        }
    }

    private void restoreRaidsFromSave(ServerLevel level) {
        RaidSaveData saveData = RaidSaveData.get(level);
        Collection<RaidSaveData.ActiveRaidData> savedRaids = saveData.getActiveRaidData();
        saveData.cleanupInvalidRaids(level);
        for (RaidSaveData.ActiveRaidData data : savedRaids) {
            RaidConfig.RaidData config = RaidConfig.getRaidById(data.configRaidId());
            if (config == null) continue;
            ActiveRaid raid = ActiveRaid.restore(data, config, level);
            activeRaids.put(raid.getRaidId(), raid);
            if (this.currentActiveRaidId == null && raid.isActive()) {
                this.currentActiveRaidId = raid.getRaidId();
            }
            raid.updateBossBarPlayers();
        }
    }

    public void startRaidFromPlayer(RaidConfig.RaidData config, ServerLevel level, ServerPlayer player) {
        if (this.hasActiveRaid()) {
            return;
        }
        Vec3 playerPos = player.m_20182_();
        Vec3 spawnPos = this.findRaidSpawnLocation(level, playerPos);
        if (spawnPos != null) {
            this.startRaid(config, level, spawnPos);
        }
    }

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Level level = event.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        RaidManager manager = RaidManager.get(serverLevel);
        manager.tick(serverLevel);
    }

    public void tick(ServerLevel level) {
        this.tickActiveRaids(level);
        if (!((Boolean)Config.COMMON.raids.raidsEnabled.get()).booleanValue()) {
            return;
        }
        this.checkForNightlyRaidSpawn(level);
        if (level.m_46467_() % 100L == 0L) {
            this.saveActiveRaids(level);
            level.m_8895_().m_78151_();
        }
    }

    private void tickActiveRaids(ServerLevel level) {
        Iterator<Map.Entry<UUID, ActiveRaid>> iterator = activeRaids.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, ActiveRaid> entry = iterator.next();
            ActiveRaid raid = entry.getValue();
            if (!raid.isActive()) {
                if (raid.getRaidId().equals(this.currentActiveRaidId)) {
                    this.currentActiveRaidId = null;
                }
                RaidSaveData saveData = RaidSaveData.get(level);
                saveData.removeActiveRaid(raid.getRaidId());
                iterator.remove();
                continue;
            }
            raid.tick();
            if (!raid.shouldSpawnHenchmen()) continue;
            this.spawnHenchmen(raid, level);
            raid.resetSpawnTimer();
        }
    }

    private void saveActiveRaids(ServerLevel level) {
        RaidSaveData saveData = RaidSaveData.get(level);
        for (ActiveRaid raid : activeRaids.values()) {
            if (!raid.isActive()) continue;
            saveData.saveActiveRaid(raid);
        }
    }

    private void checkForNightlyRaidSpawn(ServerLevel level) {
        RaidSaveData.ScheduledRaidData scheduled;
        if (level.m_6042_().m_63967_()) {
            return;
        }
        ResourceLocation dimension = level.m_46472_().m_135782_();
        long dayTime = level.m_46468_() % 24000L;
        long currentDay = level.m_46468_() / 24000L;
        RaidSaveData saveData = RaidSaveData.get(level);
        if (dayTime >= 13000L && dayTime < 13020L) {
            if (this.hasActiveRaid()) {
                return;
            }
            scheduled = saveData.getScheduledRaid(dimension);
            if (scheduled != null && scheduled.scheduledDay() < currentDay) {
                saveData.removeScheduledRaid(dimension);
                scheduled = null;
            }
            if (scheduled != null) {
                return;
            }
            if (!((Boolean)Config.COMMON.raids.raidsEnabled.get()).booleanValue()) {
                return;
            }
            if (dayTime == 13000L) {
                float raidChance = ((Double)Config.COMMON.raids.nightlyRaidChance.get()).floatValue();
                float roll = level.f_46441_.m_188501_();
                if (roll < raidChance) {
                    this.scheduleRaidForTonight(level, dimension, currentDay, saveData);
                }
            }
        }
        if (dayTime >= 18000L && dayTime < 18020L) {
            if (this.hasActiveRaid()) {
                return;
            }
            scheduled = saveData.getScheduledRaid(dimension);
            if (scheduled == null) {
                return;
            }
            if (scheduled.scheduledDay() != currentDay) {
                saveData.removeScheduledRaid(dimension);
                return;
            }
            ServerPlayer player = level.m_7654_().m_6846_().m_11259_(scheduled.targetPlayerUUID());
            if (player == null || player.m_213877_() || player.m_5833_()) {
                saveData.removeScheduledRaid(dimension);
                return;
            }
            Vec3 playerPos = player.m_20182_();
            Vec3 spawnPos = this.findRaidSpawnLocation(level, playerPos);
            if (spawnPos == null) {
                return;
            }
            RaidConfig.RaidData config = RaidConfig.getRaidById(scheduled.raidId());
            if (config == null) {
                saveData.removeScheduledRaid(dimension);
                return;
            }
            this.startRaid(config, level, spawnPos);
            saveData.removeScheduledRaid(dimension);
        }
    }

    private void scheduleRaidForTonight(ServerLevel level, ResourceLocation dimension, long currentDay, RaidSaveData saveData) {
        if (this.hasActiveRaid()) {
            return;
        }
        ArrayList<ServerPlayer> validPlayers = new ArrayList<ServerPlayer>();
        for (ServerPlayer player : level.m_6907_()) {
            if (player.m_5833_() || player.m_7500_()) continue;
            validPlayers.add(player);
        }
        if (validPlayers.isEmpty()) {
            return;
        }
        ServerPlayer targetPlayer = (ServerPlayer)validPlayers.get(level.f_46441_.m_188503_(validPlayers.size()));
        PlayerGunProgression progression = PlayerGunProgression.get((Player)targetPlayer);
        int raidLevel = progression.getCurrentRaidLevel();
        if (raidLevel == 0) {
            return;
        }
        RaidConfig.RaidData selectedRaid = this.selectRaidForLevel(raidLevel, level.f_46441_);
        if (selectedRaid == null) {
            return;
        }
        saveData.scheduleRaid(dimension, targetPlayer, selectedRaid.raidId(), currentDay);
        targetPlayer.m_213846_((Component)Component.m_237115_((String)"raid.scguns.warning"));
    }

    @Nullable
    private RaidConfig.RaidData selectRaidForLevel(int playerRaidLevel, RandomSource random) {
        List<RaidConfig.RaidData> availableRaids = RaidConfig.getRaidsForLevel(playerRaidLevel);
        if (availableRaids.isEmpty()) {
            return null;
        }
        if (availableRaids.size() == 1) {
            return availableRaids.get(0);
        }
        List<RaidConfig.RaidData> highestLevelRaids = RaidConfig.getRaidsAtLevel(playerRaidLevel);
        float roll = random.m_188501_();
        if (!highestLevelRaids.isEmpty() && roll < 0.6f) {
            return highestLevelRaids.get(random.m_188503_(highestLevelRaids.size()));
        }
        return availableRaids.get(random.m_188503_(availableRaids.size()));
    }

    @Nullable
    private Vec3 findRaidSpawnLocation(ServerLevel level, Vec3 center) {
        RandomSource random = level.m_213780_();
        int playerY = (int)center.f_82480_;
        boolean isUnderground = playerY < 50;
        for (int attempt = 0; attempt < 15; ++attempt) {
            BlockPos groundPos;
            double angle = random.m_188500_() * Math.PI * 2.0;
            double distance = 25.0 + random.m_188500_() * 15.0;
            double x = center.f_82479_ + Math.cos(angle) * distance;
            double z = center.f_82481_ + Math.sin(angle) * distance;
            BlockPos pos = new BlockPos((int)x, playerY, (int)z);
            if (isUnderground) {
                groundPos = this.findNearestValidCaveSpawn(level, pos, playerY);
                if (groundPos == null) {
                    continue;
                }
            } else {
                groundPos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos);
            }
            if (!level.m_8055_(groundPos.m_7495_()).m_280296_() || !level.m_8055_(groundPos).m_60795_() || !level.m_8055_(groundPos.m_7494_()).m_60795_() || !level.m_8055_(groundPos.m_6630_(2)).m_60795_()) continue;
            return new Vec3((double)groundPos.m_123341_() + 0.5, (double)groundPos.m_123342_(), (double)groundPos.m_123343_() + 0.5);
        }
        return null;
    }

    @Nullable
    private BlockPos findNearestValidCaveSpawn(ServerLevel level, BlockPos center, int playerY) {
        for (int yOffset = -5; yOffset <= 5; ++yOffset) {
            BlockPos checkPos = new BlockPos(center.m_123341_(), playerY + yOffset, center.m_123343_());
            if (!level.m_8055_(checkPos.m_7495_()).m_280296_() || !level.m_8055_(checkPos).m_60795_() || !level.m_8055_(checkPos.m_7494_()).m_60795_() || !level.m_8055_(checkPos.m_6630_(2)).m_60795_()) continue;
            int airCount = 0;
            for (int i = 0; i < 4; ++i) {
                if (!level.m_8055_(checkPos.m_6630_(i)).m_60795_()) continue;
                ++airCount;
            }
            if (airCount < 3) continue;
            return checkPos;
        }
        return null;
    }

    public void startRaid(RaidConfig.RaidData config, ServerLevel level, Vec3 spawnPos) {
        MutableComponent announcementComponent;
        Entity mount;
        Mob boss;
        if (this.hasActiveRaid()) {
            return;
        }
        ServerPlayer targetPlayer = this.findNearestPlayer(level, spawnPos);
        long startTime = level.m_46467_();
        Integer raidLevel = config.raidLevel();
        ActiveRaid raid = new ActiveRaid(raidLevel, config, level, spawnPos, startTime);
        if (targetPlayer != null) {
            raid.setTargetPlayer(targetPlayer.m_20148_());
        }
        if ((boss = this.spawnBoss(raid, level, spawnPos)) == null) {
            return;
        }
        raid.setBossUUID(boss.m_20148_());
        if (targetPlayer != null && boss instanceof PathfinderMob) {
            PathfinderMob pathfinder = (PathfinderMob)boss;
            pathfinder.m_6710_((LivingEntity)targetPlayer);
        }
        if (config.boss().mount() != null && (mount = boss.m_20202_()) != null) {
            raid.setMountUUID(mount.m_20148_());
        }
        raid.setBossConfirmed(true);
        activeRaids.put(raid.getRaidId(), raid);
        this.currentActiveRaidId = raid.getRaidId();
        String announcement = config.spawnConditions().announcementMessage();
        if (announcement.startsWith("translation:")) {
            String translationKey = announcement.substring(12);
            announcementComponent = Component.m_237115_((String)translationKey);
        } else {
            announcementComponent = Component.m_237113_((String)announcement);
        }
        raid.announceToNearbyPlayers((Component)announcementComponent, config.spawnConditions().searchRadius());
        this.spawnHenchmen(raid, level);
        raid.resetSpawnTimer();
        RaidSaveData saveData = RaidSaveData.get(level);
        saveData.saveActiveRaid(raid);
    }

    @Nullable
    private ServerPlayer findNearestPlayer(ServerLevel level, Vec3 pos) {
        ServerPlayer nearest = null;
        double nearestDist = Double.MAX_VALUE;
        for (ServerPlayer player : level.m_6907_()) {
            double dist;
            if (player.m_5833_() || player.m_7500_() || !((dist = player.m_20182_().m_82554_(pos)) < nearestDist)) continue;
            nearestDist = dist;
            nearest = player;
        }
        return nearest;
    }

    @Nullable
    private Mob spawnBoss(ActiveRaid raid, ServerLevel level, Vec3 spawnPos) {
        Mob mount;
        RaidConfig.BossData bossData = raid.getConfig().boss();
        EntityType<?> entityType = bossData.entityType();
        Entity entity = entityType.m_20615_((Level)level);
        if (!(entity instanceof Mob)) {
            return null;
        }
        Mob boss = (Mob)entity;
        boss.m_6034_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_);
        if (bossData.customName() != null) {
            MutableComponent nameComponent;
            if (bossData.customName().startsWith("translation:")) {
                String translationKey = bossData.customName().substring(12);
                nameComponent = Component.m_237115_((String)translationKey);
            } else {
                nameComponent = Component.m_237113_((String)bossData.customName());
            }
            boss.m_6593_((Component)nameComponent);
            boss.m_20340_(true);
        }
        this.applyHealthConfig(boss, bossData.healthConfig(), BOSS_HEALTH_MODIFIER_UUID);
        this.applyEffects(boss, bossData.effects());
        if (bossData.weapon() != null) {
            ItemStack weaponStack = this.createModifiedGun(boss, bossData.weapon().item());
            if (bossData.weapon().nbt() != null) {
                CompoundTag existingTag = weaponStack.m_41784_();
                existingTag.m_128391_(bossData.weapon().nbt());
            }
            boss.m_8061_(EquipmentSlot.MAINHAND, weaponStack);
            boss.m_21409_(EquipmentSlot.MAINHAND, bossData.weapon().dropChance());
        }
        for (RaidConfig.ArmorEntry armorEntry : bossData.armor()) {
            EquipmentSlot slot;
            if ((slot = (switch (armorEntry.slot()) {
                case "head" -> EquipmentSlot.HEAD;
                case "chest" -> EquipmentSlot.CHEST;
                case "legs" -> EquipmentSlot.LEGS;
                case "feet" -> EquipmentSlot.FEET;
                default -> null;
            })) == null) continue;
            ItemStack armorStack = new ItemStack((ItemLike)armorEntry.item());
            if (armorEntry.nbt() != null) {
                armorStack.m_41751_(armorEntry.nbt().m_6426_());
            }
            boss.m_8061_(slot, armorStack);
            boss.m_21409_(slot, armorEntry.dropChance());
        }
        boss.m_20049_("RaidBoss");
        boss.m_20049_("RaidMember_" + raid.getRaidId());
        boss.m_20049_("MobGunner");
        boss.m_20049_("AI_" + bossData.aiType().name());
        boss.m_21530_();
        if (boss instanceof PathfinderMob) {
            PathfinderMob pathfinderBoss = (PathfinderMob)boss;
            ItemStack heldItem = boss.m_21205_();
            if (heldItem.m_41720_() instanceof GunItem) {
                pathfinderBoss.f_21345_.m_25352_(2, new GunAttackGoal<PathfinderMob>(pathfinderBoss, heldItem, 1.2f, bossData.aiType(), bossData.aiDifficulty()));
            }
            GunnerMobSpawner.extendFollowRange(pathfinderBoss);
            if (boss instanceof AbstractPiglin) {
                ServerPlayer targetPlayer;
                AbstractPiglin abstractPiglin = (AbstractPiglin)boss;
                abstractPiglin.m_34670_(true);
                if (boss instanceof Piglin) {
                    Piglin piglin = (Piglin)boss;
                    piglin.m_21561_(true);
                }
                if ((targetPlayer = this.findNearestPlayer(level, spawnPos)) != null) {
                    try {
                        Brain brain = abstractPiglin.m_6274_();
                        brain.m_21936_(MemoryModuleType.f_26334_);
                        brain.m_21879_(MemoryModuleType.f_26334_, (Object)targetPlayer.m_20148_());
                        brain.m_21936_(MemoryModuleType.f_26335_);
                        brain.m_21879_(MemoryModuleType.f_26335_, (Object)true);
                        brain.m_21879_(MemoryModuleType.f_26372_, (Object)targetPlayer);
                        brain.m_21936_(MemoryModuleType.f_26368_);
                        brain.m_21879_(MemoryModuleType.f_26368_, (Object)targetPlayer);
                        abstractPiglin.m_6710_((LivingEntity)targetPlayer);
                        abstractPiglin.m_6703_((LivingEntity)targetPlayer);
                    }
                    catch (Exception e) {
                        abstractPiglin.m_6710_((LivingEntity)targetPlayer);
                    }
                }
            }
        }
        level.m_7967_((Entity)boss);
        RaidConfig.MountData mountData = bossData.mount();
        if (mountData != null && (mount = this.spawnMount(raid, mountData, level, spawnPos)) != null) {
            boss.m_7998_((Entity)mount, true);
        }
        return boss;
    }

    @Nullable
    private Mob spawnMount(ActiveRaid raid, RaidConfig.MountData mountData, ServerLevel level, Vec3 spawnPos) {
        EntityType<?> mountType = mountData.entityType();
        Entity entity = mountType.m_20615_((Level)level);
        if (!(entity instanceof Mob)) {
            return null;
        }
        Mob mount = (Mob)entity;
        mount.m_6034_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_);
        this.applyHealthConfig(mount, mountData.healthConfig(), MOUNT_HEALTH_MODIFIER_UUID);
        this.applyEffects(mount, mountData.effects());
        for (RaidConfig.ArmorEntry armorEntry : mountData.armor()) {
            EquipmentSlot slot;
            if ((slot = (switch (armorEntry.slot()) {
                case "head" -> EquipmentSlot.HEAD;
                case "chest" -> EquipmentSlot.CHEST;
                case "legs" -> EquipmentSlot.LEGS;
                case "feet" -> EquipmentSlot.FEET;
                default -> null;
            })) == null) continue;
            ItemStack armorStack = new ItemStack((ItemLike)armorEntry.item());
            if (armorEntry.nbt() != null) {
                armorStack.m_41751_(armorEntry.nbt().m_6426_());
            }
            mount.m_8061_(slot, armorStack);
            mount.m_21409_(slot, armorEntry.dropChance());
        }
        mount.m_20049_("RaidMount");
        mount.m_20049_("RaidMember_" + raid.getRaidId());
        mount.m_20049_("MobGunner");
        mount.m_21530_();
        if (!mountData.mountDropsLoot()) {
            mount.m_20049_("NoLootDrop");
        }
        level.m_7967_((Entity)mount);
        return mount;
    }

    private void spawnHenchmen(ActiveRaid raid, ServerLevel level) {
        RaidConfig.HenchmenData henchmenData = raid.getConfig().henchmen();
        LivingEntity boss = raid.getBoss();
        if (boss == null || !boss.m_6084_()) {
            return;
        }
        Vec3 bossPos = boss.m_20182_();
        for (int i = 0; i < henchmenData.spawnAttemptsPerWave() && raid.canSpawnMoreHenchmen(); ++i) {
            Mob henchman;
            Vec3 spawnPos;
            RaidConfig.HenchmanType type = henchmenData.selectRandomType(level.m_213780_());
            if (type == null || (spawnPos = this.findHenchmanSpawnPos(level, bossPos, henchmenData.spawnRadius())) == null || (henchman = this.spawnHenchman(raid, type, level, spawnPos)) == null) continue;
            raid.addHenchman(henchman.m_20148_());
        }
    }

    @Nullable
    private Vec3 findHenchmanSpawnPos(ServerLevel level, Vec3 center, int radius) {
        RandomSource random = level.m_213780_();
        for (int attempt = 0; attempt < 10; ++attempt) {
            double z;
            double angle = random.m_188500_() * Math.PI * 2.0;
            double distance = random.m_188500_() * (double)radius;
            double x = center.f_82479_ + Math.cos(angle) * distance;
            BlockPos pos = new BlockPos((int)x, (int)center.f_82480_, (int)(z = center.f_82481_ + Math.sin(angle) * distance));
            BlockPos groundPos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos);
            if (!level.m_8055_(groundPos.m_7495_()).m_280296_() || !level.m_8055_(groundPos).m_60795_() || !level.m_8055_(groundPos.m_7494_()).m_60795_()) continue;
            return new Vec3((double)groundPos.m_123341_() + 0.5, (double)groundPos.m_123342_(), (double)groundPos.m_123343_() + 0.5);
        }
        return null;
    }

    private Mob spawnHenchman(ActiveRaid raid, RaidConfig.HenchmanType type, ServerLevel level, Vec3 spawnPos) {
        EntityType<?> entityType = type.entityType();
        Entity entity = entityType.m_20615_((Level)level);
        if (!(entity instanceof Mob)) {
            return null;
        }
        Mob henchman = (Mob)entity;
        henchman.m_6034_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_);
        this.applyHealthConfig(henchman, type.healthConfig(), UUID.randomUUID());
        this.applyEffects(henchman, type.effects());
        henchman.m_20049_("RaidHenchman");
        henchman.m_20049_("RaidMember_" + raid.getRaidId());
        henchman.m_20049_("AI_" + type.aiType().name());
        henchman.m_21530_();
        if (!type.weapons().isEmpty()) {
            Item weaponItem = type.weapons().get(level.f_46441_.m_188503_(type.weapons().size()));
            ItemStack weaponStack = this.createModifiedGun(henchman, weaponItem);
            henchman.m_8061_(EquipmentSlot.MAINHAND, weaponStack);
            henchman.m_21409_(EquipmentSlot.MAINHAND, 0.05f);
        }
        henchman.m_20049_("MobGunner");
        for (RaidConfig.ArmorEntry armorEntry : type.armor()) {
            EquipmentSlot slot;
            if (level.f_46441_.m_188501_() > armorEntry.dropChance()) continue;
            if ((slot = (switch (armorEntry.slot()) {
                case "head" -> EquipmentSlot.HEAD;
                case "chest" -> EquipmentSlot.CHEST;
                case "legs" -> EquipmentSlot.LEGS;
                case "feet" -> EquipmentSlot.FEET;
                default -> null;
            })) == null) continue;
            ItemStack armorStack = new ItemStack((ItemLike)armorEntry.item());
            if (armorEntry.nbt() != null) {
                armorStack.m_41751_(armorEntry.nbt().m_6426_());
            }
            henchman.m_8061_(slot, armorStack);
            henchman.m_21409_(slot, 0.05f);
        }
        if (henchman instanceof PathfinderMob) {
            PathfinderMob pathfinderMob = (PathfinderMob)henchman;
            ItemStack heldItem = henchman.m_21205_();
            if (heldItem.m_41720_() instanceof GunItem) {
                pathfinderMob.f_21345_.m_25352_(2, new GunAttackGoal<PathfinderMob>(pathfinderMob, heldItem, 1.2f, type.aiType(), type.aiDifficulty()));
            }
            GunnerMobSpawner.extendFollowRange(pathfinderMob);
            ServerPlayer targetPlayer = raid.getTargetPlayer(level);
            if (targetPlayer != null) {
                pathfinderMob.m_6710_((LivingEntity)targetPlayer);
            }
            if (henchman instanceof AbstractPiglin) {
                AbstractPiglin abstractPiglin = (AbstractPiglin)henchman;
                abstractPiglin.m_34670_(true);
                if (henchman instanceof Piglin) {
                    Piglin piglin = (Piglin)henchman;
                    piglin.m_21561_(true);
                }
                if (targetPlayer != null) {
                    try {
                        Brain brain = abstractPiglin.m_6274_();
                        brain.m_21936_(MemoryModuleType.f_26334_);
                        brain.m_21879_(MemoryModuleType.f_26334_, (Object)targetPlayer.m_20148_());
                        brain.m_21936_(MemoryModuleType.f_26335_);
                        brain.m_21879_(MemoryModuleType.f_26335_, (Object)true);
                        brain.m_21879_(MemoryModuleType.f_26372_, (Object)targetPlayer);
                        brain.m_21936_(MemoryModuleType.f_26368_);
                        brain.m_21879_(MemoryModuleType.f_26368_, (Object)targetPlayer);
                        abstractPiglin.m_6710_((LivingEntity)targetPlayer);
                        abstractPiglin.m_6703_((LivingEntity)targetPlayer);
                    }
                    catch (Exception e) {
                        abstractPiglin.m_6710_((LivingEntity)targetPlayer);
                    }
                }
            }
        }
        level.m_7967_((Entity)henchman);
        return henchman;
    }

    private ItemStack createModifiedGun(Mob mob, Item gun) {
        ItemStack gunStack = new ItemStack((ItemLike)gun);
        if (gun instanceof GunItem) {
            GunItem gunItem = (GunItem)gun;
            if (gunStack.m_41783_() != null) {
                Gun gunModified = gunItem.getModifiedGun(gunStack);
                gunStack.m_41783_().m_128405_("AmmoCount", mob.m_217043_().m_188503_(gunModified.getReloads().getMaxAmmo()));
            }
        }
        return gunStack;
    }

    private void applyHealthConfig(Mob mob, RaidConfig.HealthConfig healthConfig, UUID modifierUUID) {
        AttributeInstance healthAttr = mob.m_21051_(Attributes.f_22276_);
        if (healthAttr == null) {
            return;
        }
        if (healthConfig.useMultiplier()) {
            healthAttr.m_22125_(new AttributeModifier(modifierUUID, "Raid health multiplier", (double)healthConfig.healthMultiplier().floatValue() - 1.0, AttributeModifier.Operation.MULTIPLY_BASE));
        } else {
            double currentHealth = healthAttr.m_22115_();
            healthAttr.m_22125_(new AttributeModifier(modifierUUID, "Raid fixed health", (double)healthConfig.fixedHealth().floatValue() - currentHealth, AttributeModifier.Operation.ADDITION));
        }
        mob.m_21153_(mob.m_21233_());
    }

    private void applyEffects(Mob mob, List<RaidConfig.EffectEntry> effects) {
        for (RaidConfig.EffectEntry effectEntry : effects) {
            mob.m_7292_(new MobEffectInstance(effectEntry.effect(), effectEntry.duration(), effectEntry.amplifier(), effectEntry.ambient(), effectEntry.visible()));
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        Level level = event.getEntity().m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        RaidManager manager = RaidManager.get(level2);
        for (ActiveRaid raid : activeRaids.values()) {
            if (mob.m_20148_().equals(raid.getBossUUID())) {
                RaidConfig.BossData bossData = raid.getConfig().boss();
                if (bossData.specialLootTable() != null) {
                    manager.dropSpecialLoot(mob, bossData.specialLootTable(), level2);
                }
                raid.onBossDefeated();
                break;
            }
            if (!raid.getHenchmenUUIDs().contains(mob.m_20148_())) continue;
            raid.removeHenchman(mob.m_20148_());
            break;
        }
    }

    private void dropSpecialLoot(Mob boss, ResourceLocation lootTableLocation, ServerLevel level) {
        LootTable lootTable = level.m_7654_().m_278653_().m_278676_(lootTableLocation);
        LootParams.Builder builder = new LootParams.Builder(level).m_287286_(LootContextParams.f_81455_, (Object)boss).m_287286_(LootContextParams.f_81460_, (Object)boss.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)(boss.m_21225_() != null ? boss.m_21225_() : level.m_269111_().m_269264_()));
        LivingEntity livingEntity = boss.m_21232_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            builder.m_287286_(LootContextParams.f_81458_, (Object)player).m_287239_(player.m_36336_());
        }
        LootParams params = builder.m_287235_(LootContextParamSets.f_81415_);
        lootTable.m_287195_(params).forEach(itemStack -> {
            ItemEntity itemEntity = new ItemEntity((Level)level, boss.m_20185_(), boss.m_20186_(), boss.m_20189_(), itemStack);
            level.m_7967_((Entity)itemEntity);
        });
    }

    public Collection<ActiveRaid> getActiveRaids() {
        return activeRaids.values();
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        ServerLevel overworld = event.getServer().m_129783_();
        RaidManager manager = RaidManager.get(overworld);
        manager.saveActiveRaids(overworld);
        RaidSaveData.get(overworld);
        overworld.m_8895_().m_78151_();
        INSTANCES.clear();
    }
}

