/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.event;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import top.ribs.scguns.Config;
import top.ribs.scguns.ScorchedGuns;
import top.ribs.scguns.block.TemporaryLightBlock;
import top.ribs.scguns.init.ModBlocks;

public class TemporaryLightManager {
    private static final int DEFAULT_LIGHT_DURATION = 8;
    private static final int BEAM_LIGHT_DURATION = 20;
    private static final int LIGHT_LEVEL = 7;

    public static void addTemporaryLight(Level level, BlockPos pos, boolean isBeamWeapon) {
        if (level.f_46443_) {
            return;
        }
        try {
            int duration;
            boolean fireLightsEnabled;
            if (Config.CLIENT == null || Config.CLIENT.display == null) {
                return;
            }
            try {
                fireLightsEnabled = (Boolean)Config.CLIENT.display.fireLights.get();
            }
            catch (IllegalStateException e) {
                return;
            }
            if (!fireLightsEnabled) {
                return;
            }
            BlockState currentState = level.m_8055_(pos);
            if (!TemporaryLightManager.canPlaceLightAt(level, pos, currentState)) {
                return;
            }
            int n = duration = isBeamWeapon ? 20 : 8;
            if (currentState.m_60734_() instanceof TemporaryLightBlock) {
                int currentLifetime = (Integer)currentState.m_61143_((Property)TemporaryLightBlock.LIFETIME);
                int newLifetime = isBeamWeapon ? Math.min(currentLifetime + duration, 40) : duration;
                BlockState newState = (BlockState)currentState.m_61124_((Property)TemporaryLightBlock.LIFETIME, (Comparable)Integer.valueOf(newLifetime));
                level.m_7731_(pos, newState, 2);
                return;
            }
            BlockState lightState = (BlockState)((BlockState)((Block)ModBlocks.TEMPORARY_LIGHT.get()).m_49966_().m_61124_((Property)TemporaryLightBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(7))).m_61124_((Property)TemporaryLightBlock.LIFETIME, (Comparable)Integer.valueOf(duration));
            level.m_7731_(pos, lightState, 3);
            level.m_7260_(pos, currentState, lightState, 3);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_186460_(pos, (Block)ModBlocks.TEMPORARY_LIGHT.get(), 1);
            }
        }
        catch (Exception e) {
            ScorchedGuns.LOGGER.error("Error in addTemporaryLight: " + e.getMessage(), (Throwable)e);
        }
    }

    private static boolean canPlaceLightAt(Level level, BlockPos pos, BlockState currentState) {
        if (!level.m_46805_(pos)) {
            return false;
        }
        if (!currentState.m_60819_().m_76178_()) {
            return false;
        }
        if (currentState.m_60795_()) {
            return true;
        }
        if (currentState.m_60734_() instanceof TemporaryLightBlock) {
            return true;
        }
        if (currentState.m_60713_(Blocks.f_152480_)) {
            return true;
        }
        return currentState.m_247087_();
    }

    public static void emergencyCleanup(Level level) {
        if (level == null || level.f_46443_) {
            return;
        }
        try {
            ScorchedGuns.LOGGER.info("Emergency cleanup called for temporary lights in dimension: " + level.m_46472_().m_135782_());
        }
        catch (Exception e) {
            ScorchedGuns.LOGGER.error("Error during emergency cleanup: " + e.getMessage(), (Throwable)e);
        }
    }
}

