/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.fluid;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.fluids.FluidType;
import top.ribs.scguns.init.ModBlocks;
import top.ribs.scguns.init.ModFluids;
import top.ribs.scguns.init.ModItems;

public abstract class ViciousAcidFluid
extends FlowingFluid {
    public Fluid m_5615_() {
        return (Fluid)ModFluids.VICIOUS_ACID_FLOWING.get();
    }

    public Fluid m_5613_() {
        return (Fluid)ModFluids.VICIOUS_ACID_SOURCE.get();
    }

    public Item m_6859_() {
        return (Item)ModItems.VICIOUS_ACID_BUCKET.get();
    }

    protected boolean m_6760_(Level level) {
        return false;
    }

    protected void m_7456_(LevelAccessor level, BlockPos pos, BlockState state) {
        Block.m_49892_((BlockState)state, (LevelAccessor)level, (BlockPos)pos, (BlockEntity)level.m_7702_(pos));
    }

    private static void reactWithSurroundings(Level level, BlockPos pos) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        for (Direction direction : Direction.values()) {
            BlockPos adjacentPos = pos.m_121945_(direction);
            FluidState adjacentFluid = level.m_6425_(adjacentPos);
            BlockState adjacentState = level.m_8055_(adjacentPos);
            if (adjacentFluid.m_205070_(FluidTags.f_13132_) || adjacentState.m_60713_(Blocks.f_50083_)) {
                level.m_7731_(adjacentPos, Blocks.f_50016_.m_49966_(), 3);
                level.m_254849_(null, (double)adjacentPos.m_123341_() + 0.5, (double)adjacentPos.m_123342_() + 0.5, (double)adjacentPos.m_123343_() + 0.5, 2.0f, Level.ExplosionInteraction.BLOCK);
                return;
            }
            if (!adjacentFluid.m_205070_(FluidTags.f_13131_)) continue;
            level.m_7731_(adjacentPos, Blocks.f_50377_.m_49966_(), 3);
            level.m_5594_(null, adjacentPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.8f);
            for (int i = 0; i < 8; ++i) {
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)adjacentPos.m_123341_() + 0.5, (double)adjacentPos.m_123342_() + 1.0, (double)adjacentPos.m_123343_() + 0.5, 1, 0.3, 0.3, 0.3, 0.0);
            }
        }
    }

    protected int m_6719_(LevelReader level) {
        return 4;
    }

    protected int m_6713_(LevelReader level) {
        return 1;
    }

    public int m_6718_(LevelReader level) {
        return 5;
    }

    protected float m_6752_() {
        return 100.0f;
    }

    protected BlockState m_5804_(FluidState state) {
        return (BlockState)((LiquidBlock)ModBlocks.VICIOUS_ACID_BLOCK.get()).m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(ViciousAcidFluid.m_76092_((FluidState)state)));
    }

    public boolean m_6212_(Fluid fluid) {
        return fluid == ModFluids.VICIOUS_ACID_SOURCE.get() || fluid == ModFluids.VICIOUS_ACID_FLOWING.get();
    }

    public FluidType getFluidType() {
        return (FluidType)ModFluids.VICIOUS_ACID_FLUID_TYPE.get();
    }

    public static class Flowing
    extends ViciousAcidFluid {
        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
        }

        protected boolean m_5486_(FluidState pState, BlockGetter pLevel, BlockPos pPos, Fluid pFluid, Direction pDirection) {
            return false;
        }

        public void m_6292_(Level level, BlockPos pos, FluidState state) {
            ViciousAcidFluid.reactWithSurroundings(level, pos);
            super.m_6292_(level, pos, state);
        }

        public int m_7430_(FluidState state) {
            return (Integer)state.m_61143_((Property)f_75948_);
        }

        public boolean m_7444_(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends ViciousAcidFluid {
        public int m_7430_(FluidState state) {
            return 8;
        }

        protected boolean m_5486_(FluidState pState, BlockGetter pLevel, BlockPos pPos, Fluid pFluid, Direction pDirection) {
            return false;
        }

        public void m_6292_(Level level, BlockPos pos, FluidState state) {
            ViciousAcidFluid.reactWithSurroundings(level, pos);
            super.m_6292_(level, pos, state);
        }

        public boolean m_7444_(FluidState state) {
            return true;
        }
    }
}

