/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.mixin.common;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import top.ribs.scguns.entity.projectile.ProjectileEntity;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Unique
    private DamageSource scorched_Guns_1_20_1$currentDamageSource;
    @Unique
    private static final Map<UUID, Long> scorched_Guns_1_20_1$knockbackCooldowns = new HashMap<UUID, Long>();
    @Unique
    private static final int KNOCKBACK_COOLDOWN_TICKS = 10;

    @Inject(method={"hurt"}, at={@At(value="HEAD")})
    private void onHurtStart(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.scorched_Guns_1_20_1$currentDamageSource = source;
    }

    @ModifyArg(method={"hurt"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;knockback(DDD)V"), index=0)
    private double modifyApplyKnockbackArgs(double original) {
        Entity entity;
        if (this.scorched_Guns_1_20_1$currentDamageSource != null && (entity = this.scorched_Guns_1_20_1$currentDamageSource.m_7640_()) instanceof ProjectileEntity) {
            ProjectileEntity projectile = (ProjectileEntity)entity;
            LivingEntity entity2 = (LivingEntity)this;
            UUID entityId = entity2.m_20148_();
            long currentTick = entity2.m_9236_().m_46467_();
            Long lastKnockbackTick = scorched_Guns_1_20_1$knockbackCooldowns.get(entityId);
            if (lastKnockbackTick != null && currentTick - lastKnockbackTick < 10L) {
                return 0.0;
            }
            scorched_Guns_1_20_1$knockbackCooldowns.put(entityId, currentTick);
            scorched_Guns_1_20_1$knockbackCooldowns.entrySet().removeIf(entry -> currentTick - (Long)entry.getValue() > 100L);
            return projectile.getModifiedKnockback();
        }
        return original;
    }
}

