/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.network.message;

import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import top.ribs.scguns.common.exosuit.ExoSuitData;
import top.ribs.scguns.common.exosuit.ExoSuitPouchHandler;
import top.ribs.scguns.common.exosuit.ExoSuitPowerManager;
import top.ribs.scguns.common.exosuit.ExoSuitUpgrade;
import top.ribs.scguns.common.exosuit.ExoSuitUpgradeManager;
import top.ribs.scguns.item.animated.ExoSuitItem;

public class C2SMessageUtilityAction
extends PlayMessage<C2SMessageUtilityAction> {
    public void encode(C2SMessageUtilityAction message, FriendlyByteBuf buffer) {
    }

    public C2SMessageUtilityAction decode(FriendlyByteBuf buffer) {
        return new C2SMessageUtilityAction();
    }

    public void handle(C2SMessageUtilityAction message, MessageContext context) {
        context.execute(() -> {
            ServerPlayer player = context.getPlayer();
            if (player == null) {
                return;
            }
            ItemStack chestplate = player.m_150109_().m_36052_(2);
            if (!(chestplate.m_41720_() instanceof ExoSuitItem)) {
                return;
            }
            ItemStack utilityUpgrade = ExoSuitData.getUpgradeInSlot(chestplate, 3);
            if (utilityUpgrade.m_41619_()) {
                return;
            }
            ExoSuitUpgrade upgrade = ExoSuitUpgradeManager.getUpgradeForItem(utilityUpgrade);
            if (upgrade == null) {
                return;
            }
            if (upgrade.getEffects().hasFlight()) {
                this.handleJetpackToggle(player);
            } else if (upgrade.getType().equals("pouches")) {
                ExoSuitPouchHandler.openPouchInventory(player);
            } else if (upgrade.getType().equals("utility") && upgrade.getDisplay().getStorageSize() > 0) {
                ExoSuitPouchHandler.openPouchInventory(player);
            } else {
                MutableComponent feedbackMessage = Component.m_237115_((String)"exosuit.message.prefix").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237115_((String)"exosuit.message.no_action").m_130940_(ChatFormatting.GRAY));
                player.m_240418_((Component)feedbackMessage, true);
            }
        });
        context.setHandled(true);
    }

    private void handleJetpackToggle(ServerPlayer player) {
        if (!ExoSuitPowerManager.canUpgradeFunction((Player)player, "utility")) {
            MutableComponent feedbackMessage = Component.m_237115_((String)"exosuit.message.prefix").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237110_((String)"exosuit.message.not_available", (Object[])new Object[]{Component.m_237115_((String)"exosuit.upgrade.jetpack")}).m_130940_(ChatFormatting.RED));
            player.m_240418_((Component)feedbackMessage, true);
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 0.5f, 0.8f);
            return;
        }
        boolean newState = ExoSuitPowerManager.togglePower((Player)player, "utility");
        String statusKey = newState ? "exosuit.message.enabled" : "exosuit.message.disabled";
        ChatFormatting statusColor = newState ? ChatFormatting.GREEN : ChatFormatting.RED;
        MutableComponent feedbackMessage = Component.m_237115_((String)"exosuit.message.prefix").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237110_((String)statusKey, (Object[])new Object[]{Component.m_237115_((String)"exosuit.upgrade.jetpack")}).m_130940_(statusColor));
        player.m_240418_((Component)feedbackMessage, true);
        if (newState) {
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.3f, 1.2f);
        } else {
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.3f, 0.8f);
        }
    }
}

