/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns;

import com.mrcrayfish.framework.api.FrameworkAPI;
import it.crystalnest.soul_fire_d.api.FireManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.ribs.scguns.Config;
import top.ribs.scguns.attributes.SCAttributes;
import top.ribs.scguns.client.ClientHandler;
import top.ribs.scguns.client.CustomGunManager;
import top.ribs.scguns.client.handler.BeamHandler;
import top.ribs.scguns.client.handler.BulletTrailRenderingHandler;
import top.ribs.scguns.client.handler.HUDRenderHandler;
import top.ribs.scguns.client.handler.InspectHandler;
import top.ribs.scguns.client.handler.RecoilHandler;
import top.ribs.scguns.client.screen.ModMenuTypes;
import top.ribs.scguns.common.BoundingBoxManager;
import top.ribs.scguns.common.NetworkGunManager;
import top.ribs.scguns.common.ProjectileManager;
import top.ribs.scguns.common.TurretManager;
import top.ribs.scguns.common.VentManager;
import top.ribs.scguns.common.exosuit.ExoSuitUpgradeManager;
import top.ribs.scguns.compat.CompatManager;
import top.ribs.scguns.compat.CreateModCondition;
import top.ribs.scguns.compat.FarmersDelightModCondition;
import top.ribs.scguns.compat.IEModCondition;
import top.ribs.scguns.compat.SoulFiredModCondition;
import top.ribs.scguns.config.EliteTierConfig;
import top.ribs.scguns.config.EntityEquipmentConfig;
import top.ribs.scguns.config.GunMobValues;
import top.ribs.scguns.config.GunnerMobConfig;
import top.ribs.scguns.config.GunnerMobSpawner;
import top.ribs.scguns.config.MerchantTradeConfig;
import top.ribs.scguns.config.ProjectileAdvantageConfig;
import top.ribs.scguns.config.RaidConfig;
import top.ribs.scguns.config.RaidFlareConfig;
import top.ribs.scguns.config.TieredWeaponConfig;
import top.ribs.scguns.entity.player.GunTierRegistry;
import top.ribs.scguns.entity.player.GunTiers;
import top.ribs.scguns.entity.projectile.AdvancedRoundProjectileEntity;
import top.ribs.scguns.entity.projectile.BasicBulletProjectileEntity;
import top.ribs.scguns.entity.projectile.BearPackShellProjectileEntity;
import top.ribs.scguns.entity.projectile.BeowulfProjectileEntity;
import top.ribs.scguns.entity.projectile.BlazeRodProjectileEntity;
import top.ribs.scguns.entity.projectile.BuckshotProjectileEntity;
import top.ribs.scguns.entity.projectile.FireRoundEntity;
import top.ribs.scguns.entity.projectile.FlechetteProjectileEntity;
import top.ribs.scguns.entity.projectile.FrogDartProjectileEntity;
import top.ribs.scguns.entity.projectile.GibbsRoundProjectileEntity;
import top.ribs.scguns.entity.projectile.HardenedBulletProjectileEntity;
import top.ribs.scguns.entity.projectile.HogRoundProjectileEntity;
import top.ribs.scguns.entity.projectile.KrahgRoundProjectileEntity;
import top.ribs.scguns.entity.projectile.LightningProjectileEntity;
import top.ribs.scguns.entity.projectile.MicroJetEntity;
import top.ribs.scguns.entity.projectile.NeedleProjectileEntity;
import top.ribs.scguns.entity.projectile.OsborneSlugProjectileEntity;
import top.ribs.scguns.entity.projectile.PlasmaProjectileEntity;
import top.ribs.scguns.entity.projectile.ProjectileEntity;
import top.ribs.scguns.entity.projectile.RamrodProjectileEntity;
import top.ribs.scguns.entity.projectile.RocketEntity;
import top.ribs.scguns.entity.projectile.SculkCellEntity;
import top.ribs.scguns.entity.projectile.ShatterRoundProjectileEntity;
import top.ribs.scguns.entity.projectile.ShotballProjectileEntity;
import top.ribs.scguns.entity.projectile.ShulkshotProjectileEntity;
import top.ribs.scguns.entity.projectile.SyringeProjectileEntity;
import top.ribs.scguns.entity.throwable.GrenadeEntity;
import top.ribs.scguns.event.ModCommandsRegister;
import top.ribs.scguns.event.OceanWeaponEventHandler;
import top.ribs.scguns.event.PiglinWeaponEventHandler;
import top.ribs.scguns.event.SculkHordeEvents;
import top.ribs.scguns.event.TemporaryLightManager;
import top.ribs.scguns.event.WeaponMovementEventHandler;
import top.ribs.scguns.init.ModBlockEntities;
import top.ribs.scguns.init.ModBlocks;
import top.ribs.scguns.init.ModContainers;
import top.ribs.scguns.init.ModCreativeModeTabs;
import top.ribs.scguns.init.ModEffects;
import top.ribs.scguns.init.ModEnchantments;
import top.ribs.scguns.init.ModEntities;
import top.ribs.scguns.init.ModFeatures;
import top.ribs.scguns.init.ModFluids;
import top.ribs.scguns.init.ModItems;
import top.ribs.scguns.init.ModLootModifiers;
import top.ribs.scguns.init.ModPaintings;
import top.ribs.scguns.init.ModParticleTypes;
import top.ribs.scguns.init.ModPointOfInterestTypes;
import top.ribs.scguns.init.ModRecipes;
import top.ribs.scguns.init.ModSounds;
import top.ribs.scguns.init.ModStructures;
import top.ribs.scguns.init.ModSyncedDataKeys;
import top.ribs.scguns.init.ModVillagers;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.util.ModCauldronInteraction;
import top.ribs.scguns.world.VillageStructures;

@Mod(value="scguns")
public class ScorchedGuns {
    public static final String MODID = "scguns";
    public static final Logger LOGGER = LogManager.getLogger((String)"scguns");
    public static boolean backpackedLoaded;
    public static boolean curiosLoaded;
    public static boolean controllableLoaded;
    public static boolean playerReviveLoaded;
    public static boolean createLoaded;
    public static boolean farmersDelightLoaded;
    public static boolean mekanismLoaded;
    public static boolean ieLoaded;
    public static boolean valkyrienSkiesLoaded;
    public static boolean soulFiredLoaded;
    public static boolean shoulderSurfingLoaded;

    public ScorchedGuns() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.clientSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.serverSpec);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::onConfigLoad);
        ModItems.REGISTER.register(bus);
        ModRecipes.register(modEventBus);
        SCAttributes.ATTRIBUTES.register(modEventBus);
        this.initializeModDependencies();
        ModItems.registerItems();
        MinecraftForge.EVENT_BUS.addListener(VillageStructures::addNewVillageBuilding);
        ModCreativeModeTabs.register(bus);
        ModBlockEntities.BLOCK_ENTITIES.register(bus);
        ModBlocks.REGISTER.register(bus);
        ModContainers.REGISTER.register(bus);
        ModEffects.REGISTER.register(bus);
        ModMenuTypes.register(bus);
        ModEnchantments.REGISTER.register(bus);
        ModEntities.REGISTER.register(bus);
        ModParticleTypes.REGISTER.register(bus);
        ModRecipes.register(bus);
        ModSounds.REGISTER.register(bus);
        ModVillagers.register(bus);
        ModFeatures.register(bus);
        ModFluids.FLUID_TYPES.register(modEventBus);
        ModFluids.FLUIDS.register(modEventBus);
        ModLootModifiers.LOOT_MODIFIERS.register(bus);
        ModPointOfInterestTypes.REGISTER.register(bus);
        ModRecipes.register(modEventBus);
        ModPaintings.REGISTER.register(modEventBus);
        ModStructures.REGISTRY.register(bus);
        bus.addListener(this::onCommonSetup);
        MinecraftForge.EVENT_BUS.register((Object)new GunnerMobSpawner());
        MinecraftForge.EVENT_BUS.register((Object)new ModCommandsRegister());
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ClientHandler.registerClientHandlers(bus);
            MinecraftForge.EVENT_BUS.register(HUDRenderHandler.class);
            MinecraftForge.EVENT_BUS.register((Object)InspectHandler.get());
            CraftingHelper.register((IConditionSerializer)CreateModCondition.Serializer.INSTANCE);
            CraftingHelper.register((IConditionSerializer)FarmersDelightModCondition.Serializer.INSTANCE);
            CraftingHelper.register((IConditionSerializer)IEModCondition.Serializer.INSTANCE);
            CraftingHelper.register((IConditionSerializer)SoulFiredModCondition.Serializer.INSTANCE);
            MinecraftForge.EVENT_BUS.register(BeamHandler.class);
            MinecraftForge.EVENT_BUS.register((Object)BulletTrailRenderingHandler.get());
        });
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register(WeaponMovementEventHandler.class);
        MinecraftForge.EVENT_BUS.register(OceanWeaponEventHandler.class);
        MinecraftForge.EVENT_BUS.register(PiglinWeaponEventHandler.class);
        MinecraftForge.EVENT_BUS.register(MerchantTradeConfig.class);
        MinecraftForge.EVENT_BUS.register(GunnerMobConfig.class);
        MinecraftForge.EVENT_BUS.register(TieredWeaponConfig.class);
        MinecraftForge.EVENT_BUS.register(EliteTierConfig.class);
        MinecraftForge.EVENT_BUS.register(EntityEquipmentConfig.class);
        MinecraftForge.EVENT_BUS.register(ProjectileAdvantageConfig.class);
        MinecraftForge.EVENT_BUS.register(TurretManager.class);
        MinecraftForge.EVENT_BUS.register(VentManager.class);
        MinecraftForge.EVENT_BUS.register(RaidConfig.class);
        MinecraftForge.EVENT_BUS.register(RaidFlareConfig.class);
        if (CompatManager.SCULK_HORDE_LOADED) {
            MinecraftForge.EVENT_BUS.register(SculkHordeEvents.class);
        }
    }

    private void onConfigLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> RecoilHandler.get().updateConfig());
        }
    }

    private void initializeModDependencies() {
        valkyrienSkiesLoaded = ModList.get().isLoaded("valkyrienskies");
        controllableLoaded = ModList.get().isLoaded("controllable");
        backpackedLoaded = ModList.get().isLoaded("backpacked");
        curiosLoaded = ModList.get().isLoaded("curios");
        playerReviveLoaded = ModList.get().isLoaded("playerrevive");
        createLoaded = ModList.get().isLoaded("create");
        farmersDelightLoaded = ModList.get().isLoaded("farmersdelight");
        ieLoaded = ModList.get().isLoaded("immersiveengineering");
        mekanismLoaded = ModList.get().isLoaded("mekanism");
        soulFiredLoaded = ModList.get().isLoaded("soul_fire_d");
        shoulderSurfingLoaded = ModList.get().isLoaded("shouldersurfing");
    }

    public static void setSoulFireOnEntity(Entity entity, int seconds) {
        if (soulFiredLoaded) {
            try {
                FireManager.setOnFire((Entity)entity, (int)seconds, (ResourceLocation)FireManager.SOUL_FIRE_TYPE);
            }
            catch (Exception e) {
                entity.m_20254_(seconds);
            }
        } else {
            entity.m_20254_(seconds);
        }
    }

    @SubscribeEvent
    public void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new ExoSuitUpgradeManager());
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            GunTiers.init();
            GunTierRegistry.lock();
            PacketHandler.init();
            GunMobValues.init();
            FrameworkAPI.registerSyncedDataKey(ModSyncedDataKeys.AIMING);
            FrameworkAPI.registerSyncedDataKey(ModSyncedDataKeys.RELOADING);
            FrameworkAPI.registerSyncedDataKey(ModSyncedDataKeys.SHOOTING);
            FrameworkAPI.registerSyncedDataKey(ModSyncedDataKeys.BURSTCOUNT);
            FrameworkAPI.registerSyncedDataKey(ModSyncedDataKeys.ONBURSTCOOLDOWN);
            FrameworkAPI.registerSyncedDataKey(ModSyncedDataKeys.MELEE);
            ModCauldronInteraction.register();
            MinecraftForge.EVENT_BUS.register(TemporaryLightManager.class);
            FrameworkAPI.registerLoginData((ResourceLocation)new ResourceLocation(MODID, "network_gun_manager"), NetworkGunManager.LoginData::new);
            FrameworkAPI.registerLoginData((ResourceLocation)new ResourceLocation(MODID, "custom_gun_manager"), CustomGunManager.LoginData::new);
            ProjectileManager.getInstance().registerFactory((Item)ModItems.POWDER_AND_BALL.get(), (worldIn, entity, weapon, item, modifiedGun) -> new ProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.GRAPESHOT.get(), (worldIn, entity, weapon, item, modifiedGun) -> new ProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.COMPACT_COPPER_ROUND.get(), (worldIn, entity, weapon, item, modifiedGun) -> new ProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.HOG_ROUND.get(), (worldIn, entity, weapon, item, modifiedGun) -> new HogRoundProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.HOG_ROUND_PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.STANDARD_COPPER_ROUND.get(), (worldIn, entity, weapon, item, modifiedGun) -> new ProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.COMPACT_ADVANCED_ROUND.get(), (worldIn, entity, weapon, item, modifiedGun) -> new ProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.RAMROD_ROUND.get(), (worldIn, entity, weapon, item, modifiedGun) -> new RamrodProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.RAMROD_PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.ADVANCED_ROUND.get(), (worldIn, entity, weapon, item, modifiedGun) -> new AdvancedRoundProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.ADVANCED_ROUND_PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.SHATTER_ROUND.get(), (worldIn, entity, weapon, item, modifiedGun) -> new ShatterRoundProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.SHATTER_ROUND_PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.KRAHG_ROUND.get(), (worldIn, entity, weapon, item, modifiedGun) -> new KrahgRoundProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.KRAHG_ROUND_PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.BEOWULF_ROUND.get(), (worldIn, entity, weapon, item, modifiedGun) -> new BeowulfProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.BEOWULF_PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.GIBBS_ROUND.get(), (worldIn, entity, weapon, item, modifiedGun) -> new GibbsRoundProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.GIBBS_ROUND_PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.SHOTGUN_SHELL.get(), (worldIn, entity, weapon, item, modifiedGun) -> new ProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.BEARPACK_SHELL.get(), (worldIn, entity, weapon, item, modifiedGun) -> new BearPackShellProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.BEARPACK_SHELL_PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.BLAZE_FUEL.get(), (worldIn, entity, weapon, item, modifiedGun) -> new FireRoundEntity((EntityType<? extends Entity>)((EntityType)ModEntities.FIRE_ROUND_PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.SCULK_CELL.get(), (worldIn, entity, weapon, item, modifiedGun) -> new SculkCellEntity((EntityType<? extends ProjectileEntity>)((EntityType)ModEntities.SCULK_CELL.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.SHOCK_CELL.get(), (worldIn, entity, weapon, item, modifiedGun) -> new LightningProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.SHULKSHOT.get(), (worldIn, entity, weapon, item, modifiedGun) -> new ShulkshotProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.SHULKSHOT.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.ENERGY_CELL.get(), (worldIn, entity, weapon, item, modifiedGun) -> new PlasmaProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.PLASMA_PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.OSBORNE_SLUG.get(), (worldIn, entity, weapon, item, modifiedGun) -> new OsborneSlugProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.OSBORNE_SLUG_PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory(Items.f_42585_, (worldIn, entity, weapon, item, modifiedGun) -> new BlazeRodProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.BLAZE_ROD_PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.SYRINGE.get(), (worldIn, entity, weapon, item, modifiedGun) -> new SyringeProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.SYRINGE_PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.STANDARD_BULLET.get(), (worldIn, entity, weapon, item, modifiedGun) -> new BasicBulletProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.BASIC_BULLET_PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.ADVANCED_BULLET.get(), (worldIn, entity, weapon, item, modifiedGun) -> new HardenedBulletProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.HARDENED_BULLET_PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.NEEDLE.get(), (worldIn, entity, weapon, item, modifiedGun) -> new NeedleProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.NEEDLE_PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.FLECHETTE.get(), (worldIn, entity, weapon, item, modifiedGun) -> new FlechetteProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.FLECHETTE_PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.BUCKSHOT.get(), (worldIn, entity, weapon, item, modifiedGun) -> new BuckshotProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.BUCKSHOT_PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.NITRO_BUCKSHOT.get(), (worldIn, entity, weapon, item, modifiedGun) -> new BuckshotProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.BUCKSHOT_PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.SHOTBALL.get(), (worldIn, entity, weapon, item, modifiedGun) -> new ShotballProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.SHOTBALL_PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.ROCKET.get(), (worldIn, entity, weapon, item, modifiedGun) -> new RocketEntity((EntityType<? extends ProjectileEntity>)((EntityType)ModEntities.ROCKET.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.MICROJET.get(), (worldIn, entity, weapon, item, modifiedGun) -> new MicroJetEntity((EntityType<? extends ProjectileEntity>)((EntityType)ModEntities.MICROJET.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.GRENADE.get(), (worldIn, entity, weapon, item, modifiedGun) -> new GrenadeEntity((EntityType<? extends ProjectileEntity>)((EntityType)ModEntities.GRENADE.get()), worldIn, entity, weapon, item, modifiedGun));
            ProjectileManager.getInstance().registerFactory((Item)ModItems.FROG_DART.get(), (worldIn, entity, weapon, item, modifiedGun) -> new FrogDartProjectileEntity((EntityType<? extends Entity>)((EntityType)ModEntities.FROG_DART_PROJECTILE.get()), worldIn, entity, weapon, item, modifiedGun));
            if (((Boolean)Config.COMMON.gameplay.improvedHitboxes.get()).booleanValue()) {
                MinecraftForge.EVENT_BUS.register((Object)new BoundingBoxManager());
            }
        });
    }

    public static boolean isDebugging() {
        return false;
    }

    static {
        shoulderSurfingLoaded = false;
    }
}

