/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.block;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.block.SulfurLayerBlock;
import top.ribs.scguns.block.VentBlock;
import top.ribs.scguns.common.SulfurGasCloud;
import top.ribs.scguns.init.ModBlocks;
import top.ribs.scguns.init.ModParticleTypes;

public class SulfurVentBlock
extends VentBlock {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int CLOUD_RADIUS = 8;
    private static final int MAX_DUST_PARTICLES_PER_TICK = 10;
    private static final int CLOUD_SPAWN_CHANCE = 95;
    private static final int DUST_SPAWN_CHANCE = 98;
    private static final int EFFECT_INTERVAL = 10;
    public static final int EFFECT_RADIUS = 8;
    public static final int MAX_ACTIVE_VENTS = 1;
    public static final int CHECK_RADIUS = 32;
    public static final int EFFECT_RADIUS_SQUARED = 64;

    public SulfurVentBlock(BlockBehaviour.Properties properties) {
        super(properties, new ResourceLocation("scguns", "sulfur_vent"));
    }

    @Override
    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!world.f_46443_) {
            if (((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
                Vec3 center = Vec3.m_82512_((Vec3i)pos);
                if (SulfurGasCloud.checkAndHandleFireExplosion((Level)world, center, 8.0)) {
                    this.shutdownVentTemporarily((Level)world, pos, state);
                    return;
                }
                boolean hasCollectorAbove = this.hasVentCollectorAbove((LevelReader)world, pos);
                if (state.m_61143_((Property)VENT_TYPE) == VentBlock.VentType.BASE && !hasCollectorAbove) {
                    this.spawnSulfurCloud((Level)world, pos, random);
                    this.spawnSulfurDust((Level)world, pos, random);
                    this.performEnvironmentalAction(world, pos, center, random);
                }
            } else {
                return;
            }
            this.applyEffectsToEntities(world, pos);
            world.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.SULFUR_SMOKE.get()), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1, 0.5, 0.5, 0.5, 0.01);
            world.m_186460_(pos, (Block)this, 10);
            if (world.m_46467_() % (long)this.calculateNextTickInterval() == 0L) {
                this.scheduleParticleSpawn(world, pos);
            }
        }
    }

    private void shutdownVentTemporarily(Level level, BlockPos pos, BlockState state) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
        level.m_7260_(pos, state, state, 2);
        level.m_186460_(pos, (Block)this, 100);
    }

    private void performEnvironmentalAction(ServerLevel world, BlockPos pos, Vec3 center, RandomSource random) {
        SulfurGasCloud.destroyNatureInArea((Level)world, center, 8.0, random);
        if (this.config != null && this.config.getPlacement().isEnabled() && this.shouldPlaceBlock(random)) {
            this.placeLayerBlock(world, pos, random);
        }
    }

    private boolean shouldPlaceBlock(RandomSource random) {
        if (this.config == null) {
            return true;
        }
        return random.m_188501_() < this.config.getPlacement().getPlacementChance();
    }

    private void placeLayerBlock(ServerLevel world, BlockPos pos, RandomSource random) {
        if (this.config == null) {
            return;
        }
        ResourceLocation blockToPlace = this.config.getPlacement().getBlockToPlace();
        if (blockToPlace == null) {
            return;
        }
        Block layerBlock = blockToPlace.toString().equals("scguns:sulfur_layer") ? (Block)ModBlocks.SULFUR_LAYER.get() : (blockToPlace.toString().equals("scguns:niter_layer") ? (Block)ModBlocks.NITER_LAYER.get() : (Block)ForgeRegistries.BLOCKS.getValue(blockToPlace));
        if (layerBlock == null || layerBlock == Blocks.f_50016_) {
            LOGGER.warn("Could not resolve block: {}", (Object)blockToPlace);
            return;
        }
        int radius = this.config.getPlacement().getRadius();
        double angle = random.m_188500_() * 2.0 * Math.PI;
        double distance = Math.sqrt(random.m_188500_()) * (double)radius;
        int x = (int)Math.round(Math.cos(angle) * distance);
        int z = (int)Math.round(Math.sin(angle) * distance);
        int y = random.m_188503_(3) - 1;
        BlockPos randomPos = pos.m_7918_(x, y, z);
        if (this.canPlaceLayerBlock(world, randomPos, layerBlock)) {
            BlockPos abovePos = randomPos.m_7494_();
            BlockState currentState = world.m_8055_(abovePos);
            boolean isWater = currentState.m_60819_().m_205070_(FluidTags.f_13131_);
            if (currentState.m_60795_() || isWater) {
                BlockState layerState = layerBlock.m_49966_();
                if (layerState.m_61138_((Property)SulfurLayerBlock.f_56581_)) {
                    layerState = (BlockState)layerState.m_61124_((Property)SulfurLayerBlock.f_56581_, (Comparable)Integer.valueOf(1));
                }
                world.m_7731_(abovePos, layerState, 3);
            }
        }
    }

    private boolean canPlaceLayerBlock(ServerLevel world, BlockPos pos, Block layerBlock) {
        BlockState state = world.m_8055_(pos);
        BlockState aboveState = world.m_8055_(pos.m_7494_());
        return state.m_60783_((BlockGetter)world, pos, Direction.UP) && (aboveState.m_60795_() || aboveState.m_60819_().m_205070_(FluidTags.f_13131_)) && !(state.m_60734_() instanceof SulfurVentBlock) && !(aboveState.m_60734_() instanceof SulfurVentBlock);
    }

    @Override
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    private void spawnSulfurCloud(Level level, BlockPos pos, RandomSource random) {
        if (random.m_188503_(100) >= 95) {
            return;
        }
        Vec3 center = Vec3.m_82512_((Vec3i)pos);
        float intensity = random.m_188501_() * 0.5f + 0.5f;
        SulfurGasCloud.spawnEnhancedGasCloud(level, center, 8.0, intensity, random);
        if ((double)random.m_188501_() < 0.2) {
            double x = (double)pos.m_123341_() + 0.5 + (random.m_188500_() - 0.5) * 2.0;
            double y = (double)pos.m_123342_() + 0.5 + random.m_188500_();
            double z = (double)pos.m_123343_() + 0.5 + (random.m_188500_() - 0.5) * 2.0;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                List nearbyPlayers = serverLevel.m_45976_(ServerPlayer.class, new AABB((double)(pos.m_123341_() - 256), (double)(pos.m_123342_() - 256), (double)(pos.m_123343_() - 256), (double)(pos.m_123341_() + 256), (double)(pos.m_123342_() + 256), (double)(pos.m_123343_() + 256)));
                for (ServerPlayer player : nearbyPlayers) {
                    serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123762_, true, x, y, z, 1, 0.0, 0.05, 0.0, 0.1);
                }
            }
        }
    }

    private void spawnSulfurDust(Level level, BlockPos pos, RandomSource random) {
        if (random.m_188503_(100) >= 98) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 center = Vec3.m_82512_((Vec3i)pos);
            int particlesToSpawn = random.m_188503_(10) + 5;
            SulfurGasCloud.spawnDustParticlesForced(serverLevel, center, 9.6, particlesToSpawn, random);
        }
    }

    private void applyEffectsToEntities(ServerLevel world, BlockPos pos) {
        SulfurGasCloud.applyGasEffects((Level)world, pos, 8.0, 400, 1);
    }

    private void scheduleParticleSpawn(ServerLevel world, BlockPos pos) {
        world.m_7260_(pos, world.m_8055_(pos), world.m_8055_(pos), 2);
    }

    public void m_214162_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        double offsetZ;
        double offsetY;
        double offsetX;
        int i;
        if (!this.isTopOrBaseWithoutTop(state, level, pos) || !((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
            return;
        }
        if (!this.shouldShowParticles()) {
            return;
        }
        this.playAmbientSound(level, pos, random);
        for (i = 0; i < random.m_188503_(2) + 2; ++i) {
            offsetX = random.m_188500_() * 0.05 - 0.025;
            offsetY = 0.05 + random.m_188500_() * 0.05;
            offsetZ = random.m_188500_() * 0.05 - 0.025;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, offsetX, offsetY, offsetZ);
        }
        for (i = 0; i < random.m_188503_(2) + 2; ++i) {
            offsetX = random.m_188500_() * 0.2 - 0.1;
            offsetY = 0.05 + random.m_188500_() * 0.05;
            offsetZ = random.m_188500_() * 0.2 - 0.1;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, offsetX, offsetY, offsetZ);
        }
        for (i = 0; i < random.m_188503_(2) + 1; ++i) {
            offsetX = random.m_188500_() * 0.05 - 0.025;
            offsetY = 0.2 + random.m_188500_() * 0.2;
            offsetZ = random.m_188500_() * 0.05 - 0.025;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, offsetX, offsetY, offsetZ);
        }
    }

    @Override
    protected boolean isActive(LevelAccessor level, BlockPos pos) {
        if (this.config == null) {
            this.reloadConfig();
            if (this.config == null) {
                return false;
            }
        }
        BlockPos basePos = this.getBasePos(level, pos);
        BlockState belowState = level.m_8055_(basePos.m_7495_());
        ResourceLocation configBaseBlock = this.config.getActivation().getBaseBlock();
        Block baseBlock = (Block)ForgeRegistries.BLOCKS.getValue(configBaseBlock);
        if (baseBlock == null || !belowState.m_60713_(baseBlock)) {
            return false;
        }
        int activeVentCount = this.countActiveVentsNearby(level, basePos);
        return activeVentCount < 1;
    }

    private int countActiveVentsNearby(LevelAccessor level, BlockPos pos) {
        int activeCount = 0;
        for (BlockPos checkPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-32, -32, -32), (BlockPos)pos.m_7918_(32, 32, 32))) {
            if (checkPos.equals((Object)pos)) continue;
            BlockState state = level.m_8055_(checkPos);
            if (state.m_60734_() instanceof SulfurVentBlock && ((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue() && state.m_61143_((Property)VENT_TYPE) == VentBlock.VentType.BASE) {
                ++activeCount;
            }
            if (activeCount < 1) continue;
            return activeCount;
        }
        return activeCount;
    }

    @Override
    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        Player player;
        super.m_6807_(state, level, pos, oldState, isMoving);
        BlockPos basePos = this.getBasePos((LevelAccessor)level, pos);
        int activeVentCount = this.countActiveVentsNearby((LevelAccessor)level, basePos);
        if (activeVentCount >= 1 && state.m_61143_((Property)VENT_TYPE) == VentBlock.VentType.BASE && (player = level.m_45924_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 5.0, false)) != null) {
            player.m_5661_((Component)Component.m_237115_((String)"message.sulfur_vent.too_many_active").m_130940_(ChatFormatting.RED), true);
        }
    }
}

